// ============================================================
// LightNotify
// ============================================================

class LightNotify expands SpawnNotify;

function prebeginplay(); //don't check for relevance

simulated function PostBeginPlay()
{
	local actor other;

	//Don't add to notifylist if server, but keep available, so it's existence is replicated to clients
	if (Level.NetMode == NM_DedicatedServer) //mutator works on server. We keep moving in client
		return;
	Super.PostBeginPlay(); //add.
	log ("Light Notify Initialized...");
	ForEach Allactors(class'actor',other)
	{
		if ( Other.Class == Class 'DistanceLightning' ) //Ruin f..g trash
		{
			Other.bAlwaysRelevant=True; //Update if needs?
			Other.DrawType=DT_Mesh;
			Other.Mesh=LodMesh'UnrealShare.CandleM';
			Other.LightBrightness = 0;
			Other.LightHue = 0;
			Other.LightSaturation = 0;
			Other.LightRadius = 0;
			Other.LightPeriod = 0;
			Other.LightPhase = 0;
			Other.LightCone = 0;
			Other.VolumeBrightness = 0;
			Other.LightType = LT_None;
			Other.LightEffect = LE_None;
			Other.RemoteRole = ROLE_DumbProxy;
			Other.NetUpdateFrequency = 2.000000;
			Other.SetPhysics(PHYS_Falling); //Sent it in drainage pipe - it's jerky but I do this way.
		}
	}
}

simulated event Actor SpawnNotification(Actor other)
{
	if ( Other.Class == Class 'DistanceLightning' )
		return NONE; //No way, buddy! No way, just get outta Level!
	return other;
}

defaultproperties
{
}
