//=============================================================================
// NsLightning.
//=============================================================================
class NsLightning expands Light;

var float T1, T2, T3;

replication
{
	reliable if (ROLE == ROLE_Authority)
		T1, T2, T3;
}

simulated function PostBeginPlay()
{
	log (Self$" spawned...");
	T1 = 5+FRand()*10;
	SetTimer(T1,False);
	LightType = LT_None;
}

simulated function Timer()
{
	if ( Owner != None )
	{
		Mesh=LodMesh'UnrealShare.CandleM';
		DrawType=DT_Mesh;
		LightBrightness = Owner.LightBrightness;
		LightHue = Owner.LightHue;
		LightSaturation = Owner.LightSaturation;
		LightRadius = Owner.LightRadius;
		LightPeriod = Owner.LightPeriod;
		LightPhase = Owner.LightPhase;
		LightCone = Owner.LightCone;
		Owner.bAlwaysRelevant=True;
		Owner.DrawType=DT_Mesh;
		Owner.Mesh=LodMesh'UnrealShare.CandleM';
		Owner.LightBrightness = 0;
		Owner.LightHue = 0;
		Owner.LightSaturation = 0;
		Owner.LightRadius = 0;
		Owner.LightPeriod = 0;
		Owner.LightPhase = 0;
		Owner.LightCone = 0;
		Owner.VolumeBrightness = 0;
		Owner.LightType = LT_None;
		Owner.LightEffect = LE_None;
		Owner.RemoteRole = ROLE_DumbProxy;
		Owner.NetUpdateFrequency = 2.000000;
		Owner.SetPhysics(PHYS_Falling);
		Owner.Destroy();
		SetOwner(None);
	}
	if (LightType == LT_Flicker)
	{
		LightType = LT_None;
		T2 = 9+FRand()*20;
		SetTimer(T2,False);
	}
	else 
	{
		LightType = LT_Flicker;
		T3 = 0.4+FRand()*0.05;
		SetTimer(T3,False);
	}
}

defaultproperties
{
   bStatic=False
   bNoDelete=False
   bGameRelevant=False
   bAlwaysRelevant=True
   bMovable=False
   LightType=LT_Flicker
   LightBrightness=255
   LightRadius=56
   LightPeriod=128
   LightPhase=32
   NetPriority=2.000000
   NetUpdateFrequency=10.000000
   RemoteRole=ROLE_SimulatedProxy
}
