//=============================================================================
// MapGarbage.
//=============================================================================
class MapGarbage expands BrushBuilder;

var LevelInfo MyMap;
var() bool bDoRemoveTrash, bRemoveNavNetwork,
 bPreNavigAddHck, bBuildNavNetwork, bRemoveBullshit,
 bRemoveMonsters, bCullTextures, bTweakMHMovers,
 bTweakMoverGroup, bDoPawnOpenMover, bBadTrgMoverFix,
 bNoGrabMoverCheat, bTweakMHFactory, bChkMHFactAttack,
 bBoostAmmo3X, bXCPostNavHck, bReplaceActor;
var() class<Actor> ReplaceType, WithType;
var() bool bSPawnTweaks;
var() int MaxHealthAllowed;
var() bool bNoRotateWeapon;
var() float ChangedRespawn;

final function FindLevel()
{
	SetPropertyText("MyMap","MyLevel.LevelInfo0");
	if( MyMap==None )
		SetPropertyText("MyMap","MyLevel.LevelInfo1");
	if( MyMap==None )
		SetPropertyText("MyMap","MyLevel.LevelInfo2");
	if( MyMap==None )
		Warn("Couldn't find levelinfo!");
}

event bool Build()
{
	FindLevel();
	if( MyMap == None )
		GoTo NoMap;

	if ( bRemoveNavNetwork )
	{
		MyMap.ConsoleCommand("PATHS UNDEFINE");
		MyMap.ConsoleCommand("OBJ GARBAGE");
	}

	if ( bPreNavigAddHck )
	{
		MyMap.ConsoleCommand("set PathNode CollisionHeight 40");
		MyMap.ConsoleCommand("set PathNode CollisionRadius 0.1");
		MyMap.ConsoleCommand("set PathNode bMovable 0");
		MyMap.ConsoleCommand("set InventorySpot CollisionHeight 40");
		MyMap.ConsoleCommand("set InventorySpot CollisionRadius 8");
		MyMap.ConsoleCommand("set InventorySpot bStatic False");
		MyMap.ConsoleCommand("set InventorySpot bMovable False");
		MyMap.ConsoleCommand("set InventorySpot bHiddenEd False");
		MyMap.ConsoleCommand("set LiftExit CollisionHeight 40");
		MyMap.ConsoleCommand("set LiftExit CollisionRadius 0.08");
		MyMap.ConsoleCommand("set LiftCenter CollisionHeight 40");
		MyMap.ConsoleCommand("set LiftCenter CollisionRadius 0.08");
		MyMap.ConsoleCommand("set JumpSpot CollisionHeight 40");
		MyMap.ConsoleCommand("set JumpSpot CollisionRadius 0.08");
		MyMap.ConsoleCommand("set TranslocDest CollisionHeight 40");
		MyMap.ConsoleCommand("set TranslocDest CollisionRadius 0.08");
		MyMap.ConsoleCommand("set TranslocStart CollisionHeight 40");
		MyMap.ConsoleCommand("set TranslocStart CollisionRadius 0.08");
		MyMap.ConsoleCommand("set AlternatePath CollisionHeight 40");
		MyMap.ConsoleCommand("set AlternatePath CollisionRadius 0.08");
		MyMap.ConsoleCommand("set PathNode DrawScale 0.5");
		MyMap.ConsoleCommand("set Inventory bCollideActors 0");
		MyMap.ConsoleCommand("set Inventory bCollideWorld 1");
	}

	if ( bBuildNavNetwork )
		MyMap.ConsoleCommand("PATHS DEFINE");

	if ( bXCPostNavHck )
		DoXCRecovery();

	if ( bNoRotateWeapon )
		DoStuckRotations();

	if ( bRemoveBullshit)
		DoKillShitPlayers();

	if ( bRemoveMonsters )
		DoRemoveMonsters();

	if ( bBoostAmmo3X )
		BoostAmmo();

	if ( bReplaceActor )
	{
		if ( ReplaceType == None )
		{
			Log("No Actor Type set for being replaced...");
			GoTo NoReplace;
		}
		if ( WithType == None )
		{
			Log("No Actor Type set as replacement...");
			GoTo NoReplace;
		}
		DoReplacement();
NoReplace:
	}

	if ( bTweakMHMovers )
		DoMoverHacks();

	if ( bTweakMHFactory )
		TweakFactories();

	if ( bSPawnTweaks )
		CheckDefaultMonster();

	if ( bCullTextures )
		MyMap.ConsoleCommand("TEXTURE CULL");

	if ( bDoRemoveTrash )
	{
		MyMap.ConsoleCommand("OBJ GARBAGE");
		MyMap.ConsoleCommand("FLUSH");
	}

	MyMap = None;
	GoTo Ending;
NoMap:
	log ("No Map Environment for Operating...",'MapGarbage');
Ending:
	log ("MapGarbage has ended process...",'MapGarbage');
}

function DoKillShitPlayers()
{
	local PlayerPawn P;

	foreach MyMap.AllActors(Class'PlayerPawn',P)
	{
		if ( !P.IsA('Camera') )
		{
			log ("Found lousy Pawn"@P@". Removing...",'MapGarbage');
			P.Destroy();
		}
	}
}

function DoRemoveMonsters()
{
	local Pawn P;
	local int I;

	foreach MyMap.AllActors(Class'Pawn',P)
	{
		if ( !P.IsA('Camera') )
		{
			I++;
			P.Destroy();
		}
	}
	if (I == 0)
	{
		log ("Did not find Pawns for removal.",'MapGarbage');
	}
	else
	{
		if ( I == 1 )
			log ("Removed"@I@"Pawn...",'MapGarbage');
		else
			log ("Removed"@I@"Pawns...",'MapGarbage');
	}
}

function DoReplacement()
{
	local Actor A;
	local Vector V;
	local Rotator R;
	local Name OTag, OEvent;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.class == ReplaceType )
		{
			V = A.Location;
			R = A.Rotation;
			OTag = A.Tag;
			OEvent = OEvent;
			A.Destroy();
			MyMap.Spawn( WithType,,OTag,V,R ).Event = OEvent;
		}
	}
}

function DoMoverHacks()
{
	local Mover M;
	local name Grp;
	local Trigger T;
	local Counter Cr;
	local Dispatcher Ds;
	local ScriptedPawn S;
	local Actor Ac;
	local int i;

	foreach MyMap.AllActors(class 'Mover', M)
	{
		if ( M.bTriggerOnceOnly )
		{
			if ( M.MoverEncroachType == ME_ReturnWhenEncroach )
			{
				M.MoverEncroachType = ME_IgnoreWhenEncroach;
				log ("Detected & Resolved a Mover Triggered Once With ReturnWhenEncroach >> "@M.name,'MapGarbage');
			}
			if ( M.InitialState == 'TriggerControl' )
			{
				log ("Ass ? A mover with TriggerControl shouldn't be set bTriggerOnceOnly >> "@M.Name,'MapGarbage');
				log ("Attempt to fix mover state >> "@M.Name@" to TriggerOpenTimed.",'MapGarbage');
				M.InitialState = 'TriggerOpenTimed';
				if ( M.InitialState == 'TriggerOpenTimed' )
				{
					log ("Successfully fixed.",'MapGarbage');
				}
				else
					log ("Fixing failed !!!",'MapGarbage');
			}
		}
		if ( bTweakMoverGroup )
			if (M.InitialState == 'TriggerOpenTimed' && M.Group == M.default.Group)
			{
				M.Group = M.Name;
				log ("Mover"@M@"has been set for group"@M.Group,'MapGarbage');
			}
			M.NetUpdateFrequency = 10.000000;
			if ( M.MoverEncroachType == ME_CrushWhenEncroach && !M.bTriggerOnceOnly && M.BumpType != BT_PawnBump )
			{
				M.BumpType = BT_PawnBump;
				if ( M.EncroachDamage <= 0 )
					M.EncroachDamage = 500000;
			}
			if ( bDoPawnOpenMover )
			{
				if ( !M.bTriggerOnceOnly )
				foreach MyMap.AllActors (class 'Trigger', T)
				{
					if ( T.Event != '' && T.Event == M.Tag && !T.bTriggerOnceOnly )
					{
						if ( T.TriggerType == TT_ClassProximity )
						{
//						if (!ClassIsChildOf(SpawnClass, class'TournamentPlayer'))
							if ( ClassIsChildOf(T.ClassProximityType,class'ScriptedPawn') )
							{
								T.ClassProximityType = class'UnrealShare.ScriptedPawn';
							}
						}
						if( T.InitialState == 'NormalTrigger' )
							if (T.TriggerType == TT_PlayerProximity)
							{
								log ("Mover"@M@"looks meant for Player. Demanding Proximity changed.",'MapGarbage');
								T.TriggerType = TT_PawnProximity;
							}
					}
				}
			}
		if ( M.Tag != '' && bBadTrgMoverFix && M.InitialState == 'TriggerControl' )
		{
			foreach MyMap.AllActors(class 'Actor',Ac)
			{
				if ( Counter(Ac) != None )
					Cr = Counter(Ac);
				if ( ScriptedPawn(Ac) != None && Ac.Event != '')
					S = ScriptedPawn(Ac);
				if ( Dispatcher(Ac) != None )
					Ds = Dispatcher(Ac);
				if ( Cr != None )
				if ( Cr.Event == M.Tag )
				{
					log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
					log ("Being triggered by "$Cr$" with Event "$Cr.Event$", will be properly set.",'MapGarbage');
					M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
				}
				if ( S != None )
				if ( S.Event == M.Tag )
				{
					log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
					log ("Being triggered by "$S$" without to mind console, will be properly set.",'MapGarbage');
					M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
				}
				if ( Ds != None )
				{
					for (i=0;i<8;i++)
					{
						if ( Ds.OutEvents[i] == M.Tag )
						{
							log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
							log ("Being triggered by "$Ds$" having event OutEvents["$i$"]: "$Ds.OutEvents[i]$", without to mind console, will be properly set.",'MapGarbage');
							M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
						}
					}
				}
			}
		}
		if ( bNoGrabMoverCheat )
			if ( M.bUseTriggered )
			{
				M.bUseTriggered = False;
				log ("Detected & Resolved a Mover to not be cheated by GRAB command >> " @M.name,'MapGarbage');
			}
			if (M.bDamageTriggered)
				log(M@" >> is damage triggered",'MapGarbage');
			if ( bDoPawnOpenMover )
			if (!M.bTriggerOnceOnly && M.BumpType == BT_PlayerBump && ( M.InitialState == 'StandOpenTimed' || M.InitialState == 'BumpOpenTimed' || M.InitialState == 'BumpButon'))
			{
				log ("Mover"@M@"will be activated by any Pawn.",'MapGarbage');
				M.BumpType = BT_PawnBump;
			}
	}
}

function TweakFactories()
{
	local int PP;
	local Actor A;
	local bool bPatrols;
	local PatrolPoint Po;

	PP = 0;

	foreach MyMap.AllActors (class 'PatrolPoint', Po)
	{
		PP++;
		bPatrols = True;
	}
	foreach MyMap.AllActors (class 'Actor', A)
	{
		if ( CreatureFactory(A) != None )
		{
			if ( CreatureFactory(A).Orders == 'Roaming' )
			{
				CreatureFactory(A).Orders = '';
				log ("Illegal settings discovered and removed at"@CreatureFactory(A),'MapGarbage');
			}
			if (CreatureFactory(A).Orders == 'Patroling' && !bPatrols)
			{
				CreatureFactory(A).Orders = '';
				log ("Order <Patroling> is invalid without a PatrolPoint at"@CreatureFactory(A)@"and has been eliminated.",'MapGarbage');
			}
			if ( CreatureFactory(A).itemtag == CreatureFactory(A).Tag )
			{
				log ("Detected bad self triggering at "$CreatureFactory(A)$". Screwing out...",'MapGarbage');
				CreatureFactory(A).itemtag = '';
			}
			if ( bChkMHFactAttack )
			{
				if ( !CreatureFactory(A).bOnlyPlayerTouched )
				{
					CreatureFactory(A).bOnlyPlayerTouched = True;
					log ("Removed wild touch ignition at "$CreatureFactory(A)$".",'MapGarbage');
				}
			}
		}
		if ( ScriptedPawn(A) != None )
		{
			if ( ScriptedPawn(A).Orders == 'Roaming' || ( ScriptedPawn(A).Orders == 'Patroling' && !bPatrols ) || ScriptedPawn(A).Orders == 'Hunting' )
			{
				log (ScriptedPawn(A)$" having order "$ScriptedPawn(A).Orders$" has been reset because it has no logic here.",'MapGarbage');
				ScriptedPawn(A).Orders = '';
			}
		}
	}
	if ( bPatrols )
	{
		if (PP < 2)
			log ("This level contains"@PP@"PatrolPoint. Interesting!",'MapGarbage');
		else
			log ("This level contains"@PP@"PatrolPoints.",'MapGarbage');
		}
		else
			log ("This level doesn't include any PatrolPoint.",'MapGarbage');
}

function CheckDefaultMonster()
{
	local ScriptedPawn S;

	if ( MaxHealthAllowed <= 0 )
	{
		log ("MaxHealthAllowed is not Set. Using 100000 as reference...",'MapGarbage');
		MaxHealthAllowed = 100000;
	}

	foreach MyMap.AllActors(class'ScriptedPawn',S)
	{
		if ( S.Health > 0 )
		{
			if ( S.Mesh == None && S.Class.Default.Mesh != None || S.Mesh != S.Class.Default.Mesh )
			{
				log ("Creature"@S.Name@"will be restored",'MapGarbage');
				S.Mesh = S.Class.Default.Mesh;
				S.DrawType = DT_Mesh;
			}
			if ( S.Health > MaxHealthAllowed )
			{
				log ("Creature"@S.Name@"will have excessive Health lowered...",'MapGarbage');
				S.Health = MaxHealthAllowed;
			}
			if ( S.Orders != '' )
			{
				if ( S.Orders == 'Roaming' )
					S.Orders = '';
				if ( S.Orders != 'Sitting' || S.Orders != 'Ambushing' || S.Orders != 'Guarding' || S.Orders != 'Patroling' )
				{
					log ("Nulling out order for"@S.Name@"being"@S.Orders@".",'MapGarbage');
					S.Orders = '';
				}
			}
			if ( S.Skill > 3 )
				S.Skill = 3;
			if ( S.Skill < 1 )
				S.Skill = 1;
			if ( S.Aggressiveness > 2 )
				S.Aggressiveness = 2;
			if ( S.SightRadius > 4096 )
				S.SightRadius = 4096;
			if ( S.PeripheralVision > -0.2 )
				S.PeripheralVision = -0.2;
			if ( S.PeripheralVision < -1.0 )
				S.PeripheralVision = - 1.0;
			if ( S.HearingThreshold > 0.5 )
				S.HearingThreshold = 0.5;
			if ( S.RangedProjectile != None && !S.RangedProjectile.IsA('Projectile') ) //Yeah, idiots!
				S.RangedProjectile = S.Class.Default.RangedProjectile;
			if ( S.GroundSpeed > 500 )
				S.GroundSpeed = 500;
			if ( S.WaterSpeed > 350 )
				S.WaterSpeed = 350;
			if ( S.AirSpeed > 600 )
				S.AirSpeed = 600;
			if ( S.AccelRate > 1500 )
				S.AccelRate = 1500;
			S.MeleeRange = S.Class.Default.MeleeRange;
			S.SetCollisionSize(S.Class.Default.CollisionRadius,S.Class.Default.CollisionHeight);
			if ( S.IsA('Tentacle') )
				S.AnimSequence='Hide';
		}
	}
}

function BoostAmmo()
{
	local Ammo A;

	foreach MyMap.AllActors(class'Ammo',A)
	{
		if ( A.Class.Default.MaxAmmo < 2 )
			continue;
		if ( A.Class.Default.AmmoAmount == 0 )
			A.Class.Default.AmmoAmount = 2;
		if ( A.AmmoAmount < ( A.Class.Default.AmmoAmount*3 ) )
			A.AmmoAmount *= 3;
		if ( A.RespawnTime > ( A.Class.Default.RespawnTime/3 ) )
			A.RespawnTime = int( A.Class.Default.RespawnTime/3 );
		if ( !A.IsA('TournamentAmmo') )
			A.PickupMessageClass = class'Botpack.PickupMessagePlus';
	}
}

function DoXCRecovery()
{
	local InventorySpot I;
	local Inventory Inv;
	local int A;

	foreach MyMap.AllActors( class'InventorySpot',I )
	{
		if ( I.MarkedItem != None && I.MarkedItem.myMarker == None )
		{
			A++;
			I.MarkedItem.myMarker = I;
		}
	}
	if ( A > 0 )
		log(A@"Inventory types have been linked with InvSpots accordingly...",'MapGarbage');
	if ( A == 0 )
		log("Did not find any Inventory without myMarker...",'MapGarbage');
	A = 0;
	foreach MyMap.AllActors( class'Inventory',Inv )
	{
		Inv.SetCollisionSize(Inv.Class.Default.CollisionRadius,Inv.Class.Default.CollisionHeight);
	}
}

function DoStuckRotations()
{
	local Weapon W;

	foreach MyMap.AllActors(class 'Weapon',W)
	{
		W.bRotatingPickup = False;
		W.RotationRate.Pitch = 0;
		W.RotationRate.Roll = 0;
		W.RotationRate.Yaw = 0;
		W.bFixedRotationDir = False;
		if ( ChangedRespawn > 3.000000 )
			W.RespawnTime = ChangedRespawn;
		if ( W.RespawnTime < 3.000000 ) //No spam crap pickup logs
			W.RespawnTime = W.Class.Default.RespawnTime;
	}
}

defaultproperties
{
     BitmapFilename="MapGarbager"
     ToolTip="Map Garbage"
}
