//=============================================================================
// MapGarbage.
//=============================================================================
class MapGarbage expands BrushBuilder;

var LevelInfo MyMap;
var() bool bDoRemoveTrash, bRemoveNavNetwork, bTryFixBadPaths,
 bPreNavigAddHck, bBuildNavNetwork, bRemoveBullshit,
 bRemoveMonsters, bCullTextures, bTweakMHMovers,
 bTweakMoverGroup, bDoPawnOpenMover, bBadTrgMoverFix,
 bNoGrabMoverCheat, bTweakMHFactory, bChkMHFactAttack,
 bBoostAmmo3X, bXCPostNavHck, bHideSpriteActors,
 bUnHideSpriteActors, bTrySolveLocation, bRoundCylinder,
 bReportActors, bShowSpecs, bCheckItems, bStaticsReport,
 bCheckDuplicates, bTryFixDuplicates, bPurgeDupes2,
 bScanCTFAltPaths, bRemoveNoReachPaths, bReplaceActor;
var() class<Actor> ReplaceType, WithType;
var() bool bSPawnTweaks;
var() int MaxHealthAllowed;
var() bool bNoRotateWeapon;
var() float ChangedRespawn;
var() bool bHidePlStarts, bRestPlStarts;
var() int HoleLength;
var() bool bSimAltPathPicking;
var() int ATeam;
var NavigationPoint S, N, N1;

/*
Constants defined as recommended by Barbie according to
translating into words of reachFlag returned by DescribeSpec.
As a matter of fact there are not many flags assigned, proving
how poorly coded is DevPath generally, suprisingly it do works
as it is for common needs...
The most common values are 1, 4, 9, 13, 32.
*/
const NF_Walk       = 1;  // = 0x01 = b0000.0001
const NF_Fly        = 2;  // = 0x02 = b0000.0010
const NF_Swim       = 4;  // = 0x04 = b0000.0100
const NF_Jump       = 8;  // = 0x08 = b0000.1000
const NF_Door       = 16; // = 0x10 = b0001.0000
const NF_Special    = 32; // = 0x20 = b0010.0000
const NF_PlayerOnly = 64; // = 0x40 = b0100.0000


final function FindLevel()
{
	SetPropertyText("MyMap","MyLevel.LevelInfo0");
	if( MyMap==None )
		SetPropertyText("MyMap","MyLevel.LevelInfo1");
	if( MyMap==None )
		SetPropertyText("MyMap","MyLevel.LevelInfo2");
	if( MyMap==None )
		Warn("Couldn't find levelinfo!");
}

function bool Build()
{
	FindLevel();
	if ( MyMap == None )
		return BadParameters("No Valid LevelInfo has been found...");
	else
	{
	if ( bTryFixBadPaths )
	{
		bRemoveNavNetwork = True;
		DoPathsTuning();
		MyMap.ConsoleCommand("actor select none");
		MyMap.ConsoleCommand("map sendto last");
		bBuildNavNetwork = True;
	}

	if ( bRemoveNavNetwork )
	{
		MyMap.ConsoleCommand("PATHS UNDEFINE");
		MyMap.ConsoleCommand("OBJ GARBAGE");
		if ( bTryFixBadPaths )
			bRemoveNavNetwork = False;
	}

	if ( bPreNavigAddHck )
	{
		MyMap.ConsoleCommand("actor select none");
		MyMap.ConsoleCommand("set PathNode CollisionHeight 40");
		MyMap.ConsoleCommand("set PathNode CollisionRadius 18");
		MyMap.ConsoleCommand("set PathNode bMovable 0");
		MyMap.ConsoleCommand("set PathNode bCollideWhenPlacing 0");
		MyMap.ConsoleCommand("set InventorySpot CollisionHeight 40");
		MyMap.ConsoleCommand("set InventorySpot CollisionRadius 8");
		MyMap.ConsoleCommand("set InventorySpot bMovable False");
		MyMap.ConsoleCommand("set InventorySpot bHiddenEd False");
		MyMap.ConsoleCommand("set LiftExit CollisionHeight 40");
		MyMap.ConsoleCommand("set LiftExit CollisionRadius 18");
		MyMap.ConsoleCommand("set LiftCenter CollisionHeight 40");
		MyMap.ConsoleCommand("set LiftCenter CollisionRadius 18");
		MyMap.ConsoleCommand("set JumpSpot CollisionHeight 40");
		MyMap.ConsoleCommand("set JumpSpot CollisionRadius 18");
		MyMap.ConsoleCommand("set TranslocDest CollisionHeight 40");
		MyMap.ConsoleCommand("set TranslocDest CollisionRadius 18");
		MyMap.ConsoleCommand("set TranslocStart CollisionHeight 40");
		MyMap.ConsoleCommand("set TranslocStart CollisionRadius 18");
		MyMap.ConsoleCommand("set AlternatePath CollisionHeight 40");
		MyMap.ConsoleCommand("set AlternatePath CollisionRadius 18");
		MyMap.ConsoleCommand("set PathNode DrawScale 0.5");
		MyMap.ConsoleCommand("set Inventory bCollideWorld 1");
		MyMap.ConsoleCommand("set NavigationPoint bEdShouldSnap 1");
		MyMap.ConsoleCommand("set Scout CollisionHeight 40");
		MyMap.ConsoleCommand("set Scout CollisionRadius 10");
		MyMap.ConsoleCommand("set Scout bCanJump 1"); //Not sure if it helps but definitely doesn't hurt
		MyMap.ConsoleCommand("map sendto last");
	}

	if ( bBuildNavNetwork )
	{
		class'InventorySpot'.Default.Texture=Texture'Engine.S_Inventory';
		class'InventorySpot'.Default.DrawScale=0.5;
		MyMap.ConsoleCommand("PATHS DEFINE");
		if ( bTryFixBadPaths )
			bBuildNavNetwork = False;
	}

	if ( bXCPostNavHck )
		DoXCRecovery();

	if ( bNoRotateWeapon )
		DoStuckRotations();

	if ( bRemoveBullshit)
		DoKillShitPlayers();

	if ( bRemoveMonsters )
		DoRemoveMonsters();

	if ( bBoostAmmo3X )
		BoostAmmo();

	if ( bReplaceActor )
	{
		if ( ReplaceType == None )
		{
			Log("No Actor Type set for being replaced...");
			return BadParameters("You must declare actor-class that has to be replaced...");
			GoTo NoReplace;
		}
		if ( WithType == None )
		{
			Log("No Actor Type set as replacement...");
			return BadParameters("You must declare actor-class used as replacement for"@ReplaceType);
			GoTo NoReplace;
		}
		DoReplacement();
NoReplace:
	}

	if ( bTweakMHMovers )
		DoMoverHacks();

	if ( bTweakMHFactory )
		TweakFactories();

	if ( bSPawnTweaks )
		CheckDefaultMonster();

	if ( bCullTextures )
		MyMap.ConsoleCommand("TEXTURE CULL");

	if ( bHideSpriteActors )
		DoHideSprites();

	if ( bUnHideSpriteActors )
		DoFallBackSprites();

	if ( bDoRemoveTrash )
	{
		MyMap.ConsoleCommand("OBJ GARBAGE");
		MyMap.ConsoleCommand("FLUSH");
	}

	if ( bTrySolveLocation )
		RelocateActors();

	if ( bReportActors )
		LogWrappedNames();

	if ( bShowSpecs )
		ShowNavSpecifications();

	if ( bCheckItems )
		CheckItemLocation();

	if ( bHidePlStarts )
		LowerThem();

	if ( bRestPlStarts )
		UpperThem();

	if ( bRoundCylinder )
		RoundActorCylinder();

	if ( bStaticsReport )
		ReportScrewedStatics();

	if ( bScanCTFAltPaths )
		ReportCTFAlternatePaths();

	if ( bSimAltPathPicking )
		SimulateAltPathPicking();

	if ( bRemoveNoReachPaths )
		RemoveVisNoReaches();

	if ( bCheckDuplicates )
		FindCrappedActors();

	if ( bPurgeDupes2 )
		DestroyDupes();
	}
	return BadParameters("MapGarbage... Job Done !");
}

final function FindCrappedActors()
{
	local bool bLogged, bHasDupes;
	local Actor A, A1, Temp;
	local Int i, j, iDup;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.Tag == 'Dup')
		{
			if ( !bHasDupes )
				bHasDupes = True;
			if ( bTryFixDuplicates )
			{
				log("Found duplicated - "$A.Name$" - Atempting removal",'Duplicated');
				A.Destroy();
				continue;
			}
			else
			{
				if ( !bLogged )
				{
					bLogged = True;
					log ("Actors might be removed by using subsequent bTryFixDuplicates set to True.",'Duplicated');
					log ("Operation recommended in another clean editing session with both values set True.",'Duplicated');
				}
			}
			continue;
		}
		foreach MyMap.AllActors(class'Actor',A1,A.Tag)
		{
			if ( string(A.Name) == string(A1.Name) )
			{
				i++; Idup++;
			}
			if ( i > 1 )
			{
				if ( bTryFixDuplicates )
				{
					log ( "Deleting "$A1.name,'Duplicated');
					i = 0;
					j++;
					A1.Destroy();
					continue;
				}
				else
					A1.Tag = 'Dup';
				i = 0;
				j++;
			}
		}
		if ( iDup > 1 )
			log (A.Name$" was found "$iDup$" times.",'Duplicated');
		i = 0;
		iDup = 0;
	}
	if ( j > 0 )
		log ("Found"@j@"duplicated Actors.",'Duplicated');
	else
	{
		log ("Duplicated Actors scan is finished.",'Duplicated');
		if ( bHasDupes && !bTryFixDuplicates )
			log ("Map has marked duplicated actors that might be removed.",'Duplicated');
		if ( !bHasDupes && j == 0 )
			log ("Map doesn't seems to include duplicated actors.",'Duplicated');
	}
	if ( bTryFixDuplicates )
		MyMap.ConsoleCommand("set Actor bDeleteMe 0"); //You might need this else... Surprise !
}

final function DestroyDupes()
{
	local Actor A, A1;
	local int j, i;
	local bool bTagged;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.Tag == 'Dup' )
		{
			A.Destroy();
			j++;
			Continue;
		}
		else
		{
			foreach MyMap.AllActors(class'Actor',A1,A.Tag)
			{
				if ( string(A.Name) == string(A1.Name) )
				{
					i++;
					if ( i > 1 )
					{
						A1.Tag = 'Dup';
						i = 0;
					}
				}
			}
			i = 0;
		}
	}
	A = None;
	foreach MyMap.AllActors(class'Actor',A,'Dup')
		A.Tag = A.default.Tag;
	if ( j > 0 )
	{
		log ("Removed"@j@"duplicated Actors. Do the check again...");
		MyMap.ConsoleCommand("set Actor bDeleteMe 0");
	}
	else
		log ("There is nothing duplicated for removal.");
}

final function RemoveVisNoReaches()
{
	local NavigationPoint N;
	local int i, j;

	log ("Scanning and removing VisNoReachPaths references.",'FlushBytes');

	for ( N=MyMap.NavigationPointList; N!=None; N=N.nextNavigationPoint )
	{
		if ( N.VisNoReachPaths[0] == None )
			continue;
		else
		{
			While ( N.VisNoReachPaths[i] != None )
			{
				N.VisNoReachPaths[i] = None;
				j++; i++;
				if ( i == 16 )
					break;
			}
			i = 0;
		}
	}
	log ("VisNoReachPaths nulified ="@j$".",'FlushBytes');
}

final function SimulateAltPathPicking()
{
	local AlternatePath Ap;
	local NavigationPoint N;
	local float totalWeight, selection, partialWeight;

	log("Testing AlternatePath choice for team"@ATeam,'SimulateAltPathPicking');
	if ( FRand() < 0.8 )
	{
		for ( N=MyMap.NavigationPointList; N!=None; N=N.nextNavigationPoint )
			if ( N.IsA('AlternatePath') && (AlternatePath(N).team != ATeam)
				&& !AlternatePath(N).bReturnOnly )
				TotalWeight += AlternatePath(N).SelectionWeight;
		selection = FRand() * TotalWeight;
		log ("Selection is"@selection@"and TotalWeight"@TotalWeight,'SimulateAltPathPicking');
		for ( N=MyMap.NavigationPointList; N!=None; N=N.nextNavigationPoint )
			if ( N.IsA('AlternatePath') && (AlternatePath(N).team != ATeam) )
			{
				Ap = AlternatePath(N);
				PartialWeight += AlternatePath(N).SelectionWeight;
				if ( PartialWeight > selection )
				{
					log ("Loop sort stops at PartialWeight"@PartialWeight,'SimulateAltPathPicking');
					break;
				}
			}
		log ("Presumed Bot from team"@ATeam@"has AlternatePath"@Ap.Name@"with team"@Ap.Team,'SimulateAltPathPicking');
	}
	else
	{
		log ("No AlternatePath this time.",'SimulateAltPathPicking');
	}
}

final function ReportCTFAlternatePaths()
{
	local AlternatePath Ap;
	local int T0, T1, T2, T3;

	foreach MyMap.AllActors (class 'AlternatePath', Ap)
	{
		if ( Ap.Team == 0 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 0",'CTFReport' );
			T0++;
		}
		else if ( Ap.Team == 1 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 1",'CTFReport' );
			T1++;
		}
		else if ( Ap.Team == 2 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 2",'CTFReport' );
			T2++;
		}
		else if ( Ap.Team == 3 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 3",'CTFReport' );
			T3++;
		}
	}
	log ("--- Reporting AlternatePaths setup: ---",'CTFReport');
	log ("For Team 0 ="@T0@"pieces.",'CTFReport');
	log ("For Team 1 ="@T1@"pieces.",'CTFReport');
	if ( T2 > 0 || T3 > 0 )
	{
		log ("For Team 2 ="@T2@"pieces.",'CTFReport');
		log ("For Team 3 ="@T3@"pieces.",'CTFReport');
	}
}

final function ReportScrewedStatics()
{
	local Actor A;
	local bool bLogged;

	foreach MyMap.AllActors( class'Actor',A )
	{
		if ( !A.bStatic && A.Class.Default.bStatic )
			log("Bork >>"@A.Name@"won't be seen in clients. Class has bStatic True and has been screwed to False.",'StaticsCheck');
		if ( A.bStatic && !A.Class.Default.bStatic )
		{
			log("Actor"@A.Name@"has screwed as bStatic. Check it...",'StaticsCheck');
			if ( Inventory(A) != None && !bLogged )
			{
				log ("Inventories are not supposed to be bStatic, this might screw mutators and their pickup behavior. Fix the crap!",'StaticsCheck');
				bLogged = True;
			}
		}
		if ( !A.bNoDelete && A.Class.Default.bNoDelete )
			log("Warning >>"@A.Name@"has bNoDelete False, original class is True... check actor for net play compatibility.",'StaticsCheck');
		if ( A.bNoDelete && !A.Class.Default.bNoDelete )
		{
			log("Actor"@A.Name@"is screwed as bNoDelete. Check it...",'StaticsCheck');
			if ( Inventory(A) != None && !bLogged )
			{
				log ("Inventories are not supposed to be bNoDelete, this might screw mutators and their pickup behavior. Fix the crap!",'StaticsCheck');
				bLogged = True;
			}
		}
	}
}

final function RoundActorCylinder()
{
	local Actor A;

	foreach MyMap.AllActors ( class'Actor',A )
	{
		if ( Brush(A) == None )
		{
			if ( A.DrawType == DT_Mesh && A.bCollideActors )
				if ( A.CollisionRadius != int( A.CollisionRadius )
					|| A.CollisionHeight != int( A.CollisionHeight ) )
				A.SetCollisionSize( int(A.CollisionRadius),int(A.CollisionHeight) );
		}
	}
}

final function LowerThem()
{
	local NavigationPoint Ps;
	local vector NewLocation;
	local rotator NavRot;

	foreach MyMap.AllActors(class'NavigationPoint',Ps)
	{
		if ( PlayerStart(Ps) != None || SpawnPoint(Ps) != None || QueenDest(Ps) != None )
		{
			Ps.bCollideWhenPlacing = False;
			Ps.bCollideWorld = False;
			NavRot = Ps.Rotation;
			NewLocation = Ps.Location;
			NewLocation.Z -= HoleLength;
			Ps.SetLocation(NewLocation);
			if ( Ps.Rotation != NavRot )
				Ps.SetRotation(NavRot);
		}
	}
}

final function UpperThem()
{
	local NavigationPoint Ps;
	local vector NewLocation;
	local rotator NavRot;

	foreach MyMap.AllActors(class'NavigationPoint',Ps)
	{
		if ( PlayerStart(Ps) != None || SpawnPoint(Ps) != None || QueenDest(Ps) != None )
		{
			Ps.bCollideWhenPlacing = False;
			Ps.bCollideWorld = False;
			NavRot = Ps.Rotation;
			NewLocation = Ps.Location;
			NewLocation.Z += HoleLength;
			Ps.SetLocation(NewLocation);
			if ( Ps.Rotation != NavRot )
				Ps.SetRotation(NavRot);
		}
	}
}

final function CheckItemLocation()
{
	local Inventory I;
	local int CR, CH, iCh, nitem, average;
	local vector ILoc, TestLoc, ZPos;
	local rotator IRot;
	local bool bReportPaths;
	local Scout S;

	class'Scout'.default.bCollideWorld = True;
	class'Scout'.default.bCollideWhenPlacing = True;
	foreach MyMap.AllActors( class 'Inventory', I )
	{
		if ( I.MyMarker != None && !bReportPaths )
		{
			bReportPaths = True;
			log ("Testing items should happen BEFORE building A.I. paths...",'ItemLocator');
		}
		nitem++;
		I.bMovable = True;
		CR = int(I.CollisionRadius);
		CH = int(I.CollisionHeight);
		ILoc = I.Location;
		IRot = I.Rotation;
		ZPos.Z = ILoc.Z;
		I.SetCollisionSize(52,50);
		I.bCollideWorld = True;
		I.bCollideWhenPlacing = True;
		I.SetCollision(True,False,False);
		I.SetLocation(ILoc+vect(0,0,1));
		TestLoc = I.Location;
		if ( S == None )
			S = MyMap.Spawn(class'Scout',,,TestLoc);
		if ( S != None )
		{
			if (!S.SetLocation(TestLoc))
			{
				S.SetCollisionSize(20,40);
					log (I.Name$" might generate RED heavy path.",'InitialPathProbing');
			}
			if (!S.SetLocation(TestLoc))
				log (I.Name$" looks bad placed...",'ShrinkPathProbing');
			S.SetCollisionSize(S.class.default.CollisionRadius,S.class.default.CollisionHeight);
		}
		else
			log (I.Name$" did not allow first Paths test.",'ScoutCreate');
		if ( (int(TestLoc.X) != int(Iloc.X) ) || (int(TestLoc.Y) != int(ILoc.Y)) )
		{
			Log(I.Name$" trying to ajust.",'ItemLocator');
			TestLoc.Z = ZPos.Z;
			I.SetCollisionSize(CR,CH);
			I.SetLocation(TestLoc);
			I.SetRotation(IRot);
			iCh++;
		}
		else
		{
			I.SetCollisionSize(CR,CH);
			I.SetLocation(ILoc);
			I.SetRotation(IRot);
		}
	}
	if ( S != None )
	{
		S.Destroy();
		S = None;
	}
	class'Scout'.default.bCollideWorld = False;
	class'Scout'.default.bCollideWhenPlacing = False;
	if ( nitem > 0 )
	{
		average = ( iCh * 100 )/nitem;
		log ("Items checked !"@iCh@"items have been adjusted a bit, which means "$average$"% of map's items.",'ItemLocator');
	}
	else
		log ("Items checked, map has nothing like an Inventory",'ItemLocator');
}

final function LogWrappedNames()
{
	local int I;
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		I++;
		log (A.Name@"is class"@A.Class@"and number"@I@".",'OrderOfActors');
	}
	log ( "Logged "$I$" actors..." );
}

final function ShowNavSpecifications()
{
	local NavigationPoint N;
	local bool bNothingSelected;
	local Actor Start, End;
	local int distance, reachFlags, i, j;
	local bool bUpPaths, bPaths;

	bNothingSelected = True;
	log ("+++++",'Specs');
//	for ( N = MyMap.NavigationPointList; N != None; N = N.NextNavigationPoint )
	foreach MyMap.AllActors( class'NavigationPoint',N )
	{
		if ( N.bSelected )
		{
			bNothingSelected = False;
			i = 0;
			do
//			for ( i=0; i<16; i++ )
			{
				if ( N.UpstreamPaths[i] != -1 )
				{
					log("oooooooooooooooo",'oooooooooooooooo');
					N.DescribeSpec( N.UpstreamPaths[i], Start, End, reachFlags, distance );
					log ( N.Name@"- UpstreamPaths["$i$"]="$N.UpstreamPaths[i]@"Start="$Start.Name@"End="$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					if ( End != None && End == N )
					{
						bUpPaths = True;
						log ( Start.Name@"to"@N.Name$".",'Connected');
					}
				}
				Start = None;
				End = None;
				reachFlags = 0;
				distance = 0;

				if ( N.Paths[i] != -1 )
				{
					log("oooooooooooooooo",'oooooooooooooooo');
					N.DescribeSpec( N.Paths[i], Start, End, reachFlags, distance );
					log ( N.Name@"- Paths["$i$"]="$N.Paths[i]@"Start="$Start.Name@"End="$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					if ( Start != None && Start == N )
					{
						bPaths = True;
						log ( N.Name@"to"@End.Name$".",'Connected');
					}
				}
				if ( N.VisNoReachPaths[i] != None )
					log (N.Name@"to point"@i@"which means"@N.VisNoReachPaths[i].Name,'NoReachFrom');
				Start = None;
				End = None;
				reachFlags = 0;
				distance = 0;

				if ( N.PrunedPaths[i] != -1 )
				{
					log("oooooooooooooooo",'oooooooooooooooo');
					N.DescribeSpec( N.PrunedPaths[i], Start, End, reachFlags, distance );
					log ( N.Name@"- PrunedPaths["$i$"]="$N.PrunedPaths[i]@"Start="$Start.Name@"End="$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					if ( Start != None && Start == N )
					{
						bPaths = True;
						log ( N.Name@"to"@End.Name$".",'ShortcutConnected');
					}
				}

				Start = None;
				End = None;
				reachFlags = 0;
				distance = 0;
				i++;
			}
			until ( i == 16 );
			log ("+++++",'Specs');
			if ( !bUpPaths )
				log ("No NavigationPoint heads to"@N.Name$". If a route passes through, if won't be usable.",'Specs');
			if ( !bPaths )
				log ("There isn't any connection starting from"@N.Name$".",'Specs');
			if ( !bUpPaths && !bPaths )
				log (N.Name@"do looks isolated from Navigation Network without connections. Check paths !",'Specs');
			bPaths = False;
			bUpPaths = False;
		}
		if ( N.bHiddenEd )
			N.bHiddenEd = False;
	}
	if (!bNothingSelected)
	{
		log ("ReachSpecs Flags summary:",'Specs');
		log ("R_WALK = 1",'Flg');
		log ("R_FLY = 2",'Flg');
		log ("R_SWIM = 4",'Flg');
		log ("R_JUMP = 8",'Flg');
		log ("R_DOOR = 16",'Flg');
		log ("R_SPECIAL = 32",'Flg');
		log ("R_PLAYERONLY = 64",'Flg');
	}
	else
	{
		log ("This option requires selecting one or more NavigationPoint actors...");
		bNothingSelected = False;
	}
}
/*
	Now are needed some constants declared in builder. Not bad.
*/
final function String GetReadableFlag_Barbie(int Flags)
{
	local string result;

	if (Flags == 0)
		return "NoFlag ";
	if ((Flags & NF_Special) != 0)
		result = result $ "Special ";
	if ((Flags & NF_PlayerOnly) != 0)
		result = result $ "PlayerOnly ";
	if ((Flags & NF_Door) != 0)
		result = result $ "Door ";
	if ((Flags & NF_Jump) != 0)
		result = result $ "Jump ";
	if ((Flags & NF_Swim) != 0)
		result = result $ "Swim ";
	if ((Flags & NF_Fly) != 0)
		result = result $ "Fly ";
	if ((Flags & NF_Walk) != 0)
		result = result $ "Walk ";
	// cut off last space:
	if (result != "")
		result = left(result, len(result) - 1);
	return result;
}

final function RelocateActors()
{
	local Actor A;
	local Vector NewLoc;

	foreach MyMap.AllActors(Class'Actor',A)
	{
		if ( Brush(A) == None )
		{
			NewLoc.X = int(A.Location.X);
			NewLoc.Y = int(A.Location.Y);
			NewLoc.Z = int(A.Location.Z);
			A.SetLocation(NewLoc);
		}
	}
}

final function DoKillShitPlayers()
{
	local PlayerPawn P;

	foreach MyMap.AllActors(Class'PlayerPawn',P)
	{
		if ( !P.IsA('Camera') )
		{
			log ("Found lousy Pawn"@P@". Removing...",'MapGarbage');
			P.Destroy();
		}
	}
}

final function DoRemoveMonsters()
{
	local Pawn P;
	local int I;

	foreach MyMap.AllActors(Class'Pawn',P)
	{
		if ( !P.IsA('Camera') )
		{
			I++;
			P.Destroy();
		}
	}
	if (I == 0)
	{
		log ("Did not find Pawns for removal.",'MapGarbage');
	}
	else
	{
		if ( I == 1 )
			log ("Removed"@I@"Pawn...",'MapGarbage');
		else
			log ("Removed"@I@"Pawns...",'MapGarbage');
	}
}

final function DoReplacement()
{
	local Actor A;
	local int NumRep;
	local Vector V;
	local Rotator R;
	local Name OTag, OEvent;

	numrep = 0;
	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.class == ReplaceType && A.bSelected )
		{
			V = A.Location;
			R = A.Rotation;
			OTag = A.Tag;
			OEvent = A.Event;
			A.Destroy();
			WithType.Default.bCollideWhenPlacing = False;
			MyMap.Spawn( WithType,,OTag,V,R );
			if ( WithType != None )
			{
				numRep++;
				WithType.SetPropertyText("Event",string(OEvent));
				WithType.SetPropertyText("bSelected","True");
			}
		}
	}
	log (NumRep@"selected"@ReplaceType@"have been replaced with"@WithType);
}

final function DoMoverHacks()
{
	local Mover M;
	local name Grp;
	local Trigger T;
	local Counter Cr;
	local Dispatcher Ds;
	local ScriptedPawn S;
	local Actor Ac;
	local int i;

	foreach MyMap.AllActors(class 'Mover', M)
	{
		if ( M.bTriggerOnceOnly )
		{
			if ( M.MoverEncroachType == ME_ReturnWhenEncroach )
			{
				M.MoverEncroachType = ME_IgnoreWhenEncroach;
				log ("Detected & Resolved a Mover Triggered Once With ReturnWhenEncroach >> "@M.name,'MapGarbage');
			}
			if ( M.InitialState == 'TriggerControl' )
			{
				log ("Ass ? A mover with TriggerControl shouldn't be set bTriggerOnceOnly >> "@M.Name,'MapGarbage');
				log ("Attempt to fix mover state >> "@M.Name@" to TriggerOpenTimed.",'MapGarbage');
				M.InitialState = 'TriggerOpenTimed';
				if ( M.InitialState == 'TriggerOpenTimed' )
				{
					log ("Successfully fixed.",'MapGarbage');
				}
				else
					log ("Fixing failed !!!",'MapGarbage');
			}
		}
		if ( bTweakMoverGroup )
			if (M.InitialState == 'TriggerOpenTimed' && M.Group == M.default.Group)
			{
				M.Group = M.Name;
				log ("Mover"@M@"has been set for group"@M.Group,'MapGarbage');
			}
			M.NetUpdateFrequency = 10.000000;
			if ( M.MoverEncroachType == ME_CrushWhenEncroach && !M.bTriggerOnceOnly && M.BumpType != BT_PawnBump )
			{
				M.BumpType = BT_PawnBump;
				if ( M.EncroachDamage <= 0 )
					M.EncroachDamage = 500000;
			}
			if ( bDoPawnOpenMover )
			{
				if ( !M.bTriggerOnceOnly )
				foreach MyMap.AllActors (class 'Trigger', T)
				{
					if ( T.Event != '' && T.Event == M.Tag && !T.bTriggerOnceOnly )
					{
						if ( T.TriggerType == TT_ClassProximity )
						{
//						if (!ClassIsChildOf(SpawnClass, class'TournamentPlayer'))
							if ( ClassIsChildOf(T.ClassProximityType,class'ScriptedPawn') )
							{
								T.ClassProximityType = class'UnrealShare.ScriptedPawn';
							}
						}
						if( T.InitialState == 'NormalTrigger' )
							if (T.TriggerType == TT_PlayerProximity)
							{
								log ("Mover"@M@"looks meant for Player. Demanding Proximity changed.",'MapGarbage');
								T.TriggerType = TT_PawnProximity;
							}
					}
				}
			}
		if ( M.Tag != '' && bBadTrgMoverFix && M.InitialState == 'TriggerControl' )
		{
			foreach MyMap.AllActors(class 'Actor',Ac)
			{
				if ( Counter(Ac) != None )
					Cr = Counter(Ac);
				if ( ScriptedPawn(Ac) != None && Ac.Event != '')
					S = ScriptedPawn(Ac);
				if ( Dispatcher(Ac) != None )
					Ds = Dispatcher(Ac);
				if ( Cr != None )
				if ( Cr.Event == M.Tag )
				{
					log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
					log ("Being triggered by "$Cr$" with Event "$Cr.Event$", will be properly set.",'MapGarbage');
					M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
				}
				if ( S != None )
				if ( S.Event == M.Tag )
				{
					log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
					log ("Being triggered by "$S$" without to mind console, will be properly set.",'MapGarbage');
					M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
				}
				if ( Ds != None )
				{
					for (i=0;i<8;i++)
					{
						if ( Ds.OutEvents[i] == M.Tag )
						{
							log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
							log ("Being triggered by "$Ds$" having event OutEvents["$i$"]: "$Ds.OutEvents[i]$", without to mind console, will be properly set.",'MapGarbage');
							M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
						}
					}
				}
			}
		}
		if ( bNoGrabMoverCheat )
			if ( M.bUseTriggered )
			{
				M.bUseTriggered = False;
				log ("Detected & Resolved a Mover to not be cheated by GRAB command >> " @M.name,'MapGarbage');
			}
			if (M.bDamageTriggered)
				log(M@" >> is damage triggered",'MapGarbage');
			if ( bDoPawnOpenMover )
			if (!M.bTriggerOnceOnly && M.BumpType == BT_PlayerBump && ( M.InitialState == 'StandOpenTimed' || M.InitialState == 'BumpOpenTimed' || M.InitialState == 'BumpButon'))
			{
				log ("Mover"@M@"will be activated by any Pawn.",'MapGarbage');
				M.BumpType = BT_PawnBump;
			}
	}
}

final function TweakFactories()
{
	local int PP;
	local Actor A;
	local bool bPatrols;
	local PatrolPoint Po;

	PP = 0;

	foreach MyMap.AllActors (class 'PatrolPoint', Po)
	{
		PP++;
		bPatrols = True;
	}
	foreach MyMap.AllActors (class 'Actor', A)
	{
		if ( CreatureFactory(A) != None )
		{
			if ( CreatureFactory(A).Orders == 'Roaming' )
			{
				CreatureFactory(A).Orders = '';
				log ("Illegal settings discovered and removed at"@CreatureFactory(A),'MapGarbage');
			}
			if (CreatureFactory(A).Orders == 'Patroling' && !bPatrols)
			{
				CreatureFactory(A).Orders = '';
				log ("Order <Patroling> is invalid without a PatrolPoint at"@CreatureFactory(A)@"and has been eliminated.",'MapGarbage');
			}
			if ( CreatureFactory(A).itemtag == CreatureFactory(A).Tag )
			{
				log ("Detected bad self triggering at "$CreatureFactory(A)$". Screwing out...",'MapGarbage');
				CreatureFactory(A).itemtag = '';
			}
			if ( bChkMHFactAttack )
			{
				if ( !CreatureFactory(A).bOnlyPlayerTouched )
				{
					CreatureFactory(A).bOnlyPlayerTouched = True;
					log ("Removed wild touch ignition at "$CreatureFactory(A)$".",'MapGarbage');
				}
			}
		}
		if ( ScriptedPawn(A) != None )
		{
			if ( ScriptedPawn(A).Orders == 'Roaming' || ( ScriptedPawn(A).Orders == 'Patroling' && !bPatrols ) || ScriptedPawn(A).Orders == 'Hunting' )
			{
				log (ScriptedPawn(A)$" having order "$ScriptedPawn(A).Orders$" has been reset because it has no logic here.",'MapGarbage');
				ScriptedPawn(A).Orders = '';
			}
		}
	}
	if ( bPatrols )
	{
		if (PP < 2)
			log ("This level contains"@PP@"PatrolPoint. Interesting!",'MapGarbage');
		else
			log ("This level contains"@PP@"PatrolPoints.",'MapGarbage');
		}
		else
			log ("This level doesn't include any PatrolPoint.",'MapGarbage');
}

final function CheckDefaultMonster()
{
	local ScriptedPawn S;

	if ( MaxHealthAllowed <= 0 )
	{
		log ("MaxHealthAllowed is not Set. Using 100000 as reference...",'MapGarbage');
		MaxHealthAllowed = 100000;
	}

	foreach MyMap.AllActors(class'ScriptedPawn',S)
	{
		if ( S.Health > 0 )
		{
			if ( S.Mesh == None && S.Class.Default.Mesh != None || S.Mesh != S.Class.Default.Mesh )
			{
				log ("Creature"@S.Name@"will be restored",'MapGarbage');
				S.Mesh = S.Class.Default.Mesh;
				S.DrawType = DT_Mesh;
			}
			if ( S.Health > MaxHealthAllowed )
			{
				log ("Creature"@S.Name@"will have excessive Health lowered...",'MapGarbage');
				S.Health = MaxHealthAllowed;
			}
			if ( S.Orders != '' )
			{
				if ( S.Orders == 'Roaming' )
					S.Orders = '';
				if ( S.Orders != 'Sitting' || S.Orders != 'Ambushing' || S.Orders != 'Guarding' || S.Orders != 'Patroling' )
				{
					log ("Nulling out order for"@S.Name@"being"@S.Orders@".",'MapGarbage');
					S.Orders = '';
				}
			}
			if ( S.Skill > 3 )
				S.Skill = 3;
			if ( S.Skill < 1 )
				S.Skill = 1;
			if ( S.Aggressiveness > 2 )
				S.Aggressiveness = 2;
			if ( S.SightRadius > 4096 )
				S.SightRadius = 4096;
			if ( S.PeripheralVision > -0.2 )
				S.PeripheralVision = -0.2;
			if ( S.PeripheralVision < -1.0 )
				S.PeripheralVision = - 1.0;
			if ( S.HearingThreshold > 0.5 )
				S.HearingThreshold = 0.5;
			if ( S.RangedProjectile != None && !S.RangedProjectile.IsA('Projectile') ) //Yeah, idiots!
				S.RangedProjectile = S.Class.Default.RangedProjectile;
			if ( S.GroundSpeed > 500 )
				S.GroundSpeed = 500;
			if ( S.WaterSpeed > 350 )
				S.WaterSpeed = 350;
			if ( S.AirSpeed > 600 )
				S.AirSpeed = 600;
			if ( S.AccelRate > 1500 )
				S.AccelRate = 1500;
			S.MeleeRange = S.Class.Default.MeleeRange;
			S.SetCollisionSize(S.Class.Default.CollisionRadius,S.Class.Default.CollisionHeight);
			if ( S.IsA('Tentacle') )
				S.AnimSequence='Hide';
		}
	}
}

final function BoostAmmo()
{
	local Ammo A;

	foreach MyMap.AllActors(class'Ammo',A)
	{
		if ( A.Class.Default.MaxAmmo < 2 )
			continue;
		if ( A.Class.Default.AmmoAmount == 0 )
			A.Class.Default.AmmoAmount = 2;
		if ( A.AmmoAmount < ( A.Class.Default.AmmoAmount*3 ) )
			A.AmmoAmount *= 3;
		if ( A.RespawnTime > ( A.Class.Default.RespawnTime/3 ) )
			A.RespawnTime = int( A.Class.Default.RespawnTime/3 );
		if ( !A.IsA('TournamentAmmo') )
			A.PickupMessageClass = class'Botpack.PickupMessagePlus';
	}
}

final function DoXCRecovery()
{
	local InventorySpot I;
	local Inventory Inv;
	local int A;

	foreach MyMap.AllActors( class'InventorySpot',I )
	{
		if ( I.MarkedItem != None && I.MarkedItem.myMarker == None )
		{
			A++;
			I.MarkedItem.myMarker = I;
		}
	}
	if ( A > 0 )
		log(A@"Inventory types have been linked with InvSpots accordingly...",'MapGarbage');
	if ( A == 0 )
		log("Did not find any Inventory without myMarker...",'MapGarbage');
	A = 0;
	foreach MyMap.AllActors( class'Inventory',Inv )
	{
		Inv.SetCollisionSize(Inv.Class.Default.CollisionRadius,Inv.Class.Default.CollisionHeight);
	}
}

final function DoStuckRotations()
{
	local Weapon W;

	foreach MyMap.AllActors(class 'Weapon',W)
	{
		W.bRotatingPickup = False;
		W.RotationRate.Pitch = 0;
		W.RotationRate.Roll = 0;
		W.RotationRate.Yaw = 0;
		W.bFixedRotationDir = False;
		if ( ChangedRespawn > 3.000000 )
			W.RespawnTime = ChangedRespawn;
		if ( W.RespawnTime < 3.000000 ) //No spam crap pickup logs
			W.RespawnTime = W.Class.Default.RespawnTime;
	}
}

final function DoPathsTuning()
{
	local PathNode P;
	local NavigationPoint N;

	foreach MyMap.AllActors(class'PathNode',P)
	{
		foreach MyMap.RadiusActors( class'NavigationPoint',N,51,P.Location )
		{
			if ( N != P )
			{
				P.Destroy();
				break;
			}
		}
	}
/*
	foreach MyMap.AllActors(class'PathNode',P,'DeleteMe')
	{
		P.Destroy();
	}
*/
}

final function DoHideSprites()
{
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.bHidden )
		{
			if ( A.Skin == None && A.Texture == A.Class.Default.Texture && A.DrawType == DT_Sprite )
			{
				A.DrawType = DT_None;
				A.Texture = None;
			}
		}
	}
}

final function DoFallBackSprites()
{
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.bHidden )
		{
			if ( A.Class.Default.Texture != None && A.Class.Default.DrawType == DT_Sprite
				&& A.Skin == None )
			{
				A.DrawType = A.Class.Default.DrawType;
				A.Texture = A.Class.Default.Texture;
			}
		}
	}
}

defaultproperties
{
     BitmapFilename="MapGarbager"
     ToolTip="Map Garbage"
}
