//=============================================================================
// MapGarbage.
//=============================================================================
class MapGarbage expands BrushBuilder;

var() LevelInfo MyMap;
var() bool bDoRemoveTrash, bRemoveNavNetwork, bRemoveNoReachPaths, bTryFixBadPaths, bCheckUnReachPaths,
 bPreNavigAddHck, bBuildNavNetwork, bCountReachSpecs, bShowSpecs, bUnLinkNavList, bReLinkNavList;
/*
	Reserved for updates
*/
var() bool bVeloTeleporter;
var() float ZVelocity;
var() bool bNoPtFromTeleporter, bCleanLocBytes, bRemoveBullshit,
 bFindXBrushes, bRemoveMonsters, bCullTextures, bTweakMHMovers,
 bTweakMoverGroup, bDoPawnOpenMover, bBadTrgMoverFix,
 bNoGrabMoverCheat, bTweakMHFactory, bChkMHFactAttack,
 bBoostAmmo3X, bFixFallingAmmmo, bXCPostNavHck, bHideSpriteActors,
 bUnHideSpriteActors, bTrySolveLocation, bRoundCylinder,
 bReportActors, bCheckItems, bStaticsReport,
 bCheckDuplicates, bTryFixDuplicates, bPurgeDupes2,
 bScanCTFAltPaths, bScanTeamStarts, bScanDefences, bFindVoidBuggers,
 bCheckZones, bStaticDecos, bDoKickSound, bReplaceActor;
var() class<Actor> ReplaceType, WithType;
var() bool bSPawnTweaks;
var() int MaxHealthAllowed;
var() bool bNoRotateWeapon;
var() float ChangedRespawn;
var() bool bHidePlStarts, bRestPlStarts;
var() int HoleLength;
var() bool bSimAltPathPicking;
var() int ATeam;
var() bool bDisconnectN1toN2;
var() NavigationPoint N1, N2;
var() bool bGet1stN1, bGet2ndN2;
var() bool bShowCharCodes;
// - An UScript Emulation of several features which I did not see in stage but they were in UnEdSrv.cpp
// - What the heck was your problem !!?? LEVEL LINKS - LEVEL VALIDATE - LEVEL FIX
var() bool bFindMapReachSpecs, bLevelLinks, bLevelValidateMap, bLevelFix; 
var() bool bFindAnActor;
var() name ActorClass, ActorTag;

var NavigationPoint S, N;
var string tmp, AText;
var name NullName;

//Misc vars
var bool bShowSpecsComment, bFlagsListed; //Prevent extra-spam with explanations in the same session
var bool bMyIntroShown;

/*
Constants defined as recommended by Barbie according to
translating into words of reachFlag returned by DescribeSpec.
As a matter of fact there are not many flags assigned, proving
how poorly coded is DevPath generally, suprisingly it do works
as it is for common needs...
The most common values are 1, 4, 9, 13, 32.
*/
const NF_Walk       = 1;  // = 0x01 = b0000.0001
const NF_Fly        = 2;  // = 0x02 = b0000.0010
const NF_Swim       = 4;  // = 0x04 = b0000.0100
const NF_Jump       = 8;  // = 0x08 = b0000.1000
const NF_Door       = 16; // = 0x10 = b0001.0000
const NF_Special    = 32; // = 0x20 = b0010.0000
const NF_PlayerOnly = 64; // = 0x40 = b0100.0000


final function FindLevel()
{
	if ( MyMap == None )
	{
		SetPropertyText("MyMap","MyLevel.LevelInfo0");
		if( MyMap==None )
			SetPropertyText("MyMap","MyLevel.LevelInfo1");
		if( MyMap==None )
			SetPropertyText("MyMap","MyLevel.LevelInfo2");
		if( MyMap==None )
		{
			Warn("Couldn't find levelinfo!");
			Log ("Please manually complete a LevelInfo name in MyMap variable for this map.",'GarbageLord');
		}
	}
	if ( !bMyIntroShown )
		log ("Found Level's Map:"@MyMap,'GarbageLord');
}

function bool Build()
{
	AText="";
	FindLevel();
	if ( MyMap == None )
		return BadParameters("No Valid LevelInfo has been found...");
	else
	{
	if ( !bMyIntroShown )
	{
		ShowIntro();
		bMyIntroShown = True;
	}

	if ( bTryFixBadPaths )
	{
		bRemoveNavNetwork = True;
		DoPathsTuning();
		MyMap.ConsoleCommand("actor select none");
		MyMap.ConsoleCommand("map sendto last");
		bBuildNavNetwork = True;
	}

	if ( bRemoveNavNetwork )
	{
		MyMap.ConsoleCommand("PATHS UNDEFINE");
		CleanLeftOverData();
		MyMap.ConsoleCommand("OBJ GARBAGE");
		if ( bTryFixBadPaths )
			bRemoveNavNetwork = False;
	}

	if ( bPreNavigAddHck )
	{
		MyMap.ConsoleCommand("actor select none");
		MyMap.ConsoleCommand("set PathNode CollisionHeight 44");
		MyMap.ConsoleCommand("set PathNode CollisionRadius 18");
		MyMap.ConsoleCommand("set PathNode bMovable 0");
		MyMap.ConsoleCommand("set PathNode bCollideWhenPlacing 0");
		MyMap.ConsoleCommand("set InventorySpot CollisionHeight 40");
		MyMap.ConsoleCommand("set InventorySpot CollisionRadius 8");
		MyMap.ConsoleCommand("set InventorySpot bMovable False");
		MyMap.ConsoleCommand("set InventorySpot bHiddenEd False");
		MyMap.ConsoleCommand("set LiftExit CollisionHeight 44");
		MyMap.ConsoleCommand("set LiftExit CollisionRadius 18");
		MyMap.ConsoleCommand("set LiftCenter CollisionHeight 44");
		MyMap.ConsoleCommand("set LiftCenter CollisionRadius 18");
		MyMap.ConsoleCommand("set JumpSpot CollisionHeight 44");
		MyMap.ConsoleCommand("set JumpSpot CollisionRadius 18");
		MyMap.ConsoleCommand("set TranslocDest CollisionHeight 44");
		MyMap.ConsoleCommand("set TranslocDest CollisionRadius 18");
		MyMap.ConsoleCommand("set TranslocStart CollisionHeight 44");
		MyMap.ConsoleCommand("set TranslocStart CollisionRadius 18");
		MyMap.ConsoleCommand("set AlternatePath CollisionHeight 44");
		MyMap.ConsoleCommand("set AlternatePath CollisionRadius 18");
		MyMap.ConsoleCommand("set PathNode DrawScale 0.5");
		MyMap.ConsoleCommand("set Inventory bCollideWorld 1");
		MyMap.ConsoleCommand("set NavigationPoint bEdShouldSnap 1");
		MyMap.ConsoleCommand("set Scout CollisionHeight 40");
		MyMap.ConsoleCommand("set Scout CollisionRadius 19");
		MyMap.ConsoleCommand("set Scout GroundSpeed 200");
		MyMap.ConsoleCommand("set Scout WaterSpeed 180");
		MyMap.ConsoleCommand("set Scout JumpZ 200");
		MyMap.ConsoleCommand("set Scout bCanJump 1"); //Not sure if it helps but definitely doesn't hurt
		MyMap.ConsoleCommand("map sendto last");
	}

	if ( bBuildNavNetwork )
	{
//		class'InventorySpot'.Default.Texture=Texture'Engine.S_Inventory';
//		class'InventorySpot'.Default.DrawScale=0.5;
		MyMap.ConsoleCommand("PATHS DEFINE");
		MyMap.ConsoleCommand("SET INVENTORYSPOT TEXTURE S_INVENTORY");
		MyMap.ConsoleCommand("SET INVENTORYSPOT DRAWSCALE 0.5");
		if ( bTryFixBadPaths )
			bBuildNavNetwork = False;
	}

	if ( bXCPostNavHck )
		DoXCRecovery();

	if ( bNoRotateWeapon )
		DoStuckRotations();

	if ( bRemoveBullshit)
		DoKillShitPlayers();

	if ( bRemoveMonsters )
		DoRemoveMonsters();

	if ( bBoostAmmo3X )
		BoostAmmo();

	if ( bFixFallingAmmmo )
		FixFallingAmmo();

	if ( bReplaceActor )
	{
		if ( ReplaceType == None )
		{
			Log("No Actor Type set for being replaced...");
			return BadParameters("You must declare actor-class that has to be replaced...");
			GoTo NoReplace;
		}
		if ( WithType == None )
		{
			Log("No Actor Type set as replacement...");
			return BadParameters("You must declare actor-class used as replacement for"@ReplaceType);
			GoTo NoReplace;
		}
		DoReplacement();
NoReplace:
	}

	if ( bTweakMHMovers )
		DoMoverHacks();

	if ( bTweakMHFactory )
		TweakFactories();

	if ( bSPawnTweaks )
		CheckDefaultMonster();

	if ( bCullTextures )
		MyMap.ConsoleCommand("TEXTURE CULL");

	if ( bHideSpriteActors )
		DoHideSprites();

	if ( bUnHideSpriteActors )
		DoFallBackSprites();

	if ( bDoRemoveTrash )
	{
		MyMap.ConsoleCommand("OBJ GARBAGE");
		MyMap.ConsoleCommand("FLUSH");
	}

	if ( bTrySolveLocation )
		RelocateActors();

	if ( bReportActors )
		LogWrappedNames();

	if ( bRemoveNoReachPaths )
		RemoveVisNoReaches();

	if ( bShowSpecs )
		ShowNavSpecifications();

	if ( bCountReachSpecs )
		CountReachSpecs();

	if ( bCheckUnReachPaths )
		CheckUnReachable();

	if ( bCheckItems )
		CheckItemLocation();

	if ( bHidePlStarts )
		LowerThem();

	if ( bRestPlStarts )
		UpperThem();

	if ( bRoundCylinder )
		RoundActorCylinder();

	if ( bStaticsReport )
		ReportScrewedStatics();

	if ( bScanCTFAltPaths )
		ReportCTFAlternatePaths();

	if ( bSimAltPathPicking )
		SimulateAltPathPicking();

	if ( bCheckDuplicates )
		FindCrappedActors();

	if ( bPurgeDupes2 )
		DestroyDupes();

	if ( bFindVoidBuggers )
		ScanVoidCharge();

	if ( bScanTeamStarts )
		CheckPlayerStarts();

	if ( bCheckZones )
		ZonesCheck();

	if ( bDisconnectN1toN2 )
	{
		RemovePath();
		bDisconnectN1toN2 = False;
	}

	if ( bGet1stN1 )
	{
		GetNodeN1();
		bGet1stN1 = False;
	}

	if ( bGet2ndN2 )
	{
		GetNodeN2();
		bGet2ndN2 = False;
	}

	if ( bScanDefences )
		ScanDefencePoints();

	if ( bStaticDecos )
		StuckThisDeco();

	if ( bCleanLocBytes )
		CleanOldLocation();

	if ( bNoPtFromTeleporter )
		RemoveFromTeleporterPath();

	if ( bDoKickSound )
		MakeAudibleKickers();

	if ( bShowCharCodes )
		LogMyChars();

	if ( bFindMapReachSpecs )
		ListNumberOfSpecs();

	if ( bFindXBrushes )
		ReportNoDistanceBrushes();

	if ( bUnLinkNavList )
		RuinNavPointList();

	if ( bReLinkNavList )
		LinkValidNavList();

	if ( bVeloTeleporter )
		AddTeleporterZVelocity();
//	An UScript Emulation of certain checks - I do not have access at natives from here... at least I'm not aware how to do that.
	if ( bLevelLinks )
		ValidateLinksClone();

	if ( bLevelValidateMap )
		LevelValidateClone();

	if ( bLevelFix )
		LevelFixSounds();

	if ( bFindAnActor )
		FindDefinedStuff();
	}
	if ( AText == "" )
		AText="MapGarbage ver. "$CHR(13)$CHR(10)$CHR(9)$"May 2020"$CHR(13)$CHR(10)$CHR(9)$CHR(9)$"Task Ended"$CHR(13)$CHR(10)$CHR(13)$CHR(10)$"Working results are logged"$CHR(13)$CHR(10)$CHR(9)$"if available.";
	return BadParameters(AText);
}

final function ShowIntro()
{
	log(CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45),'Intro');
	log(CHR(9)$CHR(9)$CHR(9)$"MAPGARBAGE Edition May 2020",'Intro');
	log(CHR(9)$"Builder and checker for editing/fabricating UT'99 maps.",'Intro');
	log(CHR(9),'Intro');
	log(CHR(9)$"Explained functionality should be found in release notes document.",'Intro');
	log(CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45),'Intro');
}

final function CheckUnReachable()
{
	local NavigationPoint N;
	local int Skips, Borks, Good;
	local string CRLF;

	CRLF = Chr(13)$Chr(10);

	foreach MyMap.AllActors(class'NavigationPoint',N)
	{
		if ( Teleporter(N) != None )
		{
			if (Teleporter(N).URL == "" || Teleporter(N).URL == "None" )
			{
				log ("Skipping"@N.Name@"because it has no Destination.",'UnReachableNodes');
				Skips++;
				continue;
			}
		}
		if ( N.Region.Zone.bWaterZone )
		{
			log ("Skipping"@N.Name@"because it's in water.",'UnReachableNodes');
			Skips++;
			continue;
		}
		if ( NoReachTo(N) )
		{
			Borks++;
			log (N.Name@"looks much over ground for normal Human Size, check it",'UnReachableNodes');
		}
		else
		{
			Good++;
		}
	}
	log ("Here we have"@Skips@"points skipped,"@Borks@" Navigation Points which are too high and"@Good@"good ones.",'UnReachableNodes');
	if ( AText == "" )
	{
		AText = "Basically this map has:"$CRLF$CHR(9)$"- "$Skips@"points skipped;"$CRLF$CHR(9)$"- "$Borks@"Navigation Points with a high Placement;"$CRLF$CHR(9)$"- "$Good@"are found normally reachable."$CRLF;
	}
}

function bool NoReachTo(NavigationPoint N)
{
	local bool bValid;
	local actor HitActor;
	local vector HitLocation, HitNormal;

	bValid = ( N != None );

	if ( bValid )
		return MyMap.FastTrace( N.Location,N.Location+vect(0,0,-79) );

	return bValid;
}

final function FindDefinedStuff()
{
	local Actor A;
	local int NFound;
	local string CRLF;

	CRLF = Chr(13)$Chr(10);

	if ( ActorClass == '' || ActorClass == '' )
	{
		if ( ActorTag == '' || ActorTag == 'None' )
		{
			log ("Nothing specified to be found...",'ActorFinder');
			return;
		}
		else
		{
			foreach MyMap.AllActors(class'Actor',A,ActorTag)
			{
				log (A.Name,'Found');
				A.bSelected = True;
				NFound++;
			}
			log ("Found and selected"@NFound@"actors...",'ActorFinder');
		}
	}
	else
	{
		if ( ActorTag == '' || ActorTag == 'None' )
		{
			foreach MyMap.AllActors( class 'Actor', A )
			{
				if ( A.IsA(ActorClass) )
				{
					log(A.Name,'ActorClassFound');
					A.bSelected = True;
					NFound++;
				}
			}
			log ("Found and selected"@NFound@"actors...",'ActorFinder');
		}
		else
		{
			foreach MyMap.AllActors( class 'Actor', A, ActorTag )
			{
				if ( A.IsA(ActorClass) )
				{
					log(A.Name,'ActorClassTaggedFound');
					A.bSelected = True;
					NFound++;
				}
			}
			log ("Found and selected"@NFound@"actors...",'ActorFinder');
		}
	}
	if ( AText == "" )
		AText = "Found and Selected"@NFound@"actors."$CRLF;
}

final function LevelFixSounds()
{
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.SoundRadius < 1 || A.SoundRadius >= 255 )
			A.SoundRadius = A.Clamp(4*(INT(A.SoundRadius)),0,255);
	}
	log("Sound fixes emulation ended.",'LEVELFIX');
	if ( AText == "" )
		AText = "Level Fix Emulation Executed";
}

final function LevelValidateClone()
{
	local Actor A;
	local Pawn P;
	local bool bNotEmpty;
	local int NPl, NPlbad, Nbr;
	local string tmpBrush, CRLF;

	CRLF = Chr(13)$Chr(10);

	log("Level Validation:",'LEVELVALIDATE');

	AText = "";
//	Assign normal TournamentPlayer collision - I won't use BotPack as dependency package

	class'PlayerPawn'.default.CollisionHeight = 39.000000;
	class'PlayerPawn'.default.CollisionRadius = 17.000000;
	class'PlayerPawn'.default.bCollideWhenPlacing = True;
	class'PlayerPawn'.default.bCollideWorld = True;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A != MyMap && Camera(A) == None )
			bNotEmpty = True;
		if ( Brush(A) != None )
		{
			tmpBrush = A.GetPropertyText("Brush");
//			log(A.Name@Brush(A).Brush);
			if ( Len(tmpBrush) > 0 && Right(tmpBrush,5) != "Brush")
					Nbr++;
			tmpBrush = "";
			continue;
		}
		if ( PlayerStart(A) != None )
		{
			NPl++;
			log ("Checking"@A.Name,'PlayerStart');
			P = MyMap.Spawn(class'PlayerPawn',,,A.Location,A.Rotation );
			if ( P == None || P.bDeleteMe )
			{
				NPlbad++;
				log("Warning, potential unusable"@A.Name,'PlayerStart');
				continue;
			}
			if ( P != None )
			{
				P.Destroy();
				P = None;
			}
			continue;
		}
	}
	if ( bNotEmpty )
	{
		if ( Nbr == 1 )
			bNotEmpty = False;
	}
	if ( !bNotEmpty )
	{
		log("This map is Empty.",'VALIDATEERROR');
		AText = "EMPTY MAP !"$CRLF;
	}
	else
	{
		if ( NPl == 0 )
		{
			log ("Error: Missing PlayerStart actor!",'LEVELVALIDATE');
			AText = "No PlayerStars detected. USELESS Level ?"$CRLF;
		}

		if ( NPlbad > 0 )
		{
			if ( NPlbad == 1 )
				log("Error:"@NPlbad@"PlayerStart doesn't fit!",'LEVELVALIDATE');
			else
				log("Error:"@NPlbad@"PlayerStart actors don't fit!",'LEVELVALIDATE');
			AText = AText$"Some PlayerStarts have issues."$CRLF;
		}

		if ( MyMap.Title == "" )
		{
			log("Error: Level is missing a title!",'LEVELVALIDATE' );
			AText = AText$"Level is missing a Title."$CRLF;
		}
		if ( MyMap.Title ~= "Untitled" )
		{
			log("Warning: Level is untitled.",'LEVELVALIDATE' );
			AText = AText$"Level has Untitled name."$CRLF;
		}
		if (!bNotEmpty)
			log("This map is Empty.",'VALIDATEERROR');
	}
	log("Validation done...",'LEVELVALIDATE');
	bLevelValidateMap = False;
	if ( AText == "" )
		AText = "LEVEL VALIDATION ENDED.";
}

final function ValidateLinksClone()
{
	local int Internal, External;
	local Teleporter T;

	log("Level Links Check...",'LEVELLINKS');
	foreach MyMap.AllActors(class'Teleporter',T)
	{
		if ( T.URL != "" && T.URL != "None" )
		{
			log(T.Name@"uses destination"@T.URL,'Teleporter');
			if ( InStr(T.URL,"//") != -1 ) 
				External++;
			else
				Internal++;
		}
	}
	log ("Links report:",'LEVELLINKS');
	if ( External > 0 || Internal > 0 )
	{
		log ("    External Links ="@External@"destinations.",'Outside');
		log ("     Internal Links ="@Internal@"destinations.",'Inside');
	}
	else
	{
		log ("No Teleporter Linked has been found or map doesn't have Teleporters,",'VALIDATELINKS');
	}
	log("Map Check Done.",'LEVELLINKS');
	if ( AText == "" )
		AText = "Links Checked.";
	bLevelLinks = False;
}

final function AddTeleporterZVelocity()
{
	local Teleporter T;

	if ( ZVelocity <= 0 )
	{
		log ("You should specify a good value for teleporter velocity, taking 180.",'BadValuesNotAccepted');
		ZVelocity = 180;
	}

	foreach MyMap.AllActors(class'Teleporter',T)
	{
		if ( T.class == class 'Engine.Teleporter'
		|| T.class == class'UnrealShare.FavoritesTeleporter'
		|| T.class == class'BotPack.VisibleTeleporter')
		{
			if (!T.bChangesVelocity)
			{
				T.bChangesVelocity = True;
				T.TargetVelocity.Z = ZVelocity;
			}
			else
			{
				Log (T.Name@"is already out of default velocity settings and then it has been excepted.",'ExceptingTelepoter');
			}
		}
		else
		{
			log (T.Name@"has been excepted from Velocity tweaking",'');
		}
	}
	bVeloTeleporter = False;
	if ( AText == "" )
		AText = "Teleporters adjusted.";
}

final function RuinNavPointList()
{
	local NavigationPoint N;
	local int NNav;

	if ( MyMap.NavigationPointList == None )
	{
		log ("Useless Hit !!! Navigation Nework is already separated, it will need reconstruction.",'AlreadySeparate');
		log ("Map will need a NavigationPointList linked list which is already nulified.",'AlreadySeparate');
		bUnLinkNavList = False;
		if ( AText == "" )
			AText = "NavigationPointlist is already empty.";
		return;
	}
	MyMap.NavigationPointList = None;

	foreach MyMap.AllActors( class 'NavigationPoint', N )
	{
		NNav++;
		if ( N.nextNavigationPoint != None )
			N.nextNavigationPoint = None;
	}
	log ("NavigationPointList from"@NNav@"points has been properly ruined.",'UnLinkedNavigationPointList');
	if ( AText == "" )
		AText = "NavigationPointlist chain has been disconnected and removed.";
	bUnLinkNavList = False;
}

final function LinkValidNavList()
{
	local NavigationPoint N, NOld;
	local int NNav, NOut;
	local string CRLF;

	CRLF = Chr(13)$Chr(10);

	if ( MyMap.NavigationPointList != None )
	{
		log("Wrong !!! Navigation Network is already wrapped.",'AlreadyListDone');
		log("A NavigationPointList has been already done, more or less with MapGarbage.",'AlreadyListDone');
		if ( AText == "" )
			AText = "NavigationPointlist is already loaded and linked.";
		bReLinkNavList = False;
		return;
	}

	foreach MyMap.AllActors( class'NavigationPoint',N )
	{
		if ( MyMap.NavigationPointList == None ) //First will go into chain 
		{
			if ( N.Region.iLeaf > -1 ) //Region.iLeaf
			{
				NNav++;
				MyMap.NavigationPointList = N;
				NOld = N;
				NOld.NextNavigationPoint = None; //Remove any possible point
			}
		}
		else
		{
			if ( N.Region.iLeaf > -1 )
			{
				NNav++;
				NOld.NextNavigationPoint = N;
				NOld = N;
			}
			else
			{
				if ( N.Paths[0] == -1 && N.upstreamPaths[0] == -1 )
				{
					NOut++;
					log ("Found some bullshit"@N.Name@"without any reachSpecs into void, proceed deletion.",'ReLinkNavigation');
					N.Destroy();
				}
				else
				{
					NOut++;
					log ("Fake Void Zone contains valid NavigationPoint"@N.Name@"which has reachSpecs referenced.",'BadZoning');
				}
			}
		}
	}
	Log("Linked"@NNav@"navigationpoint actors.",'RelinkedNavigationList');
	Log (NOut@" points have been excepted/removed being invalid and placed into void.",'RelinkedNavigationList');
	Log ("GREETINGS for cleaning up junks.",'RelinkedNavigationList');
	if ( AText == "" )
		AText = "NavigationPointlist chain has been linked with"$CHR(9)$CRLF$Nnav$" actors.";
	bReLinkNavList = False;
}

final function CleanOldLocation()
{
	local Actor A;
	local bool bFnd;
	local int nAdj;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.OldLocation.X != 0 )
		{
			bFnd = True;
			A.OldLocation.X = 0;
		}
		if ( A.OldLocation.Y != 0 )
		{
			bFnd = True;
			A.OldLocation.Y = 0;
		}
		if ( A.OldLocation.Z != 0 )
		{
			bFnd = True;
			A.OldLocation.Z = 0;
		}
		if ( bFnd )
		{
			bFnd = False;
			nAdj++;
		}
	}
	CleanLeftOverData();
	log ("OldLocation data has been cleaned.",'CleanedBytes');
	log (nAdj@"actors have been cleaned by OldLocation data stored.",'CleanedBytes');
	if ( AText == "" )
		AText = nAdj@"actors have been cleaned by OldLocation data.";
}

final function ReportNoDistanceBrushes()
{
	local Brush B, B1;

	foreach MyMap.AllActors (class'Brush',B)
	{
		foreach B.RadiusActors(class'Brush',B1,10,B.Location)
		{
			if ( B1 != B )
			{
				log ("Found"@B1.Name@"closer to"@B.Name,'MultiBrush');
			}
		}
	}
	log ("Same located brush report ended...",'A_SameAs_B');
	if ( AText == "" )
		AText = "Brushes in same location"$CHR(9)$CHR(13)$CHR(10)$"have been logged if available.";
}

final function ListNumberOfSpecs()
{
	local int i, d, d0;
	local NavigationPoint N;
	local Actor Start, End;
	local int distance, reachFlags;
	local Name TName;
	local string tstr;

	if ( MyMap.NavigationPointList == None )
	{
		log("Map do not have a NavigationPointsList, don't be a fool.",'INVALIDLIST');
		return;
	}

	tstr = ""$chr(13)$"";
	TName = StrToName(tstr);
	i = 0;
	class'PathNode'.Default.bCollideWorld = False;
	class'PathNode'.Default.bCollideWhenPlacing = False;
	N = MyMap.Spawn(class'PathNode');
	if ( N != None )
	{
		while ( i < 1000001 )
		{
			N.Paths[0] = i;
//			log ("Testing next reachSpec"@i,'Check');
			N.DescribeSpec(N.Paths[0], Start, End, reachFlags, distance );
			if ( Start == None || End == None )
			{
				log ("I found"@i@"reachspecs, from 0 to"@i-1$".",'MaxNumFound');
				if ( d > 0 )
					log (d@"reachSpecs have nodes claimed too close.",'WarnDist');
				if ( d0 == 0 )
				{
					log ("We do have"@d0@"reachspecs with ZERO distance.",'WarnNoDist');
					log ("More than a node in the same place ? Pathing error ?",'WarnNoDist');
				}
				break;
			}
			else
			{
				if ( distance > 0 && distance < 50 )
					d++;
				if ( distance == 0 );
					d0++;
				log ( "ReachSpec"@i@"data:",'SpecContent');
				log ( CHR(9)$CHR(9)$"- Start       ="@Start.Name,'Data' );
				log ( CHR(9)$CHR(9)$"- End         ="@End.Name,'Data' );
				log ( CHR(9)$CHR(9)$"- ReachFlags  ="@GetReadableFlag_Barbie(reachFlags)$"="$reachFlags,'Data' );
				log ( CHR(9)$CHR(9)$"- Distance    ="@distance,'Data' );
				log (CHR(32),TName);
			}
			i++;
			Start = None;
			End = None;
			distance = 0;
			reachFlags = 0;
		}
		if ( i > 999999 )
		{
			log( " !!! This is insanity !!! ",'NumReachSpecs');
		}
		N.Destroy();
		N = None;
	}
	else
	{
		log ("Cannot check number of ReachSpecs, probing node for working could not spawn.",'FailListingSpecs');
		if ( AText == "" )
			AText = "Something went wrong,"$CHR(13)$CHR(10)$"probing node could not spawn.";
	}
	if ( AText == "" )
	{
		if ( i > 1 )
			AText = "Found "$i$" reachspecs.";
		else
			AText = "Poorly loaded map.";
	}
}

final function LogMyChars()
{
	local int i;

	log ("For internal development this is a logged list with characters CHR(i) from 0 to 255.",'CharsList');
	for ( i = 0; i < 256; i++ )
	{
		log ("Character CHR("$i$") ="@CHR(i),'CharsListing');
	}
	if ( AText == "" )
		AText = "Characters 0-255 have been logged.";
}

final function MakeAudibleKickers()
{
	local Kicker K;
	local SpecialEvent Se;
	local String tmp;

	foreach MyMap.AllActors(class'Kicker',K)
	{
		if ( K.bSelected )
		{
			tmp = "A_";
			K.SetPropertyText("Event",tmp$K.Name);
			Se = MyMap.Spawn(class'SpecialEvent',,K.Event,K.Location+vect(0,0,8));
			if ( Se != None )
			{
				Se.Sound = Sound'UnrealI.Pickups.BootJmp';
				Se.Tag = K.Event;
				Se.SetCollision(False,False,False);
				Se.SetCollisionSize(0,0);
				Se.InitialState = 'PlaySoundEffect';
				Se = None;
			}
			K.bSelected = False;
		}
	}
	if ( AText == "" )
		AText = "Kickers operated.";
}

final function RemoveFromTeleporterPath()
{
	local Teleporter T;
	local NavigationPoint N;
	local Actor Start, End;
	local int distance, reachFlags, i, j, k;
	local bool bOutTeleporterDone, bTelLog, bHaveTeleporters;

	if ( MyMap.NavigationPointList == None )
	{
		log("Map do not have a NavigationPointsList, don't be dumb.",'INVALIDLIST');
		return;
	}

	log ("Operating notes summary:",'TeleporterDeconnector');
	log ("     - looking for Teleporters set as destination, these should not have disconnected any path to another navigation node.",'TeleporterDeconnector');
	log ("     - looking for Teleporters with Destination, touching them result in teleporting.",'TeleporterDeconnector');
	log ("     - paths coming from Teleporters with a Destination, I think are pointless - these are deleted.",'TeleporterDeconnector');
	log ("     - also these paths set as UpstreamPaths in connected nodes are removed and reachSpecs list wrapped.",'TeleporterDeconnector');
	log ("     - after finishing removal of paths from a teleporter, reachSpecs list will be also wrapped.",'TeleporterDeconnector');
	log ("     - for whatever "$CHR(148)$"Special"$CHR(147)$" map I recommend doing a backup before removing these navigation references.",'TeleporterDeconnector');
	log (CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45)$CHR(45),'TeleporterDeconnector');

	foreach MyMap.AllActors(class'Teleporter',T)
	{
		bHaveTeleporters = True;
		if ( string(T.Tag) != MyMap.GetItemName(string(T.Class)) && string(T.Tag) != "None" )
		{
			log ("Excepting Destination ?"@T.Name,'TeleporterDeconnector');
			log ("________________________________________",'TeleporterDeconnector');
			continue;
		}
		if ( T.URL != "" && T.URL != "None" )
		{
			for ( i = 0; i < 16; i++ )
			{
				if ( T.Paths[i] != -1 )
				{
					T.DescribeSpec( T.Paths[i], Start, End, reachFlags, distance );
					if ( End != None && !End.IsA('Teleporter') )
					{
						j++;
						bOutTeleporterDone = True;
						N = NavigationPoint(End);
						if ( !bTelLog )
						{
							log ("Teleporter"@T.Name@" -->> Listing connections:",'TeleporterDeconnector');
							bTelLog = True;
						}
						log ("    - connected to"@N.Name,'TeleporterDeconnector');
						for ( k = 0; k < 16; k++ )
						{
							if ( N.UpstreamPaths[k] == T.Paths[i])
							{
								log ("    -"@N.Name@"has UpstreamPaths["$k$"] connected",'TeleporterDeconnector');
								N.UpstreamPaths[k] = -1;
								DefragUpstreamPaths(N);
							}
						}
						T.Paths[i] = -1;
						N = None;
					}
					Start = None;
					End = None;
				}
			}
			DefragPaths(T);
//			DefragUpstreamPaths(T);
			bTelLog = False;
			log ("________________________________________",'TeleporterDeconnector');
		}
	}
	if ( !bOutTeleporterDone )
	{
		if ( bHaveTeleporters )
			log ("I could not find a suitable Teleporter for Removing outgoing paths - these do looks needed as they are.",'TeleporterDeconnector');
		else
			log ("I could not find any Teleporter for removing outgoing paths.",'TeleporterDeconnector');
	}
	else
		log ("I have removed Extra-Paths from"@j@"Teleporters.",'TeleporterDeconnector');
	if ( AText == "" )
		AText = "Teleporters operated. See log.";
}

final function DefragPaths(NavigationPoint N)
{
	local bool bInvalid;
	local int i, np, cnt;
	local int wrap[16];

	bInvalid = ( N == None || N.bDeleteMe );

	if ( !bInvalid )
	{
		for ( i = 0; i < 16; i++ )
		{
			wrap[i] = N.Paths[i];
			N.Paths[i] = -1;
		}
		cnt = 0;
		for ( np = 0; np < 16; np++ )
		{
			if ( wrap[np] != -1 )
			{
				N.Paths[cnt] = wrap[np];
				cnt++;
			}
		}
	}
	else
		log("Borked - DefragPaths Entry ( NavigationPoint == None )",'PathsListDefragmenter');
}

final function DefragUpstreamPaths(NavigationPoint N)
{
	local bool bInvalid;
	local int i, np, cnt;
	local int wrap[16];

	bInvalid = ( N == None || N.bDeleteMe );

	if ( !bInvalid )
	{
		for ( i = 0; i < 16; i++ )
		{
			wrap[i] = N.UpstreamPaths[i];
			N.UpstreamPaths[i] = -1;
		}
		cnt = 0;
		for ( np = 0; np < 16; np++ )
		{
			if ( wrap[np] != -1 )
			{
				N.UpstreamPaths[cnt] = wrap[np];
				cnt++;
			}
		}
	}
	else
		log("Borked - DefragUpstreamPaths Entry ( NavigationPoint == None )",'UpStreamPathsListDefragmenter');
}

/*
final function CleanTags()
{
	local Actor A;
	local int Nbyt;

	foreach MyMap.AllActors(class 'Actor', A)
	{
		if ( Mover(A) != None )
			continue;
		if ( string(A.Tag) ~= A.GetItemName(string(A.Class)) )
		{
			Nbyt += Len(string(A.Tag));
			A.Tag = '';
		}
	}
	if ( Nbyt > 0 )
		log ("Removed"@Nbyt@"characters.",'TagsCleanUp');
	else
		log ("Map is clean or has been cleaned already.",'TagsCleanUp');
}
*/

final function CountReachSpecs()
{
	local int I, J;
	local NavigationPoint N;
/*
		Using simple testing without any "for" cycle.
		Not using UpstreamPaths because they have similar values as in Paths and DescribeSpec
returns the same connection. These have been tested and paths deleted for logging results.
		XC_EditorAdds building a clean network, at paths removal shows the same number of
reachspecs deleted as in counting report - demonstrating that solution works fine.
*/
	if ( MyMap.NavigationPointList == None )
	{
		log("Map do not have a NavigationPointsList, don't be dumb.",'INVALIDLIST');
		return;
	}

	if ( !bShowSpecsComment )
	{
		log ("According to class UnPath.h from Engine",'NumReachSpecs');
		log ("---------------------------------------",'NumReachSpecs');
		log ("#define DEBUGGINGPATHS  1 //1 to put path info in log",'NumReachSpecs');
		log ("#define MAXMARKERS 3000 //bound number of turn markers",'NumReachSpecs');
		log ("#define MAXREACHSPECS 3000 //bound number of reachspecs",'NumReachSpecs');
		log ("#define MAXCOMMONRADIUS 70 //max radius to consider in building paths",'NumReachSpecs');
		log ("#define MAXCOMMONHEIGHT 70",'NumReachSpecs');
		log ("#define MINCOMMONHEIGHT 48 //min typical height for non-human intelligent creatures",'NumReachSpecs');
		log ("#define MINCOMMONRADIUS 24 //min typical radius for non-human intelligent creatures",'NumReachSpecs');
		log ("#define COMMONRADIUS    52 //max typical radius of intelligent creatures",'NumReachSpecs');
		log ("#define HUMANRADIUS     18 //normal player pawn radius",'NumReachSpecs');
		log ("#define HUMANHEIGHT     39 //normal playerpawn height",'NumReachSpecs');
		log ("---------------------------------------",'NumReachSpecs');
		log ("A high number means increasing the stress for engine and getting closer to boundaries.",'NumReachSpecs');
		log ("Plain games are also capping at 1000 Paths searched from whatever Point.",'NumReachSpecs');
		log ("There is absolutely no reason for adding PathNodes near an Inventory - any.",'NumReachSpecs');
		log ("Frankly you don't even need internal PathBuild command - it's a mess from all angles.",'NumReachSpecs');
		log ("---------------------------------------",'NumReachSpecs');
		bShowSpecsComment = True;
	}
	foreach MyMap.AllActors(class 'NavigationPoint', N)
	{
		if ( N.Paths[0] > -1 )
			I++;
		if ( N.Paths[1] > -1 )
			I++;
		if ( N.Paths[2] > -1 )
			I++;
		if ( N.Paths[3] > -1 )
			I++;
		if ( N.Paths[4] > -1 )
			I++;
		if ( N.Paths[5] > -1 )
			I++;
		if ( N.Paths[6] > -1 )
			I++;
		if ( N.Paths[7] > -1 )
			I++;
		if ( N.Paths[8] > -1 )
			I++;
		if ( N.Paths[9] > -1 )
			I++;
		if ( N.Paths[10] > -1 )
			I++;
		if ( N.Paths[11] > -1 )
			I++;
		if ( N.Paths[12] > -1 )
			I++;
		if ( N.Paths[13] > -1 )
			I++;
		if ( N.Paths[14] > -1 )
			I++;
		if ( N.Paths[15] > -1 )
			I++;
		if ( N.PrunedPaths[0] > -1 )
			J++;
		if ( N.PrunedPaths[1] > -1 )
			J++;
		if ( N.PrunedPaths[2] > -1 )
			J++;
		if ( N.PrunedPaths[3] > -1 )
			J++;
		if ( N.PrunedPaths[4] > -1 )
			J++;
		if ( N.PrunedPaths[5] > -1 )
			J++;
		if ( N.PrunedPaths[6] > -1 )
			J++;
		if ( N.PrunedPaths[7] > -1 )
			J++;
		if ( N.PrunedPaths[8] > -1 )
			J++;
		if ( N.PrunedPaths[9] > -1 )
			J++;
		if ( N.PrunedPaths[10] > -1 )
			J++;
		if ( N.PrunedPaths[11] > -1 )
			J++;
		if ( N.PrunedPaths[12] > -1 )
			J++;
		if ( N.PrunedPaths[13] > -1 )
			J++;
		if ( N.PrunedPaths[14] > -1 )
			J++;
		if ( N.PrunedPaths[15] > -1 )
			J++;
	}
	log ("This map has"@I@"ReachSpecs shown as direct paths in Navigation Network.",'NumReachSpecs');
	if ( J > 0 )
	{
		log ("Also this map has"@J@"ReachSpecs as shortcuts aka PrunedPaths in Navigation Network.",'NumReachSpecs');
		log ("These are not visible in Editor but they are used by Pawns.",'NumReachSpecs');
	}
	else
		log ("We don't have shortcuts known as PrunedPaths in this map, which is not bad at all.",'NumReachSpecs');
	log ("After calculation we have"@I+J@"ReachSpecs.",'NumReachSpecs');
	if ( (I + J) <= 0 )
	{
		log ("Map doesn't include paths?",'NumReachSpecs');
		Goto DoneReach;
	}
	if ( (I + J) > 3000 )
		log ("Technically this map is overloaded and this is not that healthy for A.I.",'NumReachSpecs');
	else
		log ("It looks like map has a normal reachspecs charge for UE1. Greetings !",'NumReachSpecs');
DoneReach:
	if ( AText == "" )
		AText = I+J$" ReachSpecs referenced are logged.";
}

final function StuckThisDeco()
{
	local Decoration Deco;
	local BlockAll Ba;
	local vector NewLoc;
	local bool bSomething;

	bSomething = False;
	foreach MyMap.AllActors(class 'Decoration', Deco)
	{
		if ( Deco.bSelected && Deco.DrawType == DT_Mesh )
		{
			if ( !bSomething )
				bSomething = True;
			NewLoc.X = int(Deco.Location.X); //Get rid of floating shite
			NewLoc.Y = int(Deco.Location.Y);
			NewLoc.Z = int(Deco.Location.Z);
			Ba = MyMap.Spawn(class'BlockAll',,,NewLoc,Deco.Rotation);
			if ( Ba != None && !Ba.bDeleteMe )
			{
//				Ba.SetLocation(NewLoc);
				Ba.Mesh = Deco.Mesh;
				Ba.Skin = Deco.Skin;
				Ba.AnimSequence = Deco.AnimSequence;
				Ba.AnimRate = Deco.AnimRate;
				Ba.AnimFrame = Deco.AnimFrame;
				Ba.bUnlit = Deco.bUnlit;
				Ba.ScaleGlow = Deco.ScaleGlow;
				Ba.AmbientGlow = Deco.AmbientGlow;
				Ba.LightBrightness = Deco.LightBrightness;
				Ba.LightHue = Deco.LightHue;
				Ba.LightSaturation = Deco.LightSaturation;
				Ba.LightType = Deco.LightType;
				Ba.LightEffect = Deco.LightEffect;
				Ba.bSpecialLit = Deco.bSpecialLit;
				Ba.LightCone = Deco.LightCone;
				Ba.LightPeriod = Deco.LightPeriod;
				Ba.LightPhase = Deco.LightPhase;
				Ba.LightRadius = Deco.LightRadius;
				Ba.VolumeBrightness = Deco.VolumeBrightness;
				Ba.VolumeFog = Deco.VolumeFog;
				Ba.VolumeRadius = Deco.VolumeRadius;
				Ba.Multiskins[0] = Deco.Multiskins[0];
				Ba.Multiskins[1] = Deco.Multiskins[1];
				Ba.Multiskins[2] = Deco.Multiskins[2];
				Ba.Multiskins[3] = Deco.Multiskins[3];
				Ba.Multiskins[4] = Deco.Multiskins[4];
				Ba.Multiskins[5] = Deco.Multiskins[5];
				Ba.Multiskins[6] = Deco.Multiskins[6];
				Ba.Multiskins[7] = Deco.Multiskins[7];
				Ba.DrawScale = Deco.DrawScale;
				Ba.SetCollisionSize(int(Deco.CollisionRadius),int(Deco.CollisionHeight));
				Ba.DrawType = DT_Mesh;
				Ba.SetCollision(Deco.bCollideActors,Deco.bBlockActors,Deco.bBlockPlayers);
				Ba.bCollideWorld = Deco.bCollideWorld;
				Ba.Style = Deco.Style;
				Ba.PrePivot = Deco.Prepivot;
				log (Deco.Name@"is now a static"@Ba.Name,'StaticDecoCreate');
				Deco.Destroy();
				Ba.bSelected = True; //mmm...
				Ba = None;
			}
		}
	}
	if ( !bSomething )
	{
		if ( AText == "" )
			AText = "Nothing found Selected for being a STATIC Decoration.";
		log ("You have to select a decoration for being morphed as a static thing...",'StaticDecoFail');
	}
	else
		if ( AText == "" )
			AText = "Selected Decorations hacked, see log.";
}

final function ScanDefencePoints()
{
	local DefensePoint Dp;
	local int T0, T1;

	foreach MyMap.AllActors(class 'DefensePoint',Dp)
	{
		if ( Dp.Team == 0 )
		{
			T0++;
			if ( Dp.Texture != Texture'NewRed' )
				Dp.Texture = Texture'NewRed';
			else
				Dp.Texture = Dp.class.default.Texture;
			continue;
		}
		if ( Dp.Team == 1 )
		{
			T1++;
			if ( Dp.Texture != Texture'NewBlue' )
				Dp.Texture = Texture'NewBlue';
			else
				Dp.Texture = Dp.class.default.Texture;
			continue;
		}
	}
	if ( T0 > 0 )
		log ("Map has"@T0@"DefensePoint Actors for team 0.",'DefenseChecks');
	else
		log ("Map has"@T0@"DefensePoint Actors for team 0. Check if this is wrong.",'DefenseChecks');
	if ( T1 > 0 )
		log ("Map has"@T1@"DefensePoint Actors for team 1.",'DefenseChecks');
	else
		log ("Map has"@T1@"DefensePoint Actors for team 1. Check if this is wrong.",'DefenseChecks');

	if ( AText == "" )
			AText = "DefencePoints have been printed, see log.";
}

//Nodes 12

final function GetNodeN1()
{
	local NavigationPoint N;

	N1 = None;
	foreach MyMap.AllActors(class'NavigationPoint', N)
	{
		if ( N.bSelected )
		{
			N1 = N;
			break;
		}
	}
	if ( N1 != None )
		log ("Completing N1 as"@N1.Name,'Node1Taken');
	else
		log("Please select node which has to be the start of path - N1",'NoNodeN1');
}

final function GetNodeN2()
{
	local NavigationPoint N;

	N2 = None;
	foreach MyMap.AllActors(class'NavigationPoint', N)
	{
		if ( N.bSelected )
		{
			N2 = N;
			break;
		}
	}
	if ( N2 != None )
		log ("Completing N2 as"@N2.Name,'Node2Taken');
	else
		log("Please select node which has to be the start of path - N2",'NoNodeN2');
}

final function RemovePath()
{
	local Actor Start, End;
//	local NavigationPoint N;
	local int distance, reachFlags, i, j;
	local bool bFoundPath, bFoundUpStream;

/*
	Finally I got into what was NEEDED for years but no one has bothered with doing it
	This is just removing shit failures by un-referencing evil path as TranslocDest does in games
out of translocator - simple as a pie and very useful.
*/

	if ( N1 == None || N2 == None )
	{
		log ("You need to specify both N1 and N2 Navigation Points having evil path that has to be removed...",'Disconnector');
		log ("You can get them one by one by selecting node1, puting bool bGet1stN1 to True",'LazyHint');
		log ("And then the same with node2 not both in the same time - then using this command",'LazyHint');
		log ("If GUI interface of builder doesn't show anything it needs some clicks on values, for triggering a refresh.",'LazyHint');
		log ("bGet1stN1 will complete selected Node as N1 when is True and button BUILD pushed,",'LazyHint');
		log ("bGet2ndN2 will complete selected Node as N2 when is True and button BUILD pushed.",'LazyHint');
		log ("After completion of Names N1 and N2, value bDisconnectN1toN2 must be True and push BUILD button.",'LazyHint');
		log ("If everything is selected correctly Editor.log will have printed the action performed.",'LazyHint');
		return;
	}
	for ( i=0; i<16; i++ )
	{
		if ( N1.Paths[i] != -1 )
			N1.DescribeSpec( N1.Paths[i], Start, End, reachFlags, distance );
		if ( Start == N1 && End == N2 )
		{
			log ("Found Connection from"@N1.Name@"to"@N2.Name@"with reachFlags ="@reachFlags$", removing ReachSpec reference...",'Disconnector');
			N1.Paths[i] = -1;
			bFoundPath = True;
			log ("Compacting paths list in"@N1.Name@"if possible...",'Disconnector');
			Start = None;
			End = None;
		}
	}
	if ( bFoundPath )
		DefragPaths(N1);
	if ( !bFoundPath )
		log ("There is no Path from"@N1.Name@"to"@N2.Name@"described in"@N1.Name$".",'Disconnector');
	log ("Searching UpstreamPaths reachSpec reference into"@N2.Name$"...",'Disconnector');
	for ( j=0; j<16; j++ )
	{
		if ( N2.UpstreamPaths[j] != -1 )
			N2.DescribeSpec( N2.UpstreamPaths[j], Start, End, reachFlags, distance );
		if ( Start == N1 && End == N2 )
		{
			log ("Found Connection from"@N1.Name@"to"@N2.Name@"with reachFlags ="@reachFlags$", removing ReachSpec reference...",'Disconnector');
			N2.UpstreamPaths[j] = -1;
			bFoundUpStream = True;
			log ("Compacting UpstreamPaths list in"@N2.Name@"if possible...",'Disconnector');
			Start = None;
			End = None;
		}
	}
	if ( bFoundUpStream )
		DefragUpstreamPaths(N2);
	if ( !bFoundUpStream )
		log ("There is no Upstream from"@N1.Name@"to"@N2.Name@"described in"@N2.Name$".",'Disconnector');
	if ( bFoundPath )
		log("Disconnected Path going from"@N1.Name@"to"@N2.Name,'Disconnector');
	if ( bFoundUpStream )
		log("Disconnected upstreamPath going from"@N1.Name@"to"@N2.Name,'Disconnector');
	log("______________________________________________________________________________________________",'Disconnector');
	N1 = None;
	N2 = None;
}

final function ZonesCheck()
{
	local ZoneInfo Zones[255], AZone;
	local byte i, j, ZonesCount;

	foreach MyMap.AllActors(Class'ZoneInfo', AZone)
		Zones[ZonesCount++] = AZone;

	if ( ZonesCount > 63 )
		log("More than 63 Zones! Zone properties will be unpredictable.",'ZoningChecker');

	for (i=0; i < ZonesCount-1; i++)
		for (j=i+1; j < ZonesCount; j++)
			if (Zones[i].Region.ZoneNumber == Zones[j].Region.ZoneNumber)
				log(Zones[i].Name @"and"@ Zones[j].Name @"share the same zone",'ZoningChecker');
	log ("Operation finished.",'ZoningCheck');
	if ( AText == "" )
		AText = "Zones checked, results are logged.";
}

final function CleanLeftOverData()
{
	local NavigationPoint N;

	foreach MyMap.AllActors( class'NavigationPoint',N )
	{
		N.bestPathWeight = 0;
		N.visitedWeight = 0;
	}
}

final function FixFallingAmmo()
{
	local Ammo A;
	local int i;

	foreach MyMap.AllActors(class'Ammo',A)
	{
		if ( A.Physics == PHYS_Falling )
		{
			i++;
			A.Physics = PHYS_None;
		}
	}
	if ( i > 0 )
		log (i$" ammo actors won't have physics falling.",'AmmoFall');
	else
		log ("There is no falling ammo in this map.",'AmmoFall');

	if ( AText == "" )
	{
		if ( i > 0 )
			AText = i$" Ammo won't fall, see log.";
		else
			AText = "There is no Falling Ammo for being adjusted.";
	}
}

final function CheckPlayerStarts()
{
	local PlayerStart Ps;
	local int T0, T1;

	foreach MyMap.AllActors(class 'PlayerStart',Ps)
	{
		if ( Ps.TeamNumber == 0 )
		{
			T0++;
			if ( Ps.Texture != Texture'NewRed' ) //Toggling texture for visibility
				Ps.Texture = Texture'NewRed';
			else
				Ps.Texture = Ps.class.default.Texture;
			continue;
		}
		if ( Ps.TeamNumber == 1 )
		{
			T1++;
			if ( Ps.Texture != Texture'NewBlue' )
				Ps.Texture = Texture'NewBlue';
			else
				Ps.Texture = Ps.class.default.Texture;
			continue;
		}
	}
	if ( T0 > 0 )
		log ("Map has"@T0@"PlayerStart Actors for team 0.",'StartingChecks');
	else
		log ("Map has"@T0@"PlayerStart Actors for team 0. Check if this is wrong.",'StartingChecks');
	if ( T1 > 0 )
		log ("Map has"@T1@"PlayerStart Actors for team 1.",'StartingChecks');
	else
		log ("Map has"@T1@"PlayerStart Actors for team 1. Check if this is wrong.",'StartingChecks');

	if ( AText == "" )
		AText = "PlayerStart actors checked, results are printed in Log.";
}

final function ScanVoidCharge()
{
	local Actor A;
	local int i;

	log ("--- Void placement report ---",'VoidCheck');
	i = 0;
	foreach MyMap.AllActors( class'Actor',A )
	{
		if ( Brush(A) != None
			|| LevelInfo(A) != None
			|| Camera(A) != None
			|| AmbientSound(A) != None )
			continue;
		else
			if ( A.Region.iLeaf < 0 )
			{
				i++;
				log (A.Name$" looks placed into void.",'VoidCheck');
			}
	}
	if ( i == 1 )
		log (i$" actor looks placed into void, check that possible useless garbage.",'VoidCheck');
	if ( i > 1 )
		log (i$" actors look placed into void, check those.",'VoidCheck');
	if ( i == 0 )
		log ("--- No Actor has been found into void. ---",'VoidCheck');
}

final function FindCrappedActors()
{
	local bool bLogged, bHasDupes;
	local Actor A, A1, Temp;
	local int i, j, iDup;
	local name TagIt, oldname;
	local string ToTag;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.Tag == 'Dup')
		{
			if ( !bHasDupes )
				bHasDupes = True;
			if ( bTryFixDuplicates )
			{
				log("Found duplicated - "$A.Name$" - Attempting removal",'Duplicated');
				A.Destroy();
//				continue;
			}
			else
			{
				if ( !bLogged )
				{
					bLogged = True;
					log ("Actors might be removed by using subsequent bTryFixDuplicates set to True.",'Duplicated');
					log ("Operation recommended in another clean editing session with both values set True.",'Duplicated');
				}
			}
			continue;
		}
		foreach MyMap.AllActors(class'Actor',A1,A.Tag)
		{
			if ( string(A.Name) == string(A1.Name) )
			{
				i++; iDup++;
				if ( i > 1 )
				{
					if ( bTryFixDuplicates )
					{
						log ( "Deleting "$A1.name,'Duplicated');
						A1.Destroy();
						i = 0;
						j++;
						continue;
					}
					else
					{
						A1.Tag = 'Dup';
						i = 0;
						j++; //older
					}
				}
			}
		}
		if ( iDup > 1 )
		{
			log (A.Name$" was found "$iDup$" times.",'Duplicated');
		}
		i = 0;
		iDup = 0;
	}
	if ( j > 0 )
		log ("Found"@j@"duplicated Actors.",'Duplicated');
	else
	{
		if ( bHasDupes && !bTryFixDuplicates )
			log ("Map has duplicated actors that might be removed.",'Duplicated');
		if ( !bHasDupes && j == 0 )
			log ("Map doesn't seems to include duplicated actors.",'MapInGoodState');
	}
	if ( bTryFixDuplicates )
	{
		MyMap.ConsoleCommand("set Actor bDeleteMe 0"); //You might need this else... Surprise !
		foreach MyMap.AllActors(class'Actor',A,'Dup') //Recover default mapped actor - it might be empty as well
		{
			ToTag = MyMap.GetItemName(string(A.class));
			TagIt = StrToName(ToTag);
			A.Tag = TagIt;
		}
	}
	log ("Duplicated Actors scanning is being finished.",'Duplicated');
}

final function DestroyDupes()
{
	local Actor A, A1;
	local int j, i;
	local bool bTagged;
	local name TagIt;
	local string ToTag;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.Tag == 'Dup' )
		{
			log("Pending removal of"@A.Name,'PurgeDuplicates2');
			A.Destroy();
			j++;
//			Continue;
		}
		else
		{
			foreach MyMap.AllActors(class'Actor',A1,A.Tag)
			{
				if ( string(A.Name) == string(A1.Name) )
				{
					i++;
					if ( i > 1 )
					{
						A1.Tag = 'Dup';
//						i = 0;
					}
				}
			}
			i = 0;
		}
	}
	A = None;
	foreach MyMap.AllActors(class'Actor',A,'Dup') //Recover default mapped actor - it might be empty as well
	{
		ToTag = MyMap.GetItemName(string(A.class));
		TagIt = StrToName(ToTag);
		A.Tag = TagIt;
	}
	if ( j > 0 )
	{
		log ("Removed a few duplicated Actors. You can press BUILD again...",'PurgeDuplicates2');
		MyMap.ConsoleCommand("set Actor bDeleteMe 0");
	}
	else
		log ("Nothing duplicated, or previous cleaning was successful.",'MapInGoodState');
}

final function RemoveVisNoReaches()
{
	local NavigationPoint N;
	local int i, j;

	log ("Scanning and removing VisNoReachPaths references.",'FlushBytes');
	log ("Also cleaning up other links...",'FlushBytes');

	for ( N=MyMap.NavigationPointList; N!=None; N=N.nextNavigationPoint )
	{
		if ( N.bAutoBuilt )
			N.bAutoBuilt = False;
		if ( N.visitedWeight > 0 )
			N.visitedWeight = 0;
		if ( N.nextOrdered != None )
			N.nextOrdered = None;
		if ( N.previousPath != None )
			N.previousPath = None;
		if ( N.prevOrdered != None )
			N.prevOrdered = None;
		if ( N.VisNoReachPaths[0] == None )
			continue;
		else
		{
			While ( N.VisNoReachPaths[i] != None )
			{
				N.VisNoReachPaths[i] = None;
				j++; i++;
				if ( i == 16 )
					break;
			}
			i = 0;
		}
		if ( N.PrunedPaths[0] < 0 )
			continue;
		else
		{
			While ( N.PrunedPaths[i] >= 0 )
			{
				N.PrunedPaths[i] = -1;
				i++;
				if ( i == 16 )
					break;
			}
			i = 0;
		}
	}
	log ("VisNoReachPaths nulified ="@j$".",'FlushBytes');
	MyMap.ConsoleCommand("map sendto last");
	if ( AText == "" )
		AText = "Removed"@j@"VisNoReachPaths.";
}

final function SimulateAltPathPicking()
{
	local AlternatePath Ap;
	local NavigationPoint N;
	local float totalWeight, selection, partialWeight;

	log("Testing AlternatePath choice for team"@ATeam,'SimulateAltPathPicking');
	if ( FRand() < 0.8 )
	{
		for ( N=MyMap.NavigationPointList; N!=None; N=N.nextNavigationPoint )
			if ( N.IsA('AlternatePath') && (AlternatePath(N).team != ATeam)
				&& !AlternatePath(N).bReturnOnly )
				TotalWeight += AlternatePath(N).SelectionWeight;
		selection = FRand() * TotalWeight;
		log ("Selection is"@selection@"and TotalWeight"@TotalWeight,'SimulateAltPathPicking');
		for ( N=MyMap.NavigationPointList; N!=None; N=N.nextNavigationPoint )
			if ( N.IsA('AlternatePath') && (AlternatePath(N).team != ATeam) )
			{
				Ap = AlternatePath(N);
				PartialWeight += AlternatePath(N).SelectionWeight;
				if ( PartialWeight > selection )
				{
					log ("Loop sort stops at PartialWeight"@PartialWeight,'SimulateAltPathPicking');
					break;
				}
			}
		log ("Presumed Bot from team"@ATeam@"has AlternatePath"@Ap.Name@"with team"@Ap.Team,'SimulateAltPathPicking');
	}
	else
	{
		log ("No AlternatePath this time.",'SimulateAltPathPicking');
	}
}

final function ReportCTFAlternatePaths()
{
	local AlternatePath Ap;
	local int T0, T1, T2, T3;

	foreach MyMap.AllActors (class 'AlternatePath', Ap)
	{
		if ( Ap.Team == 0 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 0",'CTFReport' );
			if ( Ap.Texture != Texture'NewRed' ) //Toggling texture for visibility
				Ap.Texture = Texture'NewRed';
			else
				Ap.Texture = Ap.class.default.Texture;
			T0++;
		}
		else if ( Ap.Team == 1 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 1",'CTFReport' );
			if ( Ap.Texture != Texture'NewBlue' )
				Ap.Texture = Texture'NewBlue';
			else
				Ap.Texture = Ap.class.default.Texture;
			T1++;
		}
		else if ( Ap.Team == 2 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 2",'CTFReport' );
			T2++;
		}
		else if ( Ap.Team == 3 )
		{
			log(Ap.Name@"has selectionweight ="@Ap.SelectionWeight@"and Team = 3",'CTFReport' );
			T3++;
		}
	}
	log ("--- Reporting AlternatePaths setup: ---",'CTFReport');
	log ("For Team 0 ="@T0@"pieces.",'CTFReport');
	log ("For Team 1 ="@T1@"pieces.",'CTFReport');
	if ( T2 > 0 || T3 > 0 )
	{
		log ("For Team 2 ="@T2@"pieces.",'CTFReport');
		log ("For Team 3 ="@T3@"pieces.",'CTFReport');
	}
	log ("Textures are toggling each time for figuring places, and they are restored at next hit.",'CTFReport');
	if ( AText == "" )
		AText = "AlternatePath type Actors have been logged.";
}

final function ReportScrewedStatics()
{
	local Actor A;
	local bool bLogged;

	foreach MyMap.AllActors( class'Actor',A )
	{
		if ( !A.bStatic && A.Class.Default.bStatic )
			log("Bork >>"@A.Name@"won't be seen in clients. Class has bStatic True and has been screwed to False.",'StaticsCheck');
		if ( A.bStatic && !A.Class.Default.bStatic )
		{
			log("Actor"@A.Name@"is screwed as bStatic. Check it...",'StaticsCheck');
			if ( Inventory(A) != None && !bLogged )
			{
				log ("Inventories are not supposed to be bStatic, this might screw mutators and their pickup behavior. Fix the crap!",'StaticsCheck');
				bLogged = True;
			}
		}
		if ( !A.bNoDelete && A.Class.Default.bNoDelete )
			log("Warning >>"@A.Name@"has bNoDelete False, original class is True... check actor for net play compatibility.",'StaticsCheck');
		if ( A.bNoDelete && !A.Class.Default.bNoDelete )
		{
			log("Actor"@A.Name@"is screwed as bNoDelete. Check it...",'StaticsCheck');
			if ( Inventory(A) != None && !bLogged )
			{
				log ("Inventories are not supposed to be bNoDelete, this might screw mutators and their pickup behavior. Fix the crap!",'StaticsCheck');
				bLogged = True;
			}
		}
	}
	if ( AText == "" )
		AText = "Static Modications checked, results are logged if exist.";
}

final function RoundActorCylinder()
{
	local Actor A;

	foreach MyMap.AllActors ( class'Actor',A )
	{
		if ( Brush(A) == None )
		{
			if ( A.DrawType == DT_Mesh && A.bCollideActors )
				if ( A.CollisionRadius != int( A.CollisionRadius )
					|| A.CollisionHeight != int( A.CollisionHeight ) )
				A.SetCollisionSize( int(A.CollisionRadius),int(A.CollisionHeight) );
		}
	}
	if ( AText == "" )
		AText = "Cylinders rounded.";
}

final function LowerThem()
{
	local NavigationPoint Ps;
	local vector NewLocation;
	local rotator NavRot;

	foreach MyMap.AllActors(class'NavigationPoint',Ps)
	{
		if ( PlayerStart(Ps) != None || SpawnPoint(Ps) != None || QueenDest(Ps) != None )
		{
			Ps.bCollideWhenPlacing = False;
			Ps.bCollideWorld = False;
			NavRot = Ps.Rotation;
			NewLocation = Ps.Location;
			NewLocation.Z -= HoleLength;
			Ps.SetLocation(NewLocation);
			if ( Ps.Rotation != NavRot )
				Ps.SetRotation(NavRot);
		}
	}
	if ( AText == "" )
		AText = "Not needed Navigation Points have been moved Down.";
}

final function UpperThem()
{
	local NavigationPoint Ps;
	local vector NewLocation;
	local rotator NavRot;

	foreach MyMap.AllActors(class'NavigationPoint',Ps)
	{
		if ( PlayerStart(Ps) != None || SpawnPoint(Ps) != None || QueenDest(Ps) != None )
		{
			Ps.bCollideWhenPlacing = False;
			Ps.bCollideWorld = False;
			NavRot = Ps.Rotation;
			NewLocation = Ps.Location;
			NewLocation.Z += HoleLength;
			Ps.SetLocation(NewLocation);
			if ( Ps.Rotation != NavRot )
				Ps.SetRotation(NavRot);
		}
	}
	if ( AText == "" )
		AText = "Not needed Navigation Points have been moved Up.";
}

final function CheckItemLocation()
{
	local Inventory I;
	local int CR, CH, iCh, nitem, average;
	local vector ILoc, TestLoc, ZPos;
	local rotator IRot;
	local bool bReportPaths;
	local Scout S;

	class'Scout'.default.bCollideWorld = True;
	class'Scout'.default.bCollideWhenPlacing = True;
	foreach MyMap.AllActors( class 'Inventory', I )
	{
		if ( I.MyMarker != None && !bReportPaths )
		{
			bReportPaths = True;
			log ("Testing items should happen BEFORE building A.I. paths...",'ItemLocator');
		}
		nitem++;
		I.bMovable = True;
		CR = int(I.CollisionRadius);
		CH = int(I.CollisionHeight);
		ILoc = I.Location;
		IRot = I.Rotation;
		ZPos.Z = ILoc.Z;
		I.SetCollisionSize(52,50);
		I.bCollideWorld = True;
		I.bCollideWhenPlacing = True;
		I.SetCollision(True,False,False);
		I.SetLocation(ILoc+vect(0,0,1));
		TestLoc = I.Location;
		if ( S == None )
			S = MyMap.Spawn(class'Scout',,,TestLoc);
		if ( S != None )
		{
			if (!S.SetLocation(TestLoc))
			{
				S.SetCollisionSize(20,40);
					log (I.Name$" might generate RED heavy path.",'InitialPathProbing');
			}
			if (!S.SetLocation(TestLoc))
				log (I.Name$" looks bad placed...",'ShrinkPathProbing');
			S.SetCollisionSize(S.class.default.CollisionRadius,S.class.default.CollisionHeight);
		}
		else
			log (I.Name$" did not allow first Paths test.",'ScoutCreate');
		if ( (int(TestLoc.X) != int(Iloc.X) ) || (int(TestLoc.Y) != int(ILoc.Y)) )
		{
			Log(I.Name$" trying to ajust.",'ItemLocator');
			TestLoc.Z = ZPos.Z;
			I.SetCollisionSize(CR,CH);
			I.SetLocation(TestLoc);
			I.SetRotation(IRot);
			iCh++;
		}
		else
		{
			I.SetCollisionSize(CR,CH);
			I.SetLocation(ILoc);
			I.SetRotation(IRot);
		}
	}
	if ( S != None )
	{
		S.Destroy();
		S = None;
	}
	class'Scout'.default.bCollideWorld = False;
	class'Scout'.default.bCollideWhenPlacing = False;
	if ( nitem > 0 )
	{
		average = ( iCh * 100 )/nitem;
		log ("Items checked !"@iCh@"items have been adjusted a bit, which means "$average$"% of map's items.",'ItemLocator');
	}
	else
		log ("Items checked, map has nothing like an Inventory",'ItemLocator');
	if ( AText == "" )
		AText = "Items checked.";
}

final function LogWrappedNames()
{
	local int I;
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		I++;
		log (A.Name@"is class"@A.Class@"and number"@I@".",'OrderOfActors');
	}
	log ( "Logged "$I$" actors..." );
	if ( AText == "" )
		AText = "Logged "$I$" actors...";
}

final function name StrToName(string AString)
{
	local Name TempName;

	tmp = AString;
	SetPropertyText("NullName",GetPropertyText("tmp"));
	TempName = NullName;
	NullName = '';
	tmp = "";
	return TempName;
}

final function ShowNavSpecifications()
{
	local NavigationPoint N;
	local bool bNothingSelected;
	local Actor Start, End;
	local int distance, reachFlags, i, j;
	local bool bUpPaths, bPaths;
	local Name TName;
	local string tstr;

	tstr = ""$chr(13)$"";
//	SetPropertyText("NullName",GetPropertyText("tmp"));

	TName = StrToName(tstr);

	bNothingSelected = True;
	foreach MyMap.AllActors( class'NavigationPoint',N )
	{
		if ( N.bSelected )
		{
			bNothingSelected = False;
			i = 0;
			do
			{
				if ( N.UpstreamPaths[i] != -1 )
				{
					log("___________________________________________",'Specs');
					N.DescribeSpec( N.UpstreamPaths[i], Start, End, reachFlags, distance );
					log ( N.Name@"- UpstreamPaths["$i$"]="$N.UpstreamPaths[i]@"->"$Start.Name@"--->"$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
//					log ( N.Name@"- UpstreamPaths["$i$"]="$N.UpstreamPaths[i]@"Start="$Start.Name@"End="$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					if ( End != None && End == N )
					{
						bUpPaths = True;
						log ( Start.Name@"to"@N.Name$".",'Connected');
					}
				}
				Start = None;
				End = None;
				reachFlags = 0;
				distance = 0;

				if ( N.Paths[i] != -1 )
				{
					log("___________________________________________",'Specs');
					N.DescribeSpec( N.Paths[i], Start, End, reachFlags, distance );
//					log ( N.Name@"- Paths["$i$"]="$N.Paths[i]@"Start="$Start.Name@"End="$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					log ( N.Name@"- Paths["$i$"]="$N.Paths[i]@"->"$Start.Name@"--->"$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					if ( Start != None && Start == N )
					{
						bPaths = True;
						log ( N.Name@"to"@End.Name$".",'Connected');
					}
				}
				if ( N.VisNoReachPaths[i] != None )
					log (N.Name@"to point"@i@"which means"@N.VisNoReachPaths[i].Name,'NoReachFrom');
				Start = None;
				End = None;
				reachFlags = 0;
				distance = 0;

				if ( N.PrunedPaths[i] != -1 )
				{
					log("___________________________________________",'Specs');
					N.DescribeSpec( N.PrunedPaths[i], Start, End, reachFlags, distance );
//					log ( N.Name@"- PrunedPaths["$i$"]="$N.PrunedPaths[i]@"Start="$Start.Name@"End="$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					log ( N.Name@"- PrunedPaths["$i$"]="$N.PrunedPaths[i]@"->"$Start.Name@"--->"$End.Name@"RFlags="$GetReadableFlag_Barbie(reachFlags)@"="$reachFlags@"Dist="$distance,'Specs' );
					if ( Start != None && Start == N )
					{
						bPaths = True;
						log ( N.Name@"to"@End.Name$".",'ShortcutConnected');
					}
				}
				Start = None;
				End = None;
				reachFlags = 0;
				distance = 0;
				i++;
			}
			until ( i == 16 );
			log (CHR(32),TName);
			if ( !bUpPaths )
				log ("No NavigationPoint heads to"@N.Name$"as shown in list. If a route passes through, it won't be usable.",'Specs');
			if ( !bPaths )
				log ("There isn't any connection starting from"@N.Name$".",'Specs');
			if ( !bUpPaths && !bPaths )
				log (N.Name@"do looks isolated from Navigation Network without connections. Check paths !",'Specs');
			bPaths = False;
			bUpPaths = False;
		}
		if ( N.bHiddenEd )
			N.bHiddenEd = False;
	}
	if (!bNothingSelected)
	{
		if (!bFlagsListed)
		{
			log ("ReachSpecs Flags summary:",'Specs');
			log ("R_WALK = 1",'Flg');
			log ("R_FLY = 2",'Flg');
			log ("R_SWIM = 4",'Flg');
			log ("R_JUMP = 8",'Flg');
			log ("R_DOOR = 16",'Flg');
			log ("R_SPECIAL = 32",'Flg');
			log ("R_PLAYERONLY = 64",'Flg');
			bFlagsListed = True;
		}
		if ( AText == "" )
			AText = "Registered ReachSpecs logged.";
	}
	else
	{
		if ( AText == "" )
			AText = "Nothing Selected, select a NavigationPoint.";
		log ("This option requires selecting one or more NavigationPoint actors...");
		bNothingSelected = False;
	}
}
/*
	Now are needed some constants declared in builder. Not bad.
*/
final function String GetReadableFlag_Barbie(int Flags)
{
	local string result;

	if (Flags == 0)
		return "NoFlag ";
	if ((Flags & NF_Special) != 0)
		result = result $ "Special ";
	if ((Flags & NF_PlayerOnly) != 0)
		result = result $ "PlayerOnly ";
	if ((Flags & NF_Door) != 0)
		result = result $ "Door ";
	if ((Flags & NF_Jump) != 0)
		result = result $ "Jump ";
	if ((Flags & NF_Swim) != 0)
		result = result $ "Swim ";
	if ((Flags & NF_Fly) != 0)
		result = result $ "Fly ";
	if ((Flags & NF_Walk) != 0)
		result = result $ "Walk ";
	// cut off last space:
	if (result != "")
		result = left(result, len(result) - 1);
	return result;
}

final function RelocateActors()
{
	local Actor A;
	local Vector NewLoc;

	foreach MyMap.AllActors(Class'Actor',A)
	{
		if ( Brush(A) == None )
		{
			NewLoc.X = int(A.Location.X);
			NewLoc.Y = int(A.Location.Y);
			NewLoc.Z = int(A.Location.Z);
			A.SetLocation(NewLoc);
		}
	}
	if ( AText == "" )
		AText = "Actors alignment operated.";
}

final function DoKillShitPlayers()
{
	local PlayerPawn P;

	foreach MyMap.AllActors(Class'PlayerPawn',P)
	{
		if ( !P.IsA('Camera') )
		{
			log ("Found lousy Pawn"@P@". Removing...",'MapGarbage');
			P.Destroy();
		}
	}
	if ( AText == "" )
		AText = "Player types checked.";
}

final function DoRemoveMonsters()
{
	local Pawn P;
	local int I;

	foreach MyMap.AllActors(Class'Pawn',P)
	{
		if ( !P.IsA('Camera') )
		{
			I++;
			P.Destroy();
		}
	}
	if (I == 0)
	{
		log ("Did not find Pawns for removal.",'MapGarbage');
	}
	else
	{
		if ( I == 1 )
			log ("Removed"@I@"Pawn...",'MapGarbage');
		else
			log ("Removed"@I@"Pawns...",'MapGarbage');
	}
	if ( AText == "" )
		AText = "Pawns checked.";
}

final function DoReplacement()
{
	local Actor A, B;
	local int NumRep;
	local Vector V;
	local Rotator R;
	local Name OTag, OEvent;
	local float DScale, CHeight, CRadius;

	numrep = 0;
	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.class == ReplaceType && A.bSelected )
		{
			V = A.Location;
			R = A.Rotation;
			OTag = A.Tag;
			OEvent = A.Event;
			DScale = A.DrawScale;
			CHeight = int(A.CollisionHeight);
			CRadius = int(A.CollisionRadius);
			A.Destroy();
			WithType.Default.bCollideWhenPlacing = False;
			B = MyMap.Spawn( WithType,,OTag,V,R );
			if ( B != None )
			{
				numRep++;
//				B.SetPropertyText("Event",string(OEvent));
				B.Event=OEvent;
				B.DrawScale=DScale;
				B.SetCollisionSize(CRadius,CHeight);
				B.bSelected=True;
/*
				SetPropertyText("DrawScale",string(DScale));
				SetPropertyText("CollisionHeight",string(CHeight));
				SetPropertyText("CollisionRadius",string(CRadius));
				WithType.SetPropertyText("bSelected","True");
*/
				B = None;
			}
		}
	}
	log (NumRep@"selected"@ReplaceType@"have been replaced with"@WithType);
	if ( AText == "" )
		AText = NumRep@"selected"@ReplaceType@"replaced with"@WithType;
}

final function DoMoverHacks()
{
	local Mover M;
	local name Grp;
	local Trigger T;
	local Counter Cr;
	local Dispatcher Ds;
	local ScriptedPawn S;
	local Actor Ac;
	local int i;

	foreach MyMap.AllActors(class 'Mover', M)
	{
		if ( M.bTriggerOnceOnly )
		{
			if ( M.MoverEncroachType == ME_ReturnWhenEncroach )
			{
				M.MoverEncroachType = ME_IgnoreWhenEncroach;
				log ("Detected & Resolved a Mover Triggered Once With ReturnWhenEncroach >> "@M.name,'MapGarbage');
			}
			if ( M.InitialState == 'TriggerControl' )
			{
				log ("Ass ? A mover with TriggerControl shouldn't be set bTriggerOnceOnly >> "@M.Name,'MapGarbage');
				log ("Attempt to fix mover state >> "@M.Name@" to TriggerOpenTimed.",'MapGarbage');
				M.InitialState = 'TriggerOpenTimed';
				if ( M.InitialState == 'TriggerOpenTimed' )
				{
					log ("Successfully fixed.",'MapGarbage');
				}
				else
					log ("Fixing failed !!!",'MapGarbage');
			}
		}
		if ( bTweakMoverGroup )
			if (M.InitialState == 'TriggerOpenTimed' && M.Group == M.default.Group)
			{
				M.Group = M.Name;
				log ("Mover"@M@"has been set for group"@M.Group,'MapGarbage');
			}
			M.NetUpdateFrequency = 10.000000;
			if ( M.MoverEncroachType == ME_CrushWhenEncroach && !M.bTriggerOnceOnly && M.BumpType != BT_PawnBump )
			{
				M.BumpType = BT_PawnBump;
				if ( M.EncroachDamage <= 0 )
					M.EncroachDamage = 500000;
			}
			if ( bDoPawnOpenMover )
			{
				if ( !M.bTriggerOnceOnly )
				foreach MyMap.AllActors (class 'Trigger', T)
				{
					if ( T.Event != '' && T.Event == M.Tag && !T.bTriggerOnceOnly )
					{
						if ( T.TriggerType == TT_ClassProximity )
						{
//						if (!ClassIsChildOf(SpawnClass, class'TournamentPlayer'))
							if ( ClassIsChildOf(T.ClassProximityType,class'ScriptedPawn') )
							{
								T.ClassProximityType = class'UnrealShare.ScriptedPawn';
							}
						}
						if( T.InitialState == 'NormalTrigger' )
							if (T.TriggerType == TT_PlayerProximity)
							{
								log ("Mover"@M@"looks meant for Player. Demanding Proximity changed.",'MapGarbage');
								T.TriggerType = TT_PawnProximity;
							}
					}
				}
			}
		if ( M.Tag != '' && bBadTrgMoverFix && M.InitialState == 'TriggerControl' )
		{
			foreach MyMap.AllActors(class 'Actor',Ac)
			{
				if ( Counter(Ac) != None )
					Cr = Counter(Ac);
				if ( ScriptedPawn(Ac) != None && Ac.Event != '')
					S = ScriptedPawn(Ac);
				if ( Dispatcher(Ac) != None )
					Ds = Dispatcher(Ac);
				if ( Cr != None )
				if ( Cr.Event == M.Tag )
				{
					log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
					log ("Being triggered by "$Cr$" with Event "$Cr.Event$", will be properly set.",'MapGarbage');
					M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
				}
				if ( S != None )
				if ( S.Event == M.Tag )
				{
					log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
					log ("Being triggered by "$S$" without to mind console, will be properly set.",'MapGarbage');
					M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
				}
				if ( Ds != None )
				{
					for (i=0;i<8;i++)
					{
						if ( Ds.OutEvents[i] == M.Tag )
						{
							log ("Mover "$M$" is just shit with "$M.InitialState$". Will attack InitialState and Encroaching method to avoid other error.",'MapGarbage');
							log ("Being triggered by "$Ds$" having event OutEvents["$i$"]: "$Ds.OutEvents[i]$", without to mind console, will be properly set.",'MapGarbage');
							M.InitialState = 'TriggerOpenTimed'; M.MoverEncroachType = ME_IgnoreWhenEncroach; M.bTriggerOnceOnly = True;
						}
					}
				}
			}
		}
		if ( bNoGrabMoverCheat )
			if ( M.bUseTriggered )
			{
				M.bUseTriggered = False;
				log ("Detected & Resolved a Mover to not be cheated by GRAB command >> " @M.name,'MapGarbage');
			}
			if (M.bDamageTriggered)
				log(M@" >> is damage triggered",'MapGarbage');
			if ( bDoPawnOpenMover )
			if (!M.bTriggerOnceOnly && M.BumpType == BT_PlayerBump && ( M.InitialState == 'StandOpenTimed' || M.InitialState == 'BumpOpenTimed' || M.InitialState == 'BumpButon'))
			{
				log ("Mover"@M@"will be activated by any Pawn.",'MapGarbage');
				M.BumpType = BT_PawnBump;
			}
	}
	if ( AText == "" )
		AText = "Movers checked.";
}

final function TweakFactories()
{
	local int PP;
	local Actor A;
	local bool bPatrols;
	local PatrolPoint Po;

	PP = 0;

	foreach MyMap.AllActors (class 'PatrolPoint', Po)
	{
		PP++;
		bPatrols = True;
	}
	foreach MyMap.AllActors (class 'Actor', A)
	{
		if ( CreatureFactory(A) != None )
		{
			if ( CreatureFactory(A).Orders == 'Roaming' )
			{
				CreatureFactory(A).Orders = '';
				log ("Illegal settings discovered and removed at"@CreatureFactory(A),'MapGarbage');
			}
			if (CreatureFactory(A).Orders == 'Patroling' && !bPatrols)
			{
				CreatureFactory(A).Orders = '';
				log ("Order <Patroling> is invalid without a PatrolPoint at"@CreatureFactory(A)@"and has been eliminated.",'MapGarbage');
			}
			if ( CreatureFactory(A).itemtag == CreatureFactory(A).Tag )
			{
				log ("Detected bad self triggering at "$CreatureFactory(A)$". Screwing out...",'MapGarbage');
				CreatureFactory(A).itemtag = '';
			}
			if ( bChkMHFactAttack )
			{
				if ( !CreatureFactory(A).bOnlyPlayerTouched )
				{
					CreatureFactory(A).bOnlyPlayerTouched = True;
					log ("Removed wild touch ignition at "$CreatureFactory(A)$".",'MapGarbage');
				}
			}
		}
		if ( ScriptedPawn(A) != None )
		{
			if ( ScriptedPawn(A).Orders == 'Roaming' || ( ScriptedPawn(A).Orders == 'Patroling' && !bPatrols ) || ScriptedPawn(A).Orders == 'Hunting' )
			{
				log (ScriptedPawn(A)$" having order "$ScriptedPawn(A).Orders$" has been reset because it has no logic here.",'MapGarbage');
				ScriptedPawn(A).Orders = '';
			}
		}
	}
	if ( bPatrols )
	{
		if (PP < 2)
			log ("This level contains"@PP@"PatrolPoint. Interesting!",'MapGarbage');
		else
			log ("This level contains"@PP@"PatrolPoints.",'MapGarbage');
		}
		else
			log ("This level doesn't include any PatrolPoint.",'MapGarbage');
	if ( AText == "" )
		AText = "Factories checked. Results are logged if exist.";
}

final function CheckDefaultMonster()
{
	local ScriptedPawn S;

	if ( MaxHealthAllowed <= 0 )
	{
		log ("MaxHealthAllowed is not Set. Using 100000 as reference...",'MapGarbage');
		MaxHealthAllowed = 100000;
	}

	foreach MyMap.AllActors(class'ScriptedPawn',S)
	{
		if ( S.Health > 0 )
		{
			if ( S.Mesh == None && S.Class.Default.Mesh != None || S.Mesh != S.Class.Default.Mesh )
			{
				log ("Creature"@S.Name@"will be restored",'MapGarbage');
				S.Mesh = S.Class.Default.Mesh;
				S.DrawType = DT_Mesh;
			}
			if ( S.Health > MaxHealthAllowed )
			{
				log ("Creature"@S.Name@"will have excessive Health lowered...",'MapGarbage');
				S.Health = MaxHealthAllowed;
			}
			if ( S.Orders != '' )
			{
				if ( S.Orders == 'Roaming' )
					S.Orders = '';
				if ( S.Orders != 'Sitting' || S.Orders != 'Ambushing' || S.Orders != 'Guarding' || S.Orders != 'Patroling' )
				{
					log ("Nulling out order for"@S.Name@"being"@S.Orders@".",'MapGarbage');
					S.Orders = '';
				}
			}
			if ( S.Skill > 3 )
				S.Skill = 3;
			if ( S.Skill < 1 )
				S.Skill = 1;
			if ( S.Aggressiveness > 2 )
				S.Aggressiveness = 2;
			if ( S.SightRadius > 4096 )
				S.SightRadius = 4096;
			if ( S.PeripheralVision > -0.2 )
				S.PeripheralVision = -0.2;
			if ( S.PeripheralVision < -1.0 )
				S.PeripheralVision = -1.0;
			if ( S.HearingThreshold > 0.5 )
				S.HearingThreshold = 0.5;
			if ( S.RangedProjectile != None && !S.RangedProjectile.IsA('Projectile') ) //Yeah, idiots!
				S.RangedProjectile = S.Class.Default.RangedProjectile;
			if ( S.GroundSpeed > 500 )
				S.GroundSpeed = 500;
			if ( S.WaterSpeed > 350 )
				S.WaterSpeed = 350;
			if ( S.AirSpeed > 600 )
				S.AirSpeed = 600;
			if ( S.AccelRate > 1500 )
				S.AccelRate = 1500;
			S.MeleeRange = S.Class.Default.MeleeRange;
			S.SetCollisionSize(int(S.Class.Default.CollisionRadius),int(S.Class.Default.CollisionHeight));
			if ( S.IsA('Tentacle') )
				S.AnimSequence='Hide';
		}
	}
	if ( AText == "" )
		AText = "Monsters have been checked.";
}

final function BoostAmmo()
{
	local Ammo A;

	foreach MyMap.AllActors(class'Ammo',A)
	{
		if ( A.Class.Default.MaxAmmo < 2 )
			continue;
		if ( A.Class.Default.AmmoAmount == 0 )
			A.Class.Default.AmmoAmount = 2;
		if ( A.AmmoAmount < ( A.Class.Default.AmmoAmount*3 ) )
			A.AmmoAmount *= 3;
		if ( A.RespawnTime > ( A.Class.Default.RespawnTime/3 ) )
			A.RespawnTime = int( A.Class.Default.RespawnTime/3 );
		if ( !A.IsA('TournamentAmmo') )
			A.SetPropertyText("PickupMessageClass","PickupMessagePlus");
	}
	if ( AText == "" )
		AText = "Ammo Actors have been boosted.";
}

final function DoXCRecovery()
{
	local InventorySpot I;
	local Inventory Inv;
	local int A;

	foreach MyMap.AllActors( class'InventorySpot',I )
	{
		if ( I.MarkedItem != None && I.MarkedItem.myMarker == None )
		{
			A++;
			I.MarkedItem.myMarker = I;
		}
	}
	if ( A > 0 )
		log(A@"Inventory types have been linked with InvSpots accordingly...",'MapGarbage');
	if ( A == 0 )
		log("Did not find any Inventory without myMarker...",'MapGarbage');
	A = 0;
	foreach MyMap.AllActors( class'Inventory',Inv )
	{
		Inv.SetCollisionSize(Inv.Class.Default.CollisionRadius,Inv.Class.Default.CollisionHeight);
	}
}

final function DoStuckRotations()
{
	local Weapon W;

	foreach MyMap.AllActors(class 'Weapon',W)
	{
		W.bRotatingPickup = False;
		W.RotationRate.Pitch = 0;
		W.RotationRate.Roll = 0;
		W.RotationRate.Yaw = 0;
		W.bFixedRotationDir = False;
		if ( ChangedRespawn > 3.000000 )
			W.RespawnTime = ChangedRespawn;
		if ( W.RespawnTime < 3.000000 ) //No spam crap pickup logs
			W.RespawnTime = W.Class.Default.RespawnTime;
	}
	if ( AText == "" )
		AText = "Weapons should no longer rotate.";
}

final function DoPathsTuning()
{
	local PathNode P;
	local NavigationPoint N;

	foreach MyMap.AllActors(class'PathNode',P)
	{
		foreach MyMap.RadiusActors( class'NavigationPoint',N,51,P.Location )
		{
			if ( N != P )
			{
				P.Destroy();
				break;
			}
		}
	}
/*
	foreach MyMap.AllActors(class'PathNode',P,'DeleteMe')
	{
		P.Destroy();
	}
*/
	if ( AText == "" )
		AText = "Nasty Nodes might be changed.";
}

final function DoHideSprites()
{
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.bHidden )
		{
			if ( A.Skin == None && A.Texture == A.Class.Default.Texture && A.DrawType == DT_Sprite )
			{
				A.DrawType = DT_None;
				A.Texture = None;
			}
		}
	}
	if ( AText == "" )
		AText = "Sprite Actors are hidden.";
}

final function DoFallBackSprites()
{
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.bHidden )
		{
			if ( A.Class.Default.Texture != None && A.Class.Default.DrawType == DT_Sprite
				&& A.Skin == None )
			{
				A.DrawType = A.Class.Default.DrawType;
				A.Texture = A.Class.Default.Texture;
			}
		}
	}
	if ( AText == "" )
		AText = "Sprite Actors might be visible.";
}

defaultproperties
{
	BitmapFilename="MapGarbager"
	ToolTip="Map Garbage"
}
