//=============================================================================
// MovingLight.
//=============================================================================
class MovingLight expands Light;

var() name 		FollowActor;
var() vector 	FollowOffset;
var() float 	RefreshTime;
var() bool 		bFollowRotation;	
var actor 		Following;
var bool 		bFollowing;
var float 		PassedTime;
var vector 		X,Y,Z;

function PreBeginPlay()
{
	PassedTime = 0;
	Following = FindActor(FollowActor);
	if ( Following != None && bMovable == True && bStatic == False )
	{
		bFollowing = True;
		Enable('Tick');
	}
	else
	{
		Disable('Tick');
	}
}

function Tick(float DeltaTime)
{
	if ( bFollowing == True )
	{
		PassedTime += DeltaTime;
		if( PassedTime >= RefreshTime )
		{
			if ( bFollowRotation == False )
			{
				SetLocation(Following.Location + FollowOffset);
			}
			else
			{
				GetAxes(Following.Rotation,X,Y,Z);
				SetLocation(Following.Location + FollowOffset.X * X + FollowOffset.Y * Y + FollowOffset.Z * Z);
			}
			PassedTime = 0;
		}
	}
}

function actor FindActor(name ActorName)
{
	local actor A;
	foreach AllActors(class 'Actor', A)
		if ( A.Tag == ActorName  || A.Name == ActorName )
			return A;
	// If there is no matching actor, return none.
	return None;
}

defaultproperties
{
     bAlwaysRelevant=True
     bMovable=True
     bNoDelete=False
     bStatic=False
}