//=============================================================================
// AMM.
//=============================================================================
class AMM expands Pack6Weps
	config(Pack6);

var float AltAccuracy,AnimSp;
var travel bool bAllredChecked;
var bool bChecked;
var travel int ClipC,CurrentClip,AmmAmount[4],MaxAmm;
var travel texture AmmoIcons[4];
var class<Projectile> ToShoot;
var sound FireS;
var class<Effects> ExpEf;
var class<RingExplosion4> RE;

var() config travel struct AmmoTypes_Type
{
	var() config int AmmoAmount,MaxAmmo,TraceShots,ProjShots,HitDamage,ClipCount;
	var() config string AmmoIcon,SelectMsg,ProjClass,TraceRingExp,HitWallExp,ShootSound;
	var() config bool bGotTraceFire,bASMDEffect,bGotProjFire;
	var() config float TraceMiss,ProjMiss,ReFireRate;
	var travel int AmmoC;
} AmmoTypes[30];
replication
{
	// Things the server should send to the client.
	reliable if( Role==ROLE_Authority && bNetOwner )
		AmmAmount,MaxAmm,AmmoIcons;
}

simulated event RenderOverlays( canvas Canvas )
{
	Super.RenderOverlays(Canvas);
	DrawIcons(Canvas);
}
simulated event DrawIcons( canvas Canvas )
{
	Canvas.Font = font'SmallFont';
	Canvas.SetPos(Canvas.ClipX-50,Canvas.ClipY-150);
	DrawIconss(AmmoIcons[1],32,Canvas);
	Canvas.SetPos(Canvas.ClipX-82,Canvas.ClipY-140);
	Canvas.DrawText(string(AmmAmount[1]));
	Canvas.Style=3;
	if( AmmoIcons[0]!=None )
	{
		Canvas.SetPos(Canvas.ClipX-50,Canvas.ClipY-185);
		DrawIconss(AmmoIcons[0],32,Canvas);
		Canvas.SetPos(Canvas.ClipX-82,Canvas.ClipY-175);
		Canvas.DrawText(string(AmmAmount[0]));
	}
	if( AmmoIcons[2]!=None )
	{
		Canvas.SetPos(Canvas.ClipX-50,Canvas.ClipY-118);
		DrawIconss(AmmoIcons[2],32,Canvas);
		Canvas.SetPos(Canvas.ClipX-82,Canvas.ClipY-108);
		Canvas.DrawText(string(AmmAmount[2]));
	}
	if( AmmoIcons[3]!=None )
	{
		Canvas.SetPos(Canvas.ClipX-50,Canvas.ClipY-86);
		DrawIconss(AmmoIcons[3],32,Canvas);
		Canvas.SetPos(Canvas.ClipX-82,Canvas.ClipY-76);
		Canvas.DrawText(string(AmmAmount[3]));
	}
	Canvas.Style=1;
}
simulated event DrawIconss( texture Text, float Scale, canvas Canvas )
{
	Canvas.DrawTile(Text,Scale,Scale, 0, 0, Text.USize, Text.VSize );
}
function PlaySelect()
{
	CheckAmmo();
	Super.PlaySelect();
	if(MySecondWeapon != None )
		MySecondWeapon.PlaySelect();
}
state NormalFire
{
Begin:
	if (AnimSequence!='Shoot0') 
	{
		PlayAnim('Shoot',2.5, 0.02);
		FinishAnim();
	}
	PlayAnim('Shoot0',0.26, 0.04);	
	if( !bIsMySecondWeapon )
	{
		Sleep(AnimSp/2);
		if( MySecondWeapon!=None && Pawn(Owner).bFire!=0 && !MySecondWeapon.IsInState('NormalFire') ) MySecondWeapon.Fire(0);
		Sleep(AnimSp/2);
	}
	else Sleep(AMM(OwnerGun).AnimSp);
	if ( AmmoType.AmmoAmount<=0 && !bIsMySecondWeapon )
		GoToState('ChangeClip');
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) && !bIsMySecondWeapon)
		GotoState('Idle');
	else if ( ClipC==0 && !bIsMySecondWeapon ) GoToState('NewClip');
	else if ( Pawn(Owner).bFire!=0 ) Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )Global.AltFire(0);		
	PlayAnim('Shoot2',0.8, 0.0);	
	FinishAnim();
	GoToState('Idle');
}
state NewClip
{
ignores Fire, AltFire;
Begin:
	if( MySecondWeapon!=None )
		MySecondWeapon.GoToState('NewClip');
	PlayAnim('Eject',1.5,0.05);
	Owner.PlaySound(Misc2Sound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	FinishAnim();
	PlayAnim('Down',1.2,0.05);
	FinishAnim();
	if( !bIsMySecondWeapon )
		ClipC = Default.AmmoTypes[CurrentClip].ClipCount;
	Owner.PlaySound(SelectSound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	PlayAnim('Select',1.6,0.07);
	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).bFire!=0 && !bIsMySecondWeapon )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 && !bIsMySecondWeapon )
		Global.AltFire(0);	
	else GotoState('Idle');
}
state ChangeClip
{
ignores Fire, AltFire;
Begin:
	if( MySecondWeapon!=None )
		MySecondWeapon.GoToState('NewClip');
	PlayAnim('Eject',1.5,0.05);
	Owner.PlaySound(Misc2Sound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	FinishAnim();
	PlayAnim('Down',1.2,0.05);
	FinishAnim();
	Owner.PlaySound(SelectSound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	PlayAnim('Select',1.6,0.07);
	FinishAnim();
	Pawn(Owner).ClientMessage(ChangeAmmo(true),'Pickup');
	if ( MySecondWeapon!=None && MySecondWeapon.bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);	
	else GotoState('Idle');
}
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local shellcase s;
	local vector realLoc;
	local vector SmokeLocation,DVector;
	local rotator SmokeRotation;
	local float NumPoints;
	local int i;
	local class<RingExplosion> rc;

	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}
	SmokeLocation = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * 3.3 * Y + FireOffset.Z * Z * 3.0;
	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/70.0;
	SmokeLocation += DVector/NumPoints;
	SmokeRotation = rotator(HitLocation-Owner.Location);
	if( bIsMySecondWeapon && AMM(OwnerGun).GetBoolV(2) )
	{
		if ( TazerProj(Other)!=None )
			TazerProj(Other).SuperExplosion();
		if (NumPoints>15) NumPoints=15;
		if ( NumPoints>1.0 ) SpawnEffect(DVector, NumPoints, SmokeRotation, SmokeLocation);
	}
	else if( !bIsMySecondWeapon && GetBoolV(2) )
	{
		if ( TazerProj(Other)!=None )
			TazerProj(Other).SuperExplosion();
		if (NumPoints>15) NumPoints=15;
		if ( NumPoints>1.0 ) SpawnEffect(DVector, NumPoints, SmokeRotation, SmokeLocation);
	}
	if( bIsMySecondWeapon )
		Spawn(AMM(OwnerGun).ExpEf,,, HitLocation+HitNormal*8,rotator(HitNormal));
	else Spawn(ExpEf,,, HitLocation+HitNormal*8,rotator(HitNormal));
	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if( bIsMySecondWeapon )
			Other.TakeDamage(AMM(OwnerGun).GetHitDamage(), Pawn(Owner), HitLocation, 3000.0*X, 'shot');
		else Other.TakeDamage(AmmoTypes[CurrentClip].HitDamage, Pawn(Owner), HitLocation, 3000.0*X, 'shot');
	}		
}
function SpawnEffect(Vector DVector, int NumPoints, rotator SmokeRotation, vector SmokeLocation)
{
	local RingExplosion4 Smoke;
	
	if( bIsMySecondWeapon )
		Smoke = Spawn(AMM(OwnerGun).RE,,,SmokeLocation,SmokeRotation);
	else Smoke = Spawn(RE,,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints;
}
function int GetHitDamage()
{
	Return AmmoTypes[CurrentClip].HitDamage;
}
function PlayPostSelect()
{
	if( !bChecked )
	{
		bChecked=true;
		ChangeAmmo(false);
	}
}
function Finish()
{
	if ( AmmoType.AmmoAmount<=0 && !bIsMySecondWeapon )
		GoToState('ChangeClip');
	if ( bChangeWeapon )
	{
		if( AMM(MySecondWeapon)!=None ) AMM(MySecondWeapon).GotoState('DownWeapon');
		GotoState('DownWeapon');
	}
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) )
	{
		if( AMM(MySecondWeapon)!=None ) AMM(MySecondWeapon).GotoState('Idle');
		GotoState('Idle');
	}
	else if (ClipC==0)
	{
		if( AMM(MySecondWeapon)!=None ) AMM(MySecondWeapon).GoToState('NewClip');
		GoToState('NewClip');
	}
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}
state Idle
{
	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}

Begin:
	if( Pawn(Owner)==None )
		GoToState('Pickup');
	bPointing=False;
	Disable('AnimEnd');
	if (FRand()<0.4) PlayAnim('Twiddle',0.6,0.8);
	else if (FRand()<0.7) PlayAnim('Sway1',0.02, 0.8);
	else PlayAnim('Twirl',1, 0.8);
	if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 && !bIsMySecondWeapon ) Global.Fire(0.0);
	if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 && !bIsMySecondWeapon ) Global.AltFire(0.0);
	FinishAnim();
	GoTo('Begin');
}
function setHand(float Hand)
{
	if( bIsMySecondWeapon )
	{
		if (Hand==1)
		{
			Super(Weapon).setHand(-1);
			Mesh = mesh'AutoMagR';
		}
		else if (Hand==0 || Hand==-1)
		{
			Mesh = mesh'AutoMagL';
			Super(Weapon).setHand(1);
		}
		else Super(Weapon).setHand(Hand);
	}
	else
	{
		if( Hand==-1 ) Mesh = mesh'AutoMagR';
		else Mesh = mesh'AutoMagL';
		if( mySecondWeapon!=None )
			mySecondWeapon.setHand(Hand);
		Super(Weapon).setHand(Hand);
	}
}
function PlayFiring()
{
	if( !bIsMySecondWeapon )
	{
		if( ClipC>0 )
			ClipC--;
		Owner.PlaySound(FireS, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	}
	else
	{
		if( AMM(OwnerGun).ClipC>0 )
			AMM(OwnerGun).ClipC--;
		Owner.PlaySound(AMM(OwnerGun).FireS, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	}
}
function bool HandlePickupQuery( inventory Item )
{
	local int i;
	
	if( Item.Class!=Class ) Return Super.HandlePickupQuery(Item);
	if ( MySecondWeapon==None )
		return Super.HandlePickupQuery(Item);
	else
	{
		PickupMessage="You got some ammo";
		for (i = 0; i< 30; i++)
		{
			if( AmmoTypes[i].AmmoAmount<(AmmoTypes[i].MaxAmmo-Default.AmmoTypes[i].AmmoAmount) )
				AmmoTypes[i].AmmoAmount+=Default.AmmoTypes[i].AmmoAmount;
			else AmmoTypes[i].AmmoAmount=AmmoTypes[i].MaxAmmo;
			AmmoTypes[i].AmmoC = AmmoTypes[i].AmmoAmount;
		}
		ChangeAmmo(false);
		Return Super.HandlePickupQuery(Item);
	}
}
function Fire( float Value )
{
	local int i;
	if (AmmoType.UseAmmo(1))
	{
		if( !bIsMySecondWeapon )
			UseAmmo(1);
		else
			AMM(OwnerGun).UseAmmo(1);
		GotoState('NormalFire');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		PlayFiring();
		if ( !bRapidFire && (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		if( !bIsMySecondWeapon )
		{
			if( AmmoTypes[CurrentClip].bGotTraceFire )
				for (i = 0; i< AmmoTypes[CurrentClip].TraceShots; i++)
					TraceFire(AmmoTypes[CurrentClip].TraceMiss);
			if( AmmoTypes[CurrentClip].bGotProjFire )
				ProjectileFire(ToShoot,1000,true);
		}
		else
		{
			if( AMM(OwnerGun).GetBoolV(0) )
				for (i = 0; i< AMM(OwnerGun).GetShots(1); i++)
					TraceFire(AMM(OwnerGun).GetMiss(1));
			if( AMM(OwnerGun).GetBoolV(1) )
				ProjectileFire(AMM(OwnerGun).ToShoot,1000,true);
		}
		if ( Owner.bHidden )
			CheckVisibility();
		if( !bIsMySecondWeapon )
			ChangeAmmo(false);
	}
}
function bool GetBoolV( int i )
{
	if( i==0 )
		Return AmmoTypes[CurrentClip].bGotTraceFire;
	else if( i==1 ) Return AmmoTypes[CurrentClip].bGotProjFire;
	else Return AmmoTypes[CurrentClip].bASMDEffect;
}
function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X,Y,Z;
	local Pawn PawnOwner;
	local int i;
	local rotator DaRot;

	PawnOwner = Pawn(Owner);
	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = PawnOwner.AdjustAim(ProjSpeed, Start, AimError, True, bWarn);
	if( !bIsMySecondWeapon )
	{
		for (i = 0; i< AmmoTypes[CurrentClip].ProjShots; i++)
		{
			DaRot = AdjustedAim;
			DaRot.Pitch += FRand()*AmmoTypes[CurrentClip].ProjMiss-AmmoTypes[CurrentClip].ProjMiss/2;
			DaRot.Yaw += FRand()*AmmoTypes[CurrentClip].ProjMiss-AmmoTypes[CurrentClip].ProjMiss/2;
			DaRot.Roll += FRand()*AmmoTypes[CurrentClip].ProjMiss-AmmoTypes[CurrentClip].ProjMiss/2;		
			Spawn(ProjClass,,, Start,DaRot);
		}
	}
	else
	{
		for (i = 0; i< AMM(OwnerGun).GetShots(0); i++)
		{
			DaRot = AdjustedAim;
			DaRot.Pitch += FRand()*AMM(OwnerGun).GetMiss(0)-AMM(OwnerGun).GetMiss(0)/2;
			DaRot.Yaw += FRand()*AMM(OwnerGun).GetMiss(0)-AMM(OwnerGun).GetMiss(0)/2;
			DaRot.Roll += FRand()*AMM(OwnerGun).GetMiss(0)-AMM(OwnerGun).GetMiss(0)/2;		
			Spawn(ProjClass,,, Start,DaRot);
		}
	}
}
function int GetShots( int i )
{
	if( i==0 )
		Return AmmoTypes[CurrentClip].ProjShots;
	else Return AmmoTypes[CurrentClip].TraceShots;
}
function float GetMiss( int i )
{
	if( i==0 )
		Return AmmoTypes[CurrentClip].ProjMiss;
	else Return AmmoTypes[CurrentClip].TraceMiss;
}
function AltFire( float Value )
{
	GoToState('ChangeClip');
}
function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	CheckAmmo();
	AmmoIcons[1] = Texture(DynamicLoadObject(AmmoTypes[0].AmmoIcon, class'Texture'));
	AmmAmount[1] = AmmoTypes[0].AmmoAmount;
	ChangeAmmo(false);
}
function CheckAmmo()
{
	local int i;
	
	if( bIsMySecondWeapon ) Return;
	if( !bAllredChecked )
	{
		bAllredChecked = True;
		for (i = 0; i< 30; i++)
			if( AmmoTypes[i].AmmoIcon!="" )
				AmmoTypes[i].AmmoC = AmmoTypes[i].AmmoAmount;
	}
	else
		for (i = 0; i< 30; i++)
			if( AmmoTypes[i].AmmoIcon!="" )
				AmmoTypes[i].AmmoAmount = AmmoTypes[i].AmmoC;
}
function string ChangeAmmo( bool bCrap )
{
	local int i;
	local bool bFound;
	
	for (i = 0; i< ArrayCount(AmmoTypes); i++)
		if( AmmoTypes[i].AmmoAmount>0 )
			bFound=true;
	AmmoTypes[CurrentClip].ClipCount = ClipC;
	if( !bFound )
		Return "No ammo";
	if( bCrap )
	{
		CurrentClip++;
		if( CurrentClip>=30 || AmmoTypes[CurrentClip].AmmoIcon=="" )
			CurrentClip=0;
		while( AmmoTypes[CurrentClip].AmmoAmount<=0 )
		{
			CurrentClip++;
			if( CurrentClip>=30 || AmmoTypes[CurrentClip].AmmoIcon=="" )
				CurrentClip=0;
		}
	}
	if( CurrentClip==0 )
	{
		for (i = 0; i< ArrayCount(AmmoTypes); i++)
			if( AmmoTypes[i].AmmoIcon=="" )
				Break;
		if( i>0 )
		{
			AmmoIcons[0] = Texture(DynamicLoadObject(AmmoTypes[i-1].AmmoIcon, class'Texture'));
			AmmAmount[0] = AmmoTypes[i-1].AmmoAmount;
		}
	}
	else
	{
		AmmoIcons[0] = Texture(DynamicLoadObject(AmmoTypes[CurrentClip-1].AmmoIcon, class'Texture'));
		AmmAmount[0] = AmmoTypes[CurrentClip-1].AmmoAmount;
	}
	AmmoIcons[1] = Texture(DynamicLoadObject(AmmoTypes[CurrentClip].AmmoIcon, class'Texture'));
	AmmAmount[1] = AmmoTypes[CurrentClip].AmmoAmount;
	MaxAmm = AmmoTypes[CurrentClip].MaxAmmo;
	if( CurrentClip>=29 || AmmoTypes[CurrentClip+1].AmmoIcon=="" )
	{
		AmmoIcons[2] = Texture(DynamicLoadObject(AmmoTypes[0].AmmoIcon, class'Texture'));
		AmmAmount[2] = AmmoTypes[0].AmmoAmount;
		AmmoIcons[3] = Texture(DynamicLoadObject(AmmoTypes[1].AmmoIcon, class'Texture'));
		AmmAmount[3] = AmmoTypes[1].AmmoAmount;
	}
	else if( CurrentClip>=28 || AmmoTypes[CurrentClip+2].AmmoIcon=="" )
	{
		AmmoIcons[2] = Texture(DynamicLoadObject(AmmoTypes[CurrentClip+1].AmmoIcon, class'Texture'));
		AmmAmount[2] = AmmoTypes[CurrentClip+1].AmmoAmount;
		AmmoIcons[3] = Texture(DynamicLoadObject(AmmoTypes[0].AmmoIcon, class'Texture'));
		AmmAmount[3] = AmmoTypes[0].AmmoAmount;
	}
	else
	{
		AmmoIcons[2] = Texture(DynamicLoadObject(AmmoTypes[CurrentClip+1].AmmoIcon, class'Texture'));
		AmmAmount[2] = AmmoTypes[CurrentClip+1].AmmoAmount;
		AmmoIcons[3] = Texture(DynamicLoadObject(AmmoTypes[CurrentClip+2].AmmoIcon, class'Texture'));
		AmmAmount[3] = AmmoTypes[CurrentClip+2].AmmoAmount;
	}
	AmmoType.AmmoAmount = AmmoTypes[CurrentClip].AmmoAmount;
	AmmoType.MaxAmmo = AmmoTypes[CurrentClip].MaxAmmo;
	AmmoType.Icon = Texture(DynamicLoadObject(AmmoTypes[CurrentClip].AmmoIcon, class'Texture'));
	if( AmmoTypes[CurrentClip].ShootSound!="" )
		FireS = Sound(DynamicLoadObject(AmmoTypes[CurrentClip].ShootSound, class'Sound'));
	else FireS = None;
	if( AmmoTypes[CurrentClip].ProjClass!="" )
		ToShoot = class<Projectile>(DynamicLoadObject(AmmoTypes[CurrentClip].ProjClass, class'Class'));
	else ToShoot = None;
	if( AmmoTypes[CurrentClip].HitWallExp!="" )
		ExpEf = class<Effects>(DynamicLoadObject(AmmoTypes[CurrentClip].HitWallExp, class'Class'));
	else ExpEf = None;
	if( AmmoTypes[CurrentClip].TraceRingExp!="" )
		RE = class<RingExplosion4>(DynamicLoadObject(AmmoTypes[CurrentClip].TraceRingExp, class'Class'));
	else RE = None;
	ClipC = AmmoTypes[CurrentClip].ClipCount;
	AnimSp = AmmoTypes[CurrentClip].ReFireRate;
	Return AmmoTypes[CurrentClip].SelectMsg;
}
function UseAmmo( int i )
{
	AmmoTypes[CurrentClip].AmmoAmount-=i;
	AmmAmount[1]-=i;
	AmmoTypes[CurrentClip].AmmoC=AmmoTypes[CurrentClip].AmmoAmount;
}

defaultproperties
{
     AmmoTypes(0)=(AmmoAmount=25,MaxAmmo=100,ProjShots=1,ClipCount=5,AmmoIcon="UnrealShare.Icons.I_RocketAmmo",SelectMsg="Selected RocketShellShots.",ProjClass="UnrealShare.Rocket",ShootSound="UnrealShare.General.GlassTink2",bGotProjFire=True,ProjMiss=150.000000,RefireRate=0.900000)
     AmmoTypes(1)=(AmmoAmount=60,MaxAmmo=200,TraceShots=1,hitdamage=15,ClipCount=20,AmmoIcon="UnrealShare.Icons.I_ShellAmmo",SelectMsg="Selected PowerShell Shots!",HitWallExp="UnrealI.LightWallHitEffect",ShootSound="UnrealShare.AutoMag.shot",bGotTraceFire=True,TraceMiss=0.300000,RefireRate=0.400000)
     AmmoTypes(2)=(AmmoAmount=10,MaxAmmo=100,TraceShots=1,hitdamage=25,ClipCount=10,AmmoIcon="UnrealShare.Icons.I_ASMD",SelectMsg="Selected ASMD shots.",TraceRingExp="UnrealI.RingExplosion4",HitWallExp="UnrealShare.RingExplosion",ShootSound="UnrealShare.ASMD.TazerFire",bGotTraceFire=True,bASMDEffect=True,TraceMiss=0.200000,RefireRate=0.600000)
     AmmoTypes(3)=(AmmoAmount=20,MaxAmmo=50,ProjShots=2,ClipCount=10,AmmoIcon="UnrealShare.Icons.I_ASMD",SelectMsg="Tazer shots Selected.",ProjClass="UnrealI.TazerProj",bGotProjFire=True,ProjMiss=500.000000,RefireRate=1.000000)
     AmmoTypes(4)=(AmmoAmount=10,MaxAmmo=50,ProjShots=10,ClipCount=3,AmmoIcon="UnrealShare.Effects.Arc2",SelectMsg="Chunked chunks selected.",ProjClass="UnrealI.Chunk1",ShootSound="UnrealShare.flak.shot1",bGotProjFire=True,ProjMiss=500.000000,RefireRate=1.400000)
     AmmoTypes(5)=(AmmoAmount=30,MaxAmmo=100,ProjShots=1,ClipCount=20,AmmoIcon="UnrealShare.Icons.I_Dispersion",SelectMsg="Dispersion ammo selected.",ProjClass="UnrealShare.DAmmo3",ShootSound="UnrealShare.Dispersion.DispShot",bGotProjFire=True,ProjMiss=600.000000,RefireRate=0.300000)
     bDualWeaponed=True
     SecondWeaponPickup="You got another Mag!"
     AmmoName=Class'Pack6.AMMClip'
     PickupAmmoCount=20
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(Y=-10.000000,Z=-4.000000)
     shakemag=200.000000
     shakevert=4.000000
     FireSound=Sound'UnrealShare.AutoMag.shot'
     AltFireSound=Sound'UnrealShare.AutoMag.shot'
     CockingSound=Sound'UnrealShare.AutoMag.Cocking'
     SelectSound=Sound'UnrealShare.AutoMag.Cocking'
     Misc1Sound=Sound'UnrealShare.flak.Click'
     Misc2Sound=Sound'UnrealShare.AutoMag.Reload'
     InventoryGroup=2
     PickupMessage="You got a Akimbo MultiMag"
     ItemName="Akimbo MultiMag"
     PlayerViewOffset=(X=4.800000,Y=-1.700000,Z=-2.700000)
     PlayerViewMesh=LodMesh'UnrealShare.AutoMagL'
     PickupViewMesh=LodMesh'UnrealShare.AutoMagPickup'
     ThirdPersonMesh=LodMesh'UnrealShare.auto3rd'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Texture=None
     Mesh=LodMesh'UnrealShare.AutoMagPickup'
     bNoSmooth=False
     CollisionRadius=25.000000
     CollisionHeight=10.000000
     Mass=10.000000
}
