//=============================================================================
// ActorSpawner.
//=============================================================================
class ActorSpawner expands Pickup;

#exec TEXTURE IMPORT NAME=I_VoiceBox FILE=TEXTURES\HUD\i_voice.PCX GROUP="Icons" MIPS=OFF

#exec AUDIO IMPORT FILE="Sounds\Pickups\VOICEB1.WAV" NAME="VoiceSnd" GROUP="Pickups"
#exec AUDIO IMPORT FILE="Sounds\automag\shot.WAV" NAME="shot" GROUP="AutoMag"
#exec AUDIO IMPORT FILE="Sounds\stinger\sshot10d.WAV" NAME="StingerFire" GROUP="Stinger"
#exec AUDIO IMPORT FILE="Sounds\flak\shot1.WAV" NAME="shot1" GROUP="flak"
#exec AUDIO IMPORT FILE="Sounds\flak\Explode1.WAV" NAME="Explode1" GROUP="flak"
#exec AUDIO IMPORT FILE="Sounds\flak\expl2.WAV" NAME="expl2" GROUP="flak"

#exec MESH IMPORT MESH=VoiceBoxMesh ANIVFILE=MODELS\voice_a.3D DATAFILE=MODELS\voice_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=VoiceBoxMesh X=0 Y=0 Z=-15 YAW=64
#exec MESH SEQUENCE MESH=VoiceBoxMesh SEQ=All   STARTFRAME=0  NUMFRAMES=10
#exec MESH SEQUENCE MESH=VoiceBoxMesh SEQ=Pulse STARTFRAME=0  NUMFRAMES=10
#exec TEXTURE IMPORT NAME=Ainv1 FILE=MODELS\inv.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=VoiceBoxMesh X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=VoiceBoxMesh NUM=1 TEXTURE=Ainv1

var vector X,Y,Z;
var() sound WarningSound;
var() class<Actor> ClassToSpawn;
var() bool bSpawning;
var() int MaxActors,SpawnsToSpawn;
var() float TimeBetweenSpawns;
var float DisplayScale;
var int Spawned;

replication
{
    // Things the server should send to the client.
    reliable if( Role<ROLE_Authority )
        MakeSpawner,KillCloseS;
}
function PreBeginPlay()
{
    Super.PreBeginPlay();
    DisplayScale = PickupViewScale;
}
state Activated  // Delete from inventory and toss in front of player.
{
    function HitWall (vector HitNormal, actor Wall)
    {
        Velocity = 0.5*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
    //    PlaySound(Sound 'GrenadeFloor', SLOT_Misc, VSize(Velocity)/1300 );
        If (VSize(Velocity) < 20)
        {
            bBounce = False;
            bStasis = false;
            SetPhysics(PHYS_None);
            DrawScale = DisplayScale;
            GoToState('Playing');
        }
    }
Begin:
    GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
    DrawType = DT_Mesh;
    DrawScale = DisplayScale;
    SetLocation(Pawn(Owner).Location+X*10+Y*8-Z*20);
    AmbientSound=WarningSound;
    Disable('Touch');
    bBounce=True;
    Velocity = Owner.Velocity + Vector(Owner.Rotation) * 150.0;
    Velocity.z += 240;         
    DesiredRotation = RotRand();
    RotationRate.Yaw = 20000*FRand() - 10000;
    RespawnTime = 0.0; //don't respawn
    SetPhysics(PHYS_Falling);
    RemoteRole = ROLE_DumbProxy;
    BecomePickup();
    DrawScale = DisplayScale;
    bCollideWorld = true;
    Owner.PlaySound(ActivateSound);
    bStasis=false;
}
state Playing
{
    function Touch(Actor Other)
    {
        Super.Touch(Other);
    }
    function Timer()
    {
        local Actor A;
        local int i;
        local ParticleBurst PB;
        
        ForEach AllActors(class'Actor',A,Name)
        {
            if( A.IsA('Inventory') && (A.IsInState('Pickup') || A.IsInState('Sleeping')) )
                i++;
            else if( !A.IsA('Inventory') ) i++;
        }
        if( i<MaxActors )
        {
            A = Spawn(ClassToSpawn,,Name);
            if( A!=None )
            {
                spawn(class'ParticleBurst');
                if( SpawnsToSpawn>0 )
                {
                    Spawned++;
                    if( Spawned>=SpawnsToSpawn )
                    {
                        for (i=0 ; i<3 ; i++)
                        {
                            PB = spawn(class'ParticleBurst',,,Location+VRand()*5,RotRand(True));
                            PB.DrawScale=FRand()*2+0.5;
                        }
                        Destroy();
                    }
                }
            }
        }
    }
    function BeginState()
    {
        local ParticleBurst PB;
        local int i;
        
        bStasis = false;
        AmbientSound=None;
        DrawScale = DisplayScale;
        SetTimer(TimeBetweenSpawns,True);
        if( !bSpawning )
        {
            for (i=0 ; i<3 ; i++)
            {
                PB = spawn(class'ParticleBurst',,,Location+VRand()*5,RotRand(True));
                PB.DrawScale=FRand()*2+0.5;
            }
        }
        if( ClassToSpawn==None ) Destroy();
    }
}
auto state Pickup
{    
    function BeginState()
    {
        Super.BeginState();
        if( bSpawning ) GoToState('Playing');
    }
    function Touch( actor Other )
    {
        if( Other.IsA('PlayerPawn') && !PlayerPawn(Other).bAdmin )
            PlayerPawn(Other).ClientMessage("This is a thing for ADMINS, dude");
        else Super.Touch(Other);
    }
}
function Activate()
{
    if( bActivatable )
    {
        Pawn(Owner).ClientMessage("TYPE: MakeSpawner <int-MaxActors><int-TimeBetweenSpawns><int-Spawns before vanish><string-ClassToSpawn>");
        Pawn(Owner).ClientMessage("TYPE: KillCloseS to kill close spawners");
    }
}
exec function MakeSpawner( int Nr1, int Nr2, int Nr3, string Classs )
{
    local ActorSpawner AS;
    local class<Actor> Ac;
    
    AS = Spawn(class'ActorSpawner',Owner);
    AS.MaxActors = Nr1;
    AS.TimeBetweenSpawns = Nr2;
    if( InStr(Classs, ".")<0 )
        Classs = "UnrealI."$Classs;
    Ac = class<Actor>(DynamicLoadObject(Classs, class'Class'));
    AS.ClassToSpawn = Ac;
    AS.SetCollisionSize(Ac.Default.CollisionRadius,Ac.Default.CollisionHeight);
    AS.DisplayScale = Ac.Default.CollisionHeight/48;
    AS.SpawnsToSpawn = Nr3;
    AS.GoToState('Activated');
}
exec function KillCloseS()
{
    local ActorSpawner AC;
    
    ForEach RadiusActors(class'ActorSpawner',AC,300,Owner.Location)
        if( AC.IsInState('Playing') && AC.Class==Class )
            AC.Destroy();
}
function PickupFunction(Pawn Other)
{
    local inventory inv2;
    if (Other.Inventory==None) Return;
    
    for( Inv2=Other.Inventory; Inv2!=None; Inv2=Inv2.Inventory ) 
        if (ActorSpawner(Inv2)!=None && Inv2.class!=class) Inv2.Destroy();
}

defaultproperties
{
     WarningSound=Sound'Pack6.All.Klaxon'
     ClassToSpawn=Class'UnrealI.Krall'
     MaxActors=10
     TimeBetweenSpawns=5.000000
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You found the ActorSpawner."
     ItemName="ActorSpawner"
     PickupViewMesh=LodMesh'UnrealShare.FlameM'
     Icon=Texture'UnrealShare.Icons.BlueSkull'
     DrawType=DT_Sprite
     Texture=Texture'UnrealShare.Icons.BlueSkull'
     CollisionRadius=25.000000
     CollisionHeight=25.000000
}
