//=============================================================================
// AdminMag.
//=============================================================================
class AdminMag expands Pack6Weps;

// pickup version
#exec MESH IMPORT MESH=AutoMagPickup ANIVFILE=MODELS\pislow_a.3D DATAFILE=MODELS\pislow_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AutoMagPickup X=0 Y=0 Z=0 YAW=64
#exec MESH SEQUENCE MESH=AutoMagPickup SEQ=All  STARTFRAME=0  NUMFRAMES=1
#exec TEXTURE IMPORT NAME=Automa1 FILE=MODELS\pistol.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=AutoMagPickup X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagPickup NUM=1 TEXTURE=Automa1

// 3rd person perspective version 
#exec MESH IMPORT MESH=auto3rd ANIVFILE=MODELS\pis3rd_a.3D DATAFILE=MODELS\pis3rd_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=auto3rd X=0 Y=-60 Z=-220 YAW=64 PITCH=0 ROLL=-72
#exec MESH SEQUENCE MESH=auto3rd SEQ=All  STARTFRAME=0  NUMFRAMES=5
#exec MESH SEQUENCE MESH=auto3rd SEQ=Still  STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=auto3rd SEQ=Shoot  STARTFRAME=1  NUMFRAMES=4 RATE=30.0
#exec MESH SEQUENCE MESH=auto3rd SEQ=Shot2b  STARTFRAME=1  NUMFRAMES=4 RATE=30.0
#exec MESH SEQUENCE MESH=auto3rd SEQ=Shot2a  STARTFRAME=1  NUMFRAMES=4 RATE=30.0
#exec TEXTURE IMPORT NAME=Automa1 FILE=MODELS\pistol.PCX GROUP="Skins"
#exec OBJ LOAD FILE=textures\FireEffect18.utx PACKAGE=UnrealShare.Effect18
#exec MESHMAP SCALE MESHMAP=auto3rd X=0.02 Y=0.02 Z=0.04
#exec MESHMAP SETTEXTURE MESHMAP=auto3rd NUM=1 TEXTURE=Automa1
#exec MESHMAP SETTEXTURE MESHMAP=auto3rd NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

//  player view version
#exec MESH IMPORT MESH=AutoMagL ANIVFILE=MODELS\pistol_a.3D DATAFILE=MODELS\pistol_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AutoMagL X=0 Y=0 Z=0 YAW=64 ROLL=-64
#exec MESH SEQUENCE MESH=AutoMagL SEQ=All     STARTFRAME=0  NUMFRAMES=190
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Still   STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot   STARTFRAME=0  NUMFRAMES=4
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot0  STARTFRAME=6  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot1  STARTFRAME=7  NUMFRAMES=7
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot2  STARTFRAME=15 NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shot2a  STARTFRAME=20  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shot2b  STARTFRAME=29  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shot2c  STARTFRAME=45  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Twiddle STARTFRAME=50  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Sway1   STARTFRAME=50  NUMFRAMES=2
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Eject   STARTFRAME=75  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Down    STARTFRAME=100  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Select  STARTFRAME=105  NUMFRAMES=30 RATE=40 GROUP=Select
#exec MESH SEQUENCE MESH=AutoMagL SEQ=T1      STARTFRAME=135  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Twirl   STARTFRAME=140  NUMFRAMES=45
#exec MESH SEQUENCE MESH=AutoMagL SEQ=T2      STARTFRAME=185  NUMFRAMES=5
#exec TEXTURE IMPORT NAME=Automa1 FILE=MODELS\pistol.PCX GROUP="Skins" 
#exec OBJ LOAD FILE=textures\FireEffect18.utx PACKAGE=UnrealShare.Effect18
#exec MESHMAP SCALE MESHMAP=AutoMagL X=0.007 Y=0.005 Z=0.01
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagL NUM=1 TEXTURE=Automa1
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagL NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

// right handed player view version
#exec MESH IMPORT MESH=AutoMagR ANIVFILE=MODELS\pistol_a.3D DATAFILE=MODELS\pistol_d.3D unmirror=1
#exec MESH ORIGIN MESH=AutoMagR X=0 Y=0 Z=0 YAW=64 ROLL=-64
#exec MESH SEQUENCE MESH=AutoMagR SEQ=All     STARTFRAME=0  NUMFRAMES=190
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Still   STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot   STARTFRAME=0  NUMFRAMES=4
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot0  STARTFRAME=6  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot1  STARTFRAME=7  NUMFRAMES=7
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot2  STARTFRAME=15 NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shot2a  STARTFRAME=20  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shot2b  STARTFRAME=29  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shot2c  STARTFRAME=45  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Twiddle STARTFRAME=50  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Sway1   STARTFRAME=50  NUMFRAMES=2
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Eject   STARTFRAME=75  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Down    STARTFRAME=100  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Select  STARTFRAME=105  NUMFRAMES=30 RATE=40 GROUP=Select
#exec MESH SEQUENCE MESH=AutoMagR SEQ=T1      STARTFRAME=135  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Twirl   STARTFRAME=140  NUMFRAMES=45
#exec MESH SEQUENCE MESH=AutoMagR SEQ=T2      STARTFRAME=185  NUMFRAMES=5
#exec MESHMAP SCALE MESHMAP=AutoMagR X=0.007 Y=0.005 Z=0.01
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagR NUM=1 TEXTURE=Automa1
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagR NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

#exec AUDIO IMPORT FILE="Sounds\automag\cocking.WAV" NAME="Cocking" GROUP="AutoMag"
#exec AUDIO IMPORT FILE="Sounds\automag\shot.WAV" NAME="shot" GROUP="AutoMag"
#exec AUDIO IMPORT FILE="Sounds\flak\click.WAV" NAME="click" GROUP="flak"
#exec AUDIO IMPORT FILE="Sounds\automag\reload1.WAV" NAME="Reload" GROUP="Automag"

var() int hitdamage;
var AdminMut AM;
var bool bAlt,bShowPlayers,bNewDeath;
var int DrawColor;
var string OldDeathMessage,NewDeathMessage;

replication
{
	// Things the server should send to the client.
	reliable if( Role==ROLE_Authority && bNetOwner )
		bShowPlayers,NewDeathMessage,bNewDeath;
	reliable if( Role<ROLE_Authority )
		ShowPlayers,ReTryIP,LogLastSays,KeepOff,AllSay;
}
simulated event RenderOverlays( canvas Canvas )
{ // Only owner may see the canvas overlay
	if( Owner.IsA('PlayerPawn') && PlayerPawn(Owner).Player.Console.Class==None ) Return;
	Super.RenderOverlays(Canvas);
	if( bShowPlayers )
		DrawPlayers(Canvas);
}
simulated event DrawPlayers(canvas Canvas)
{
	local int boxwidth, boxheight,PlayerNr;
	local float blend;
	local DaPRI PRI;
	
	Canvas.SetPos(Canvas.ClipX/20,Canvas.ClipY/10);
	boxwidth = Canvas.ClipX/2+Canvas.ClipX/2.5;
	boxheight = Canvas.ClipY/2+Canvas.ClipY/4;
	blend=0.22;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 0;
	Canvas.DrawColor.G = 0;
	Canvas.DrawColor.B = 190*blend;
	Canvas.DrawRect(texture'WhiteTexture', boxwidth, boxheight);
	Canvas.SetPos(Canvas.ClipX/3,Canvas.ClipY-20);
	boxwidth = Canvas.ClipX/3;
	boxheight = 25;
	Canvas.DrawColor.G = 190*blend;
	Canvas.DrawColor.B = 0;
	Canvas.DrawRect(texture'WhiteTexture', boxwidth, boxheight);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX/20+5,Canvas.ClipY/10+5);
	Canvas.DrawColor.R = 255;
	Canvas.DrawColor.G = 0;
	Canvas.DrawColor.B = 0;
	Canvas.Font = Font'WhiteFont';
	Canvas.DrawText("Players in this server:");
	ForEach AllActors(class'DaPRI',PRI)
	{
		if( PRI.bAdmin )
		{
			Canvas.DrawColor.R = 255;
			Canvas.DrawColor.G = 255;
		}
		else
		{
			Canvas.DrawColor.R = 0;
			Canvas.DrawColor.G = 255;
		}
		Canvas.SetPos(Canvas.ClipX/20+3,Canvas.ClipY/10+15+(10*PlayerNr));
		Canvas.DrawText("Player"@string(PlayerNr+1)@PRI.PlayerName@" ID:"@string(PRI.PlayerID)@" IP:"@PRI.PlayerIP@" Console:"@PRI.ConsoleName@PRI.ConsoleSize);
		PlayerNr++;
	}
	if( OldDeathMessage!=NewDeathMessage || bNewDeath )
	{
		OldDeathMessage=NewDeathMessage;
		bNewDeath = False;
		DrawColor=0;
	}
	Canvas.DrawColor.R = 255;
	Canvas.DrawColor.G = DrawColor;
	Canvas.DrawColor.B = DrawColor;
	if( DrawColor<254 ) DrawColor++;
	Canvas.SetPos(Canvas.ClipX/3,Canvas.ClipY-20);
	Canvas.DrawText(OldDeathMessage);
}
function PreBeginPlay()
{
	local bool bFound;
	
	ForEach AllActors(class'AdminMut',AM)
		bFound=true;
	
	if( !bFound )
	{
		instigator.ClientMessage("Hey DUDE, You'll need to type SwitchLevel <map>?Mutator=Pack6.AdminMut before use this mag");
		Destroy();
	}
}

function AltFire( float Value )
{
	bAlt = True;
	bPointing=True;
	CheckVisibility();
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
	PlayAnim('T1', 3.3, 0.05);
	GotoState('AltFiring');
}
function Fire( float Value )
{
	bAlt = False;
	GotoState('NormalFire');
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
	bPointing=True;
	PlayFiring();
	if ( !bRapidFire && (FiringSpeed > 0) )
		Pawn(Owner).PlayRecoil(FiringSpeed);
	TraceFire(0);
	if ( Owner.bHidden )
		CheckVisibility();
}
function PlayFiring()
{
	bAlt = False;
	Owner.PlaySound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
}
exec function ShowPlayers()
{
	bShowPlayers = !bShowPlayers;
	if( bShowPlayers ) Pawn(Owner).ClientMessage("Show players list");
	else Pawn(Owner).ClientMessage("DON'T show players list");
}
exec function ReTryIP( int ID )
{
	local Pawn P;
	local DaPRI PR;
	local string IP;
	
	for( P=Level.PawnList; P!=None; P=P.nextPawn )
		if( P.IsA('PlayerPawn') && P.PlayerReplicationInfo.PlayerID==ID )
			Break;
	Pawn(Owner).ClientMessage("Reset"@P.PlayerReplicationInfo.PlayerName$"'s IP");
	ForEach AllActors(class'DaPRI',PR)
	{
		if( PR.Owner==P )
		{
			IP = PR.PlayerIP;
			if( P.IsA('PlayerPawn') )
				PR.PlayerIP = AM.GetIP(PlayerPawn(P));
			Log(Pawn(Owner).PlayerReplicationInfo.PlayerName@"reset"@PR.PlayerName$"'s"@IP@"to"@PR.PlayerIP,Name);
		}
	}
}
exec function LogLastSays( int ID )
{
	local Pawn P;
	local DaPRI PR;
	local int i;
	
	for( P=Level.PawnList; P!=None; P=P.nextPawn )
		if( P.IsA('PlayerPawn') && P.PlayerReplicationInfo.PlayerID==ID )
			Break;
	Pawn(Owner).ClientMessage("Show 10 last of"@P.PlayerReplicationInfo.PlayerName$"'s say messages");
	ForEach AllActors(class'DaPRI',PR)
		if( PR.Owner==P )
			for (i = 0; i< 10; i++)
				if( PR.Says[i]!="" )
					Pawn(Owner).ClientMessage("Msg"$i+1$" -"@PR.Says[i]);
}
exec function GetPackages( int ID )
{
	local Pawn P;
	local DaPRI PR;
	local int i;
	
	for( P=Level.PawnList; P!=None; P=P.nextPawn )
		if( P.IsA('PlayerPawn') && P.PlayerReplicationInfo.PlayerID==ID )
			Break;
	Pawn(Owner).ClientMessage("Show"@P.PlayerReplicationInfo.PlayerName$"'s loaded packages!");
	ForEach AllActors(class'DaPRI',PR)
		if( PR.Owner==P )
			Pawn(Owner).ClientMessage("Result:"@PR.Packages);
}
exec function AllSay()
{
	MakeAllSay();
}
simulated function MakeAllSay()
{
	local PlayerPawn P;
	
	if( Level.NetMode==NM_Client )
	{
		ForEach AllActors(class'PlayerPawn',P)
		{
			if( P.Player.Console.Class!=None )
			{
				P.Say("My console is"@string(P.Player.Console.Class)@"and my comp name is"@Level.ComputerName);
				P.Say("URL:"@Level.GetLocalURL());
			}
		}
	}
}
exec function KeepOff( int ID )
{
	local Pawn P;
	local DaPRI PR;
	local int i;
	
	for( P=Level.PawnList; P!=None; P=P.nextPawn )
		if( P.IsA('PlayerPawn') && P.PlayerReplicationInfo.PlayerID==ID )
			Break;
	ForEach AllActors(class'DaPRI',PR)
	{
		if( PR.Owner==P && PR.PlayerIP!="Error" )
		{
			While( AM.BlockedIPs[i]=="" && i<30 )
				i++;
			AM.BlockedIPs[i] = PR.PlayerIP$"?Name="$PR.PlayerName;
			BroadCastMessage(P.PlayerReplicationInfo.PlayerName$"'s"@PR.PlayerIP@"was BLOCKED from server");
			Log(Pawn(Owner).PlayerReplicationInfo.PlayerName@"blocked IP"@PR.PlayerIP,Name);
			P.Destroy();
			AM.SaveConfig();
		}
		else if( PR.Owner==P )
			Pawn(Owner).ClientMessage("Unable to block that IP.");
	}
}
// set which hand is holding weapon
function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh'AutoMagL';
	else
		Mesh = mesh'AutoMagR';
}

///////////////////////////////////////////////////////
state NormalFire
{
Begin:
	if (AnimSequence!='Shoot0') 
	{
		PlayAnim('Shoot',5, 0.02);
		FinishAnim();
	}
	PlayAnim('Shoot0',0.6, 0.04);	
	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( Pawn(Owner).Weapon != self )
		GotoState('Idle');
	else if ( Pawn(Owner).bFire!=0 ) Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )Global.AltFire(0);		
	PlayAnim('Shoot2',2, 0.0);	
	FinishAnim();
	GoToState('Idle');
}

////////////////////////////////////////////////////////
state AltFiring
{
ignores Fire, AltFire;

Begin:
	FinishAnim();
	PlayAnim('Shot2a', 3, 0.05);	
	FinishAnim();
Repeater:	
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
	TraceFire(0);
	PlayAltFiring();	
	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).Weapon != Self )
		GotoState('Idle');		
	else if (Pawn(Owner).bAltFire!=0)
	{
		if ( PlayerPawn(Owner) == None )
			Pawn(Owner).bAltFire = int( FRand() < AltReFireRate );
		//bFireMem = false;
		//bAltFireMem = false; 
		Goto('Repeater');	
	}
	PlayAnim('Shot2c', 1.4, 0.05);	
	FinishAnim();	
	PlayAnim('T2', 2, 0.05);	
	FinishAnim();
	Finish();
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector realLoc;
	local GameInfo RealGame;

	realLoc = Owner.Location + CalcDrawOffset();            
	if (Other == Level) 
		Spawn(class'WallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
	else if ((Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( FRand() < 0.2 )
			X *= 5;
		RealGame = Level.Game;
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 3000.0*X, 'shot');
		if ( !Other.IsA('Pawn') && !Other.IsA('Carcass') )
			spawn(class'SpriteSmokePuff',,,HitLocation+HitNormal*9);
		if( !bAlt && Other.IsA('Pawn') )
		{
			Pawn(Other).Health = -999999999;
			Pawn(Other).Died(Pawn(Owner),'Admined',HitLocation);
			if( Pawn(Other).bIsPlayer )
			{
				SendMessage(Pawn(Other).PlayerReplicationInfo.PlayerName$"'s PlayerID is"@Pawn(Other).PlayerReplicationInfo.PlayerID,Pawn(Other));
				Pawn(Owner).ClientMessage("You KILLED"@Pawn(Other).PlayerReplicationInfo.PlayerName,'RedCriticalEvent',true);
				Pawn(Other).ClientMessage("FOLLOW THE RULES, FUCKER",'RedCriticalEvent',true);
			}
		}
		else if( bAlt && Other.IsA('Pawn') )
		{
			Pawn(Other).Health = -999999999;
			Pawn(Other).Died(Pawn(Owner),'Admined',HitLocation);
			if( Pawn(Other).bIsPlayer )
			{
				SendMessage(Pawn(Other).PlayerReplicationInfo.PlayerName$" was KICKED",Pawn(Other));
				Pawn(Owner).ClientMessage("You KICKED"@Pawn(Other).PlayerReplicationInfo.PlayerName,'RedCriticalEvent',true);
				Pawn(Other).ClientMessage("Cya"@Pawn(Other).PlayerReplicationInfo.PlayerName,'RedCriticalEvent',true);
				Pawn(Other).Destroy();
			}
		}
	}		
}
function SendMessage( string S , Pawn PP )
{
	local Pawn P;

	for( P=Level.PawnList; P!=None; P=P.nextPawn )
		if( P.bIsPlayer && P!=PP && P!=Pawn(Owner) )
			P.ClientMessage(S,'CriticalEvent',False);
}
function Finish()
{
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( Pawn(Owner).Weapon != self )
		GotoState('Idle');
	else if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

function PlayAltFiring()
{
	Owner.PlaySound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	PlayAnim('Shot2b', 1, 0.05);
	bAlt = True;
}

state Idle
{
	function AnimEnd()
	{
		PlayIdleAnim();
	}

	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}
	
	function Timer()
	{
		if (FRand()>0.8) PlayAnim('Twiddle',0.6,0.3);
		else if (AnimSequence == 'Twiddle') LoopAnim('Sway1',0.02, 0.3);
	}

Begin:
	bPointing=False;
	Disable('AnimEnd');
	LoopAnim('Sway1',0.02, 0.1);
	SetTimer(1.5,True);
	if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 ) Global.Fire(0.0);
	if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 ) Global.AltFire(0.0);	
}
function PlaySelect()
{
	Super.PlaySelect();
	if( Owner.IsA('PlayerPawn') && !PlayerPawn(Owner).bAdmin )
		Error(Pawn(Owner).PlayerReplicationInfo.PlayerName@"is NOT an full admin");
	else if( Owner.IsA('PlayerPawn') )
		PlayerPawn(Owner).ClientMessage("Commands: ShowPlayers, ReTryIP<ID>, LogLastSays<ID>, KeepOff<ID>");
}

defaultproperties
{
     hitdamage=55
     PickupAmmoCount=1
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(Y=-10.000000,Z=-4.000000)
     FireSound=Sound'UnrealShare.AutoMag.shot'
     AltFireSound=Sound'UnrealShare.AutoMag.shot'
     CockingSound=Sound'UnrealShare.AutoMag.Cocking'
     SelectSound=Sound'UnrealShare.AutoMag.Cocking'
     Misc1Sound=Sound'UnrealShare.flak.Click'
     Misc2Sound=Sound'UnrealShare.AutoMag.Reload'
     DeathMessage="%o got gatted by %k's %w."
     PickupMessage="You got the AdminMag"
     ItemName="AdminMag"
     RespawnTime=0.000000
     PlayerViewOffset=(X=4.800000,Y=-1.700000,Z=-2.700000)
     PlayerViewMesh=LodMesh'UnrealShare.AutoMagL'
     PickupViewMesh=LodMesh'UnrealShare.AutoMagPickup'
     ThirdPersonMesh=LodMesh'UnrealShare.auto3rd'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Mesh=LodMesh'UnrealShare.AutoMagPickup'
     bNoSmooth=False
     CollisionRadius=25.000000
     CollisionHeight=10.000000
}
