//=============================================================================
// BigMomma.
//=============================================================================
class BigMomma expands Momma;

function SpawnBelch()
{
	local Momma G;
	local vector X,Y,Z, projStart;
	local actor P;
	 
	GetAxes(Rotation,X,Y,Z);
	projStart = Location + 0.5 * CollisionRadius * X - 0.3 * CollisionHeight * Z;
	if ( (numChildren > 10) || (FRand() > 0.8) )
	{
		P = spawn(RangedProjectile ,self,'',projStart,AdjustAim(ProjectileSpeed, projStart, 400, bLeadTarget, bWarnTarget));
		if ( P != None )
			P.DrawScale *= 2;
	}
	else
	{
		G = spawn(class 'Momma' ,,'',projStart + (0.6 * CollisionRadius + class'Momma'.Default.CollisionRadius) * X);
		if ( G != None )
		{
			G.ParentBag = self;
			G.Enemy = Enemy;
			G.OldEnemy = OldEnemy;
			G.Target = Target;
			numChildren++;
		}
	}	
}

defaultproperties
{
     PunchDamage=255
     PoundDamage=255
     FireEffectTexture=FireTexture'UnrealShare.Effect1.FireEffect1p'
     ProjectileSpeed=5000.000000
     Health=1700
     AttitudeToPlayer=ATTITUDE_Hate
     NameArticle=" the "
     DrawScale=3.000000
     CollisionRadius=160.000000
     CollisionHeight=108.000000
}
