//=============================================================================
// BigTrillionManta.
//=============================================================================
class BigTrillionManta expands TrillionManta;

var int NrChildren;

function PlayRangedAttack()
{
	if( NrChildren<20 )
		SpawnChild();
}
function SpawnChild()
{
	local TrillionManta TM;
	
	PlayAnim('ThreatSting');
	TM = Spawn(class'TrillionManta',,,Location + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
	if( TM!=None )
	{
		TM.Mom = Self;
		if( Enemy!=None )
			TM.SetEnemy(Enemy);
		NrChildren++;
	}
}
State IdleMoving
{
Begin:
	PlayRunning();
FindASpot:
	MoveVect = Location;
	MoveVect.X += Rand(1000)-500;
	MoveVect.Y += Rand(1000)-500;
	MoveVect.Z += Rand(1000)-500;
DoMove:
	PlayRunning();
	bCanJump=False;
	MoveTo(MoveVect,Groundspeed);
	Sleep(1);
	if( NrChildren<20 && FRand()<0.2 )
		SpawnChild();
	Sleep(1);
	if( NrChildren<20 && FRand()<0.2 )
		SpawnChild();
	Sleep(1);
	if( NrChildren<20 && FRand()<0.2 )
		SpawnChild();
	CheckEnemys();
	GoTo('FindASpot');
}
function CheckEnemys()
{
	CheckVisibleEnemys();
}
function bool SetEnemy(Pawn NewEnemy)
{
	local Pawn P;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
		if( TrillionManta(P)!=None && TrillionManta(P).Mom==Self )
			TrillionManta(P).SetEnemy(NewEnemy);
	Return Super.SetEnemy(NewEnemy);
}
event HearNoise( float Loudness, Actor NoiseMaker)
{
	if( NoiseMaker.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker));
}
event SeePlayer( actor Seen )
{
	if( Seen.IsA('Pawn') )
		SetEnemy(Pawn(Seen));
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum,
	 name damageType)
{
	if( instigatedBy!=None )
		SetEnemy(instigatedBy);
	Super.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
}
function Destroyed()
{
	local Pawn P;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
		if( TrillionManta(P)!=None && TrillionManta(P).Mom==Self )
			TrillionManta(P).Mom=None; // Tell children "im destroyed, forget about me :("
	Super.Destroyed();
}

defaultproperties
{
     FireEffectTexture=FireTexture'UnrealShare.SEffect1.Smoke1'
     bHasFireEffect=True
     bHasRangedAttack=True
     bMovingRangedAttack=True
     AirSpeed=220.000000
     AccelRate=100.000000
     Health=700
     Skin=Texture'UnrealShare.Skins.JManta2'
     DrawScale=2.000000
     SoundPitch=13
     CollisionRadius=54.000000
     CollisionHeight=24.000000
}
