//=============================================================================
// BlackForce.
//=============================================================================
class BlackForce expands HumanPawn;

var vector HideVect,OldV;
var Actor Node;
var int NumberT;

state RangedAttack
{
ignores SeePlayer, HearNoise, Bump;

	function BeginState()
	{
		Target = Enemy;
		Disable('AnimEnd');
		bReadyToAttack = false;
	}

Challenge:
	Disable('AnimEnd');
	Acceleration = vect(0,0,0); //stop
	DesiredRotation = Rotator(Enemy.Location - Location);
	PlayChallenge();
	FinishAnim();
	if ( bCrouching && !Region.Zone.bWaterZone )
		Sleep(0.8 + FRand());
	bCrouching = false;
	TweenToFighter(0.1);
	Goto('FaceTarget');

Begin:
	if ( Enemy == None )
		GotoState('Attacking');

	Acceleration = vect(0,0,0); //stop
	DesiredRotation = Rotator(Enemy.Location - Location);
	TweenToFighter(0.15);
	
FaceTarget:
	Disable('AnimEnd');
	if (NeedToTurn(Enemy.Location))
	{
		PlayTurning();
		TurnToward(Enemy);
		TweenToFighter(0.1);
	}
	FinishAnim();

ReadyToAttack:
	DesiredRotation = Rotator(Enemy.Location - Location);
	PlayRangedAttack();
	bFire = 1;
	Weapon.Fire(1);
	MayThrowGren();
	Enable('AnimEnd');
	if (Enemy == None )
		GotoState('Attacking');
	TurnToward(Enemy);
	Sleep(1);
	bFire = 0;
DoneFiring:
	Disable('AnimEnd');
	KeepAttacking();
	NumberT = 0;
RunToOtherSpot:
	bFiringPaused = false;
	bFire = 0;
	bAltFire = 0;
	HideVect = GetClosePoint();
MoveHiding:
	PlayRunning();
	if( !pointReachable(HideVect) )
	{
		Node = FindPathTo(HideVect);
		if( Node==None )
		{
			MoveTo(HideVect,GroundSpeed);
			GoTo 'Done';
		}
		else
		{
			MoveToward(Node,GroundSpeed);
			if( Node.Location==OldV )
			{
				Acceleration = vect(0,0,0); //stop
				PlayWaiting();
				Sleep(0.1);
			}
			OldV = Node.Location;
		}
	}
	else
	{
		MoveTo(HideVect,GroundSpeed);
Done:
		Acceleration = vect(0,0,0); //stop
		PlayWaiting();
		Sleep(0.2);
	}
	if( NumberT>=1 )
		GoToState('Attacking');
	NumberT++;
	GoTo 'RunToOtherSpot';
}
State IdleMoving
{
Begin:
	PlayRunning();
	HideVect = GetClosePoint();
MoveHiding:
	PlayRunning();
	CheckVisibleEnemys();
	if( !pointReachable(HideVect) )
	{
		Node = FindPathTo(HideVect);
		if( Node==None )
		{
			MoveTo(HideVect,GroundSpeed);
			GoTo 'Done';
		}
		else
		{
			MoveToward(Node,GroundSpeed);
			if( Node.Location==OldV )
			{
				Acceleration = vect(0,0,0); //stop
				PlayWaiting();
				Sleep(0.5);
			}
			OldV = Node.Location;
		}
	}
	else
	{
		MoveTo(HideVect,GroundSpeed);
Done:
		Acceleration = vect(0,0,0); //stop
		PlayWaiting();
		Sleep(1);
	}
	GoTo 'Begin';
}
state Guarding
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Wandering
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Waiting
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Roaming
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
function vector GetClosePoint()
{
	local NavigationPoint N;
	local float Distance;
	local int Numbers,i;

	For( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		Distance = VSize(N.Location-Location);
		if( Distance<1000 )
			Numbers++;
	}
	if( N==None || Numbers==0 ) Return Location+VRand()*2000;
	Numbers = Rand(Numbers);
	For( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		Distance = VSize(N.Location-Location);
		if( Distance<1000 )
		{
			if( i==Numbers )
				Return N.Location;
			i++;
		}
	}
	Return Location+VRand()*2000;
}
function int GetError()
{
	Return 0;
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

//FIXME - what if bReadyToAttack at start
TacticalTick:
	Sleep(0.02);	
Begin:
	TweenToRunning(0.15);
	Enable('AnimEnd');
	if (Physics == PHYS_Falling)
	{
		DesiredRotation = Rotator(Enemy.Location - Location);
		Focus = Enemy.Location;
		Destination = Enemy.Location;
		WaitForLanding();
	}
	PickDestination(false);

DoMove:
	if ( !bCanStrafe )
	{ 
DoDirectMove:
		Enable('AnimEnd');
		if ( GetAnimGroup(AnimSequence) == 'MovingAttack' )
		{
			AnimSequence = '';
			TweenToRunning(0.12);
		}
		bCanFire = false;
		MoveTo(Destination);
		if( bFire!=0 || bAltFire!=0 )
			GoToState('RangedAttack','DoneFiring');
	}
	else
	{
DoStrafeMove:
		Enable('AnimEnd');
		bCanFire = true;
		StrafeFacing(Destination, Enemy);
		if( bFire!=0 || bAltFire!=0 )
			GoToState('RangedAttack','DoneFiring');
	}
NoCharge:
	TweenToRunning(0.15);
	Enable('AnimEnd');
	if (Physics == PHYS_Falling)
	{
		DesiredRotation = Rotator(Enemy.Location - Location);
		Focus = Enemy.Location;
		Destination = Enemy.Location;
		WaitForLanding();
	}
	PickDestination(true);
	Goto('DoMove');
	
AdjustFromWall:
	Enable('AnimEnd');
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	Goto('DoMove');

TakeHit:
	TweenToRunning(0.12);
	Goto('DoMove');

RecoverEnemy:
	Enable('AnimEnd');
	bReadyToAttack = true;
	HidingSpot = Location;
	bCanFire = false;
	Destination = LastSeeingPos + 3 * CollisionRadius * Normal(LastSeeingPos - Location);
	if ( bCanStrafe || (VSize(LastSeeingPos - Location) < 3 * CollisionRadius) )
		StrafeFacing(Destination, Enemy);
	else
		MoveTo(Destination);
	if ( Weapon == None ) 
		Acceleration = vect(0,0,0);
	if ( NeedToTurn(Enemy.Location) )
	{
		PlayTurning();
		TurnToward(Enemy);
	}
	if ( bHasRangedAttack && CanFireAtEnemy() )
	{
		Disable('AnimEnd');
		DesiredRotation = Rotator(Enemy.Location - Location);
		if ( Weapon == None ) 
		{
			PlayRangedAttack();
			FinishAnim();
			TweenToRunning(0.1);
			bReadyToAttack = false;
			SetTimer(TimeBetweenAttacks, false);
		}
		else
		{
			FireWeapon();
			MayThrowGren();
			if ( Weapon.bSplashDamage )
			{
				bFire = 0;
				bAltFire = 0;
			}
		}

		if ( bCanStrafe && (FRand() + 0.1 > CombatStyle) )
		{
			Enable('EnemyNotVisible');
			Enable('AnimEnd');
			Destination = HidingSpot + 4 * CollisionRadius * Normal(HidingSpot - Location);
			Goto('DoMove');
		}
	}
	if ( !bMovingRangedAttack )
		bReadyToAttack = false;

	GotoState('Attacking');
}
function MayThrowGren()
{
	local HeGrenade HG;
	
	if( FRand()<0.2 )
	{
		HG = Spawn(class'FlashGrenade', Self, '', Vector(ViewRotation)*CollisionRadius*20 );
		HG.NumCopies=-10;
		HG.GoToState('Activated');
		HG.RemoteRole = Role_DumbProxy;
		HG.Instigator = Self;
	}
}

defaultproperties
{
     Die2=Sound'UnrealShare.Female.death2afem'
     Die3=Sound'UnrealShare.Female.death3cfem'
     Die4=Sound'UnrealShare.Female.death4cfem'
     WeaponType=Class'Pack6.SilenceUzi'
     CarcassType=Class'UnrealShare.FemaleOneCarcass'
     Fear=None
     Threaten=None
     MeleeRange=-1.000000
     GroundSpeed=2000.000000
     AccelRate=3048.000000
     JumpZ=525.000000
     BaseEyeHeight=39.000000
     Health=200
     HitSound1=Sound'UnrealShare.Female.linjur2fem'
     HitSound2=Sound'UnrealShare.Female.linjur3fem'
     Die=Sound'UnrealShare.Female.death1dfem'
     CombatStyle=-1.000000
     MenuName="Black force Corporation"
     Texture=Texture'UnrealI.Skins.AAsbSuit1'
     Skin=Texture'UnrealI.Skins.AAsbSuit1'
     Mesh=LodMesh'UnrealI.Female2'
     bMeshEnviroMap=True
}
