//=============================================================================
// Boneacle.
//=============================================================================
class Boneacle expands Barnacle;

var float Rechecking;
var Pawn ToAttack;
var bool bReady;

function Hitted()
{
	TT.SetLocation(Location+vect(0,0,-30));
	TT.Velocity=vect(0,0,0);
	ToAttack=None;
	bReady = True;
	Timer();
	GoToState('Lick','Begin');
}
function PreBeginPlay()
{
	Super.PreBeginPlay();
	SetTimer(1,true);
}
Auto state Lick
{
ignores HitWall,SeePlayer,SetEnemy;
	Event HearNoise( float Loudness, Actor NoiseMaker);
	
	Event BeginState()
	{
		SetTimer(1,true);
		bReady = True;
	}
	function Timer()
	{
		local Pawn P,ClosestPawn;
		local float thisDist,ClosestDistance;
		
		ClosestDistance = 1000000;
		ClosestPawn = None;	
		ForEach VisibleActors(class'Pawn',P,3500)
		{
			if( P.Location.Z<Location.Z && !P.IsA('FlockPawn') && !P.IsA('DeathTent') &&
			 !P.IsA('FlockMasterPawn') && P.Health>0 && !P.bHidden && !P.IsA('Barnacle') && !P.IsA('MirrorTent') )
			{
				thisDist = VSize(P.Location - Location); 
				if ( thisDist < ClosestDistance) 
				{
					ClosestPawn = P;
					ClosestDistance = thisDist;
				}
			}
		}
		if( ClosestPawn!=None )
			Attack(ClosestPawn);
	}
	function Attack( Pawn P )
	{
		if( !bReady || Target!=None || P.IsA('Barnacle') )
			Return;
		ToAttack = P;
		bReady = False;
		TT.SetLocation(Location+vect(0,0,-30));
		TT.Tried = True;
		GoToState('Lick','AttackE');
	}
Begin:
	PlayAnim('Curl');
	bEating = False;
	PlaySound(Sound'curltn', SLOT_Interact);
	bReady = True;
	TT.SetLocation(Location+vect(0,0,-10));
	Stop;
GotEnemy:
	bReady = False;
	bEating = False;
	PlaySound(Sound'yell1tn', SLOT_Interact);
Redo:
	bReady = False;
	Target.SetLocation(TT.Location);
	Pawn(Target).Weapon=None;
	TT.SetRotation(rotator(Location - Target.Location));
	TT.Velocity=vector(TT.Rotation)*200;
	PlayAnim('Uncurl');
	FinishAnim();
	LoopAnim('Move2');
	Stop;
EatEnemy:
	bReady = False;
	TT.Velocity=vect(0,0,0);
	TT.SetLocation(Location);;
	PlaySound(Sound'injured1tn', SLOT_Interact);
	PlayAnim('Smack',2,0.1);
	FinishAnim();
	PlaySound(Sound'splat2tn', SLOT_Interact);
	Target.TakeDamage(BiteDamage,Self,Location,vect(0,0,0), 'hacked');
	if( Pawn(Target).Health<=0 )
	{
		if( Target.Class!=None )
			Target.SetPhysics(OldPhy);
		Target=None;
		bReady = True;
		GoTo('Begin');
	}
	Sleep(0.2);
	GoTo('EatEnemy');
AttackE:
	bReady = False;
	PlaySound(Sound'yell1tn', SLOT_Interact);
	PlayAnim('Waver',1,0.4);
	FinishAnim();
	TT.SetPhysics(PHYS_Projectile);
	TT.SetRotation(rotator(ToAttack.Location - Location));
	TT.Velocity= vector(TT.Rotation)*600;
	TT.Tried=true;
	LoopAnim('Move2');
}

defaultproperties
{
     BiteDamage=120
     Fatness=54
     MultiSkins(1)=Texture'UnrealShare.Skins.Chip1'
}
