//=============================================================================
// BouEffect.
//=============================================================================
class BouEffect expands SBEffect;

simulated function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);
	
	if( VSize(Owner.Velocity)>500 )
	{
		if( Owner.Physics!=PHYS_Falling )
			Owner.SetPhysics(PHYS_Falling);
		if( !bCollideWorld )
		{
			Velocity = Owner.Velocity;
			bCollideWorld = True;
			Owner.bCollideWorld = False;
			SetCollision(true);
			SetCollisionSize(Owner.CollisionRadius+20,Owner.CollisionHeight+20);
		}
		if( Physics!=PHYS_Falling )
			SetPhysics(PHYS_Falling);
		Owner.SetLocation(Location);
		Owner.Velocity = Velocity;
	}
	else
	{
		if( bCollideWorld )
		{
			bCollideWorld = False;
			Owner.bCollideWorld = Owner.Default.bCollideWorld;
			SetCollision(false);
		}
		if( Physics!=PHYS_Trailer )
			SetPhysics(PHYS_Trailer);
	}
}

simulated function HitWall( vector HitNormal, actor HitWall )
{
	Velocity = MirrorVectorByNormal(Velocity,HitNormal)*0.9;
	Owner.Velocity = Velocity;
	PlaySound(Sound'UnrealShare.BioRifle.GelHit', SLOT_Misc, FMax(0.5, VSize(Velocity)/800) );
}

simulated function Landed( vector HitNormal )
{
	HitWall(HitNormal,Level);
}

simulated function Bump( Actor Other )
{
	local vector OldVel;
	local actor HitActor;
	local vector HitLocation, HitNormal, TestLocation;
	
	HitActor = Trace(HitLocation, HitNormal, Location, Other.Location, true);
	OldVel = Velocity;
	if( HitActor==Other )
		HitWall( HitNormal, Other);
	else HitWall( Normal(Location - Other.Location), Other);
	if ( Other.IsA('BlockAll') )
		return;
	
	if( Level.NetMode!=NM_Client )
		Other.TakeDamage(VSize(Velocity)/2,Pawn(Owner),(Other.Location-Location)/2+Location,OldVel,'crushed');
}
event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
	Velocity = Momentum/Owner.Mass*3;
	Owner.Velocity = Velocity;
	Owner.TakeDamage(Damage,EventInstigator,HitLocation,Momentum,DamageType);
}

defaultproperties
{
     bBounce=True
}
