//=============================================================================
// BounchyDAmmo.
//=============================================================================
class BounchyDAmmo expands RazorBlade;

var() int MaxHits;
var() class<Effects> HitWallEffect;

auto state Flying
{
	simulated function HitWall (vector HitNormal, actor Wall)
	{
		Spawn(HitWallEffect);
		bCanHitInstigator = true;
		PlaySound(ImpactSound, SLOT_Misc, 2.0);
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
		{
			if ( Role == ROLE_Authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');
			Destroy();
			return;
		}
		NumWallHits++;
		SetTimer(0, False);
		MakeNoise(0.3);
		if ( NumWallHits > MaxHits )
			Destroy();
		Velocity -= 2 * ( Velocity dot HitNormal) * HitNormal;  
		SetRoll(Velocity);
	}
	simulated function BeginState()
	{

		SetTimer(0.2, false);
		SetUp();
		if ( Level.NetMode != NM_DedicatedServer )
			if ( Level.NetMode == NM_Standalone )
				SoundPitch = 200 + 50 * FRand();		
	}
}

defaultproperties
{
     MaxHits=3
     HitWallEffect=Class'UnrealShare.SpriteGreenE'
     Damage=40.000000
     SpawnSound=None
     ImpactSound=Sound'UnrealShare.General.DispEX1'
     MiscSound=Sound'UnrealShare.General.DispEX1'
     Texture=FireTexture'UnrealShare.Effect1.FireEffect1u'
     Mesh=LodMesh'UnrealShare.DispM1'
     Fatness=255
     LightType=LT_Steady
     LightBrightness=155
     LightHue=42
     LightSaturation=72
     LightRadius=5
}
