//=============================================================================
// Boy.
//=============================================================================
class Boy expands HumanPawn;

var Actor WayNode;
var vector MoveVect,OldVect;
var float HuntingTime;
var Boy Friend;
var(Sounds) sound Speak[5];
var bool bImTheBoss;
var Weapon ToSeek;

function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	bQuiet = false;
	GotoState('IdleMoving');
}
state Guarding
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Wandering
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Waiting
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
function FindEnemys();
function PreSetMovement()
{
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = false;
	MinHitWall = -0.6;
	bCanOpenDoors = true;
	bCanDoSpecial = true;
}
function GoTalkTo( Boy Other );
function bool RedyToMove( Boy Other );
State IdleMoving
{
	function FindEnemys()
	{
		local Boy GB;
		
		CheckVisibleEnemys();
		if( FRand()<0.2 )
			ForEach VisibleActors(class'Boy',GB,600)
				if( FRand()<0.2 && GB.Friend==None && GB!=Self )
					GoTalkTo(GB);
	}
	function GoTalkTo( Boy Other )
	{
		Friend = Other;
		Other.Friend = Self;
		GoToState('IdleMoving','GoTalk');
		Other.GoToState('IdleMoving','GoTalk');
		HuntingTime = 10;
		Other.HuntingTime = 10;
	}
	function bool FindDestination()
	{
		local Pawn P;
		local int i,ii;
		
		ForEach AllActors(class'Pawn',P)
			if( !P.IsA('GoodBoy') && !P.IsA('CoopBot') && !P.IsA('PlayerPawn') )
				i++;
		i = Rand(i+1);
		ForEach AllActors(class'Pawn',P)
		{
			if( !P.IsA('GoodBoy') && !P.IsA('CoopBot') && !P.IsA('PlayerPawn') )
			{
				if( i==ii )
				{
					if( FindPathTo(P.Location)==None )
						Return false;
					MoveVect = P.Location;
					HuntingTime = 30;
					Return true;
				}
				ii++;
			}
		}
		Return false;
	}
	function Tick( float DeltaTime )
	{
		if( HuntingTime>=0 ) HuntingTime-=DeltaTime;
		if( (Enemy==None || Enemy.Class==None) && Weapon!=None )
			Level.Game.DiscardInventory(self);
	}
	Event BeginState()
	{
		PreSetMovement();
	}
	function Bump( Actor Other )
	{
		if( Other.IsA('Boy') && Friend!=None )
		{
			if( Friend==Other )
			{
				Disable('Bump');
				bImTheBoss = True;
				GoodBoy(Other).bImTheBoss=False;
				GoToState('IdleMoving','Talking');
				Other.GoToState('IdleMoving','Talking');
			}
		}
		if( Other.IsA('Weapon') && Other.IsInState('Pickup') )
		{
			if( Enemy==None || Enemy.Class==None )
				Return;
			bIsPlayer=True;
			Other.Touch(Self);
			bIsPlayer=False;
		}
	}
	function Touch( Actor Other )
	{
		if( Other.IsA('Weapon') && Other.IsInState('Pickup') )
		{
			if( Enemy==None || Enemy.Class==None )
				Return;
			bIsPlayer=True;
			Other.Touch(Self);
			bIsPlayer=False;
		}
	}
	function SpeakToFriend()
	{
		local float Decesion;
		
		Decesion = FRand();
		if( Decesion<0.2 )
		{
			PlayAnim('Taunt1');
			PlaySound(Speak[0]);
		}
		else if( Decesion<0.4 )
		{
			PlayAnim('Victory1');
			PlaySound(Speak[1]);
		}
		else if( Decesion<0.6 )
		{
			PlayAnim('Wave',0.5);
			PlaySound(Speak[2]);
		}
		else if( Decesion<0.8 )
		{
			PlayAnim('LookL');
			PlaySound(Speak[3]);
		}
		else
		{
			PlayAnim('Dead6');
			PlaySound(Speak[4]);
		}
	}
	function bool RedyToMove( Boy Other )
	{
		if( Other.bImTheBoss ) Return False;
		else if( FRand()<0.6 ) Return true;
		Return False;
	}
	
Begin:
	PlayRunning();
	FindEnemys();
	if( !FindDestination() )
	{
		MoveVect = Location;
		MoveVect.Y += Rand(1000)-500;
		MoveVect.X += Rand(1000)-500;
		MoveVect.Z += Rand(1000)-500;
		MoveTo(MoveVect,GroundSpeed);
		if( OldVect==MoveVect ) Sleep(1);
		else OldVect=MoveVect;
	}
	else
	{
ReWalk:
		if( HuntingTime<=0 ) GoTo('Begin');
		WayNode = FindPathTo(MoveVect);
		if( WayNode==None )
		{
			MoveTo(MoveVect,GroundSpeed);
			if( OldVect==MoveVect ) Sleep(1);
			else OldVect=MoveVect;
		}
		else
		{
			MoveToward(WayNode,GroundSpeed);
			if( OldVect==WayNode.Location ) Sleep(1);
			else OldVect=WayNode.Location;
			if( pointReachable(MoveVect) ) GoTo('Begin');
			PlayRunning();
			FindEnemys();
			GoTo('ReWalk');
		}
	}
	GoTo('Begin');
GoTalk:
	if( Friend==None ) GoTo('Begin');
	Enable('Bump');
	PlayWalking();
	MoveToward(Friend,GroundSpeed/2);
	Sleep(0.1);
	if( HuntingTime<=0 )
	{
		Disable('Bump');
		Friend=None;
		GoTo('Begin');
	}
	GoTo('GoTalk');
Talking:
	if( Friend==None ) GoTo('Begin');
	PlayWalking();
	MoveToward(Self,GroundSpeed/2);
	PlayWaiting();
	FinishAnim();
	Acceleration = vect(0,0,0);
	if (NeedToTurn(Friend.Location))
	{	
		PlayTurning();
		TurnToward(Friend);
		TweenToPatrolStop(0.2);
		FinishAnim();
		NextAnim = '';
	}
Speak:
	SpeakToFriend();
	FinishAnim();
	PlayWaiting();
	Sleep(1);
	if( RedyToMove(Friend) )
	{
		Friend.Friend=None;
		Friend.GoToState('IdleMoving','Begin');
		Friend=None;
		GoTo('Begin');
	}
	else GoTo('Speak');
GetWeapon:
	FindClosestWeapon();
	if( ToSeek==None )
		GoToState('Attacking');
	PlayRunning();
	if( Enemy==None || Enemy.Class==None )
	{
		Enemy=None;
		GoTo('Begin');
	}
	if( bFoundPath(ToSeek) )
	{
		MoveTo(MoveVect,GroundSpeed);
		if( OldVect==MoveVect ) Sleep(0.2);
		else OldVect=MoveVect;
		if( Weapon==None )
			GoTo('GetWeapon');
		else
			GoTo('Attack');
	}
	else
		GoToState('Attacking');
Attack:
	if( Enemy==None || Enemy.Class==None )
	{
		Enemy=None;
		GoTo('Begin');
	}
	PlayRunning();
	if( bFoundPath(Enemy) )
	{
		MoveTo(MoveVect,GroundSpeed);
		if( OldVect==MoveVect ) Sleep(0.2);
		else OldVect=MoveVect;
		if( CanSee(Enemy) )
			GoToState('Attacking');
		else
			GoTo('Attack');
	}
	else GoToState('Attacking');
}
function bool bFoundPath( Actor Other )
{
	local Actor Node;
	
	if( actorReachable(Other) )
	{
		MoveVect = Other.Location;
		Return true;
	}
	Node = FindPathToward(Other);
	if( Node!=None )
	{
		MoveVect = Node.Location;
		Return true;
	}
	Return false;
}
function FindClosestWeapon()
{
	local Weapon Victims,ClosestW;
	local float thisDist,ClosestDistance;
	
	ClosestDistance = 100000000;
	ClosestW = None;	
	foreach AllActors(class'Weapon', Victims )
	{
		if( Victims.IsInState('Pickup') )
		{
			thisDist = VSize(Victims.Location - Location); 
			if ( thisDist < ClosestDistance) 
			{
				ClosestW = Victims;
				ClosestDistance = thisDist;
			}
		}
	}
	if( ClosestW!=None )
		ToSeek = ClosestW;
}
function bool SetEnemy( Pawn NewEnemy )
{
	if( NewEnemy==None ) Return False;
	if( ScriptedPawn(NewEnemy)==None || Boy(NewEnemy)!=None || GoodBoy(NewEnemy)!=None
	 || CoopBot(NewEnemy)!=None ) Return false;
	if( OldEnemy==None || OldEnemy!=Enemy )
		OldEnemy=Enemy;
	if( Friend!=None )
	{
		Friend.Friend=None;
		Friend.SetEnemy(NewEnemy);
		Friend = None;
	}
	Enemy = NewEnemy;
	if( IsInState('IdleMoving') && Weapon==None && ToSeek==None )
	{
		GoToState('IdleMoving','GetWeapon');
		Return false;
	}
	else Return False;
	if ( !bFirstHatePlayer && Enemy.bIsPlayer && (FirstHatePlayerEvent != '') )
		TriggerFirstHate();
	return true;
}
event HearNoise( float Loudness, Actor NoiseMaker)
{
	if( NoiseMaker.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker));
	else if( NoiseMaker.Owner!=None && NoiseMaker.Owner.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker.Owner));
}
event SeePlayer( actor Seen )
{
	if( Seen.IsA('Pawn') )
		SetEnemy(Pawn(Seen));
}
function Tick(float DeltaTime)
{
	if ( (Weapon != None) && (Weapon.AmmoType != None) )
		Weapon.AmmoType.AmmoAmount = Weapon.AmmoType.Default.AmmoAmount;
}
function bool CheckVisibleEnemys()
{
	local Pawn P;
	local vector HitL,HitN;
	local Actor TraceActor;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( VSize(P.Location-Location)<3000 && FlockPawn(P)==None &&
		 FlockMasterPawn(P)==None && P.Health>0 && !P.bHidden )
		{
			TraceActor = Trace(HitL,HitN,P.Location,Location);
			if( (TraceActor==P || TraceActor==None) && SetEnemy(P) )
				Return True;
		}
	}
	Return false;
}

defaultproperties
{
     hitdamage=25
     Health=200
}
