//=============================================================================
// BurningThing.
//=============================================================================
class BurningThing expands Actor;

var Pawn Burner;
var float Heat,Count;

simulated function Tick(float DeltaTime)
{
	if( Owner==None || Owner.Class==None || Owner.bDeleteMe || Pawn(Owner).Health<=0 ) Destroy();
	Count+=DeltaTime;
	Heat-=DeltaTime;
	
	if( Count>0.6 )
	{
		Count=0;
		Owner.TakeDamage(((Rand(3)+10)*DrawScale),Burner,Owner.Location,vect(0,0,0),'burned');
	}
	if( Heat<=15 )
	{
		ScaleGlow = Heat*15;
		AmbientGlow = ScaleGlow * 255;
	}
	if( Heat<=0 ) Destroy();
}
simulated function ZoneChange( Zoneinfo NewZone )
{
	if( NewZone.bWaterZone && !NewZone.bDestructive )
	{
		PlaySound(Sound'AmbOutside.OneShot.UWgahit2');
		if( Owner.IsA('PlayerPawn') ) PlayerPawn(Owner).Clientmessage("Aaahhh!! Cold fresh water");
		Destroy();
	}
}
function PreBeginPlay()
{
	DrawScale = Owner.CollisionRadius/32;
}

defaultproperties
{
     Physics=PHYS_Trailer
     RemoteRole=ROLE_SimulatedProxy
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Effect28.FireEffect28a'
}
