//=============================================================================
// CarObject.
//=============================================================================
class CarObject expands Keypoint;

var vector TheLoc;
var rotator TheRot;
var CarMover C;

Event PreBeginPlay()
{
	Super.PreBeginPlay();
	TheLoc = C.Location-Location;
	TheRot = C.Rotation-Rotation;
	SetPhysics(PHYS_Falling);
}
event Landed( vector HitNormal )
{
	local rotator DesRot;
	BroadCastMessage(string(HitNormal)@"Landed");
	if( Velocity.Z>-50 )
	{
		Velocity.Z = 0;
		SetPhysics(PHYS_None);
	}
	else
		Velocity = Velocity*HitNormal/-2;
	DesRot = Rotation;
	DesRot.Pitch = Rotator(HitNormal).Pitch;
	SetRotation(DesRot);
}
event HitWall( vector HitNormal, actor HitWall )
{
	BroadCastMessage(string(HitNormal)@HitWall@"HitWall");
	if( HitWall!=Level )
		Return;
	Velocity = HitNormal*-Velocity;
}

defaultproperties
{
     bStatic=False
}
