//=============================================================================
// Cloaker.
//=============================================================================
class Cloaker expands HumanPawn;

var bool bCloaking,bStarting;

state Waiting
{
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(False);
	}
}
state Wandering
{
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(False);
	}
}
State Patroling
{
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(False);
	}
}
state Guarding
{
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(True);
	}
}
state Acquisition
{
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(True);
	}
}
state Hunting
{
ignores EnemyNotVisible; 
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(True);
	}
}
state MeleeAttack
{
ignores SeePlayer, HearNoise, Bump;
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(True);
	}
}
state RangedAttack
{
ignores SeePlayer, HearNoise, Bump;
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(True);
	}
}
state Attacking
{
ignores SeePlayer, HearNoise, Bump, HitWall;
	Event BeginState()
	{
		Super.BeginState();
		CheckCloak(True);
	}
}
function CheckCloak( bool bDoCloak )
{
	if( bCloaking && !bDoCloak ) GoToState('Cloak');
	else if( !bCloaking && bDoCloak ) GoToState('Cloak');
}
function Tick(float DeltaTime)
{
	if( bCloaking )
	{
		if( ScaleGlow > 0.2 )
			ScaleGlow -= DeltaTime/3;
		if( Velocity==vect(0,0,0) )
		{
			if( ScaleGlow > 0.02 )
				ScaleGlow -= DeltaTime/10;
		}
		else
		{
			if( ScaleGlow < 0.2 )
				ScaleGlow += DeltaTime/2;
		}
		if( Weapon!=None )
			Weapon.ScaleGlow = ScaleGlow;
	}
}
State Cloak
{
ignores SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget;

	function Tick(float DeltaTime)
	{
		if( bStarting )
		{
			if( FRand()<0.4 )
			{
				Fatness = Rand(100)+150;
				Texture = Texture'CloakTexture';
				bMeshEnviroMap = True;
				Style = STY_Translucent;
				ScaleGlow = 0.08;
				if( Weapon!=None )
				{
					Weapon.Style = STY_Translucent;
					Weapon.Texture = Texture'CloakTexture';
					Weapon.bMeshEnviroMap = True;
					Weapon.ScaleGlow = ScaleGlow;
				}
			}
			else
			{
				Fatness = Default.Fatness;
				bMeshEnviroMap = False;
				Style = STY_Normal;
				ScaleGlow = 0.95;
				if( Weapon!=None )
				{
					Weapon.Style = Weapon.Default.Style;
					Weapon.Texture = Weapon.Default.Texture;
					Weapon.bMeshEnviroMap = Weapon.Default.bMeshEnviroMap;
					Weapon.ScaleGlow = Weapon.Default.ScaleGlow;
				}
			}
		}
	}
	Event EndState()
	{
		if( bCloaking )
		{
			Texture = Texture'CloakTexture';
			bMeshEnviroMap = True;
			Style = STY_Translucent;
			if( Weapon!=None )
			{
				Weapon.Style = STY_Translucent;
				Weapon.Texture = Texture'CloakTexture';
				Weapon.bMeshEnviroMap = True;
				Weapon.ScaleGlow = ScaleGlow;
			}
		}
		else
		{
			bMeshEnviroMap = False;
			Style = STY_Normal;
			ScaleGlow = Default.ScaleGlow;
			if( Weapon!=None )
			{
				Weapon.Style = Weapon.Default.Style;
				Weapon.Texture = Weapon.Default.Texture;
				Weapon.bMeshEnviroMap = Weapon.Default.bMeshEnviroMap;
				Weapon.ScaleGlow = Weapon.Default.ScaleGlow;
			}
		}
	}
Begin:
	bStarting = True;
	if( !bCloaking ) PlaySound(Sound'scaryN4');
	else PlaySound(Sound'scaryN5');
	Sleep(3*FRand()+1);
	bCloaking = !bCloaking;
	bStarting = False;
	Fatness = Default.Fatness;
	if( bCloaking ) GoToState('Attacking');
	else GoToState('Wandering');
}

defaultproperties
{
     Die2=Sound'UnrealShare.Female.death3cfem'
     Die3=Sound'UnrealShare.Female.death2afem'
     Die4=Sound'UnrealShare.Female.death4cfem'
     WeaponType=Class'Pack6.GreatDisp'
     hitdamage=255
     Fear=Sound'UnrealShare.Female.hgasp3fem'
     Roam=None
     Threaten=Sound'UnrealShare.Female.linjur3fem'
     Health=500
     HitSound1=Sound'UnrealShare.Female.linjur1fem'
     HitSound2=Sound'UnrealShare.Female.linjur2fem'
     Die=Sound'UnrealShare.Female.death1dfem'
     MenuName="Cloaker Raquel"
     NameArticle=" the "
     Skin=Texture'Female1Skins.Raquel'
     Mesh=LodMesh'UnrealShare.Female1'
}
