//=============================================================================
// ColdRock.
//=============================================================================
class ColdRock expands BigRock;

var float Count,SmokeRate;

simulated function PostBeginPlay()
{
	Count = -0.1;
	if (Level.bHighDetailMode) SmokeRate = 0.135;
	else SmokeRate = 0.35;
	Super.PostBeginPlay();
}

simulated function Tick(float DeltaTime)
{
	local SpriteSmokePuff b;

	Count += DeltaTime;
	if ( Count>(SmokeRate+FRand()*(SmokeRate+2*0.035)) ) 
	{
		b = Spawn(class'SpriteSmokePuff');
		b.RemoteRole = ROLE_None;		
		Count=0.0;
	}
}
auto state Flying
{
	function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local int hitdamage;
		local IceThing IT;
		local Actor A;

		if ( Other == instigator )
			return;
		PlaySound(ImpactSound, SLOT_Interact, DrawScale/10);	

		if ( !Other.IsA('BigRock') && Other.Class!=instigator.Class && !Other.IsA('IceThing') &&
		 Role == ROLE_Authority )
		{
			Hitdamage = Damage*FRand() + Damage/2;
			if( Other.IsA('Pawn') && Pawn(Other).Health<=Hitdamage )
			{
					Pawn(Other).Health=0;
					if( Pawn(Other).bIsPlayer )
					{
						if( Other.Event != '' )
							foreach AllActors( class 'Actor', A, Event )
								A.Trigger(Pawn(Other),Instigator);
						level.game.Killed(Instigator,Pawn(Other),'Frozen');
						IT = Pawn(Other).Spawn(class'IceThing');
						IT.SetCollisionSize(Other.CollisionRadius,Other.CollisionHeight);
						IT.DrawScale = Other.DrawScale;
						IT.Mesh = Other.Mesh;
						IT.DrawScale = Other.DrawScale;
						IT.AnimSequence = Other.AnimSequence;
						IT.AnimFrame = Other.AnimFrame;
						Pawn(Other).HidePlayer();
						Pawn(Other).ClientDying('Frozen',Location);
						Pawn(Other).GotoState('Dying');
						Level.Game.DiscardInventory(Pawn(Other));
						if( Other.IsA('Other') )
							PlayerPawn(Other).ClientFlash(20000,vect(10000,10000,10000));
					}
					else
					{
						if( Other.Event != '' )
							foreach AllActors( class 'Actor', A, Event )
								A.Trigger(Pawn(Other),Instigator);
						level.game.Killed(Instigator,Pawn(Other),'Frozen');
						IT = Pawn(Other).Spawn(class'IceThing');
						IT.SetCollisionSize(Other.CollisionRadius,Other.CollisionHeight);
						IT.DrawScale = Other.DrawScale;
						IT.Mesh = Other.Mesh;
						IT.DrawScale = Other.DrawScale;
						IT.AnimSequence = Other.AnimSequence;
						IT.AnimFrame = Other.AnimFrame;
						Level.Game.DiscardInventory(Pawn(Other));
						Other.Destroy();
					}
			}
			else if( !Other.IsA('Pawn') )
			{
				if ( Role == ROLE_Authority )
				{
					IT = Other.Spawn(class'IceThing');
					IT.SetCollisionSize(Other.CollisionRadius,Other.CollisionHeight);
					IT.DrawScale = Other.DrawScale;
					IT.Mesh = Other.Mesh;
					IT.DrawScale = Other.DrawScale;
					IT.AnimSequence = Other.AnimSequence;
					IT.AnimFrame = Other.AnimFrame;
					Other.Destroy();
				}
			}
			else
				if ( (HitDamage > 6) && (speed > 150) )
					Other.TakeDamage(hitdamage, instigator,HitLocation,
						(35000.0 * Normal(Velocity)), 'crushed' );
		}
	}
}
function SpawnChunks(int num)
{
	local int    NumChunks,i;
	local BigRock   TempRock;
	local float scale;

	if ( DrawScale < 1 + FRand() )
		return;

	NumChunks = 1+Rand(num);
	scale = sqrt(0.52/NumChunks);
	if ( scale * DrawScale < 1 )
	{
		NumChunks *= scale * DrawScale;
		scale = 1/DrawScale;
	}
	speed = VSize(Velocity);
	for (i=0; i<NumChunks; i++) 
	{
		TempRock = Spawn(class'ColdRock');
		if (TempRock != None )
			TempRock.InitFrag(self, scale);
	}
	InitFrag(self, 0.5);
}

defaultproperties
{
     speed=1600.000000
     MaxSpeed=3000.000000
     Damage=20.000000
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.SEffect3.SmokeEffect3'
     bMeshEnviroMap=True
}
