//=============================================================================
// CrackerBlade.
//=============================================================================
class CrackerBlade expands RazorBlade;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();
	SetTimer(0.2,true);
}
auto state Flying
{
	simulated function BeginState()
	{
		SetUp();
		LoopAnim('Flying',1.0);
		if ( Level.NetMode == NM_Standalone )
			SoundPitch = 200 + 50 * FRand();
	}
	simulated function HitWall (vector HitNormal, actor Wall)
	{
		local rotator DeRot;
		local vector ve;
		
		bCanHitInstigator = true;
		LoopAnim('Flying',1.0);
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
		{
			if ( Role == ROLE_Authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');
			Destroy();
			return;
		}
		ve = vector(Rotator(HitNormal)+rot(15852,0,0))*VRand();
		ve *= Speed;
		Velocity = ve;
		SetRotation(rotator(ve));
	}
	simulated function Timer()
	{
		local pawn Victims,ClosestPawn;
		local float thisDist,ClosestDistance;
	
		Super.Timer();
		ClosestDistance = 100000;
		ClosestPawn = None;	
		//FIXME - use the pawnlist for this
		foreach VisibleCollidingActors( class'Pawn', Victims, 500.0 )
		{
			if( Victims.Class!=Instigator.Class )
			{
				thisDist = VSize(Victims.Location - Location); 
				if ( thisDist < ClosestDistance) 
				{
					ClosestPawn = Victims;
					ClosestDistance = thisDist;
				}
			}
		}
		if( ClosestPawn!=None )
		{
			SetRotation(rotator(ClosestPawn.Location - Location));
			Velocity = vector(Rotation)*(Speed/2);
		}
	}
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( bCanHitInstigator || (Other != Instigator) ) 
		{
			if ( Role == ROLE_Authority )		 
				Other.TakeDamage(damage, instigator,HitLocation,
					(MomentumTransfer * Normal(Velocity)), 'hacked' );
			if ( Other.IsA('Pawn') )
				PlaySound(MiscSound, SLOT_Misc, 2.0);
			else
				PlaySound(ImpactSound, SLOT_Misc, 2.0);
			destroy();
		}
	}
}

defaultproperties
{
     speed=1000.000000
     Damage=10.000000
     SpawnSound=Sound'UnrealShare.Razorfly.injur2rf'
     ImpactSound=Sound'UnrealShare.Razorfly.injur1rf'
     MiscSound=Sound'UnrealShare.Razorfly.death1rf'
     AnimSequence=Flying
     Texture=Texture'UnrealShare.DispExpl.dseY_A06'
     Mesh=LodMesh'UnrealShare.Firefly'
     bMeshEnviroMap=True
     AmbientSound=Sound'UnrealShare.flies.flybuzz'
}
