//=============================================================================
// DeadlyFly.
//=============================================================================
class DeadlyFly expands MagicFly;

var vector MoveVec;
function PlayMeleeAttack()
{
	PlayAnim('Shoot1',4);
	Target.TakeDamage(25,Self,Target.Location - 0.5 * (Target.CollisionHeight + 
	Target.CollisionRadius) * (Target.Location - Location)/100,Location,'Hacked');
	PlaySound(Threaten, SLOT_Talk); //FIXME - stingdamage instead of projectile
}
function bool SetEnemy( Pawn NewEnemy )
{
	if( NewEnemy==None ) Return False;
	if( NewEnemy.IsA('MagicFly') ) Return false;
	if( OldEnemy==None || OldEnemy!=Enemy )
		OldEnemy=Enemy;
	Enemy = NewEnemy;
	if( IsInState('IdleMoving') ) GoToState('Attacking');
	if ( !bFirstHatePlayer && Enemy.bIsPlayer && (FirstHatePlayerEvent != '') )
		TriggerFirstHate();
	return true;
}
event HearNoise( float Loudness, Actor NoiseMaker)
{
	if( NoiseMaker.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker));
	else if( NoiseMaker.Owner!=None && NoiseMaker.Owner.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker.Owner));
}
event SeePlayer( actor Seen )
{
	if( Seen.IsA('Pawn') )
		SetEnemy(Pawn(Seen));
}
State IdleMoving
{
	function FindAllEnemys()
	{
		local Pawn P;
		
		for( P=Level.PawnList; P!=None; P=P.nextPawn )
			if( P.IsA('ScriptedPawn') && !P.IsA('DeadlyFly') && CanSee(P) )
				SetEnemy(P);
	}
Begin:
	PlayInAir();
	FindAllEnemys();
	MoveVec = Location;
	MoveVec.X += Rand(2000)-1000;
	MoveVec.Y += Rand(2000)-1000;
	MoveVec.Z += Rand(2000)-1000;
	MoveTo(MoveVec,AirSpeed);
	Sleep(0.1);
	GoTo('Begin');
}
function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	bQuiet = false;
	GotoState('IdleMoving');
}
state Guarding
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Wandering
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Waiting
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
function PreSetMovement()
{
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = true;
	MinHitWall = -0.6;
	bCanOpenDoors = true;
	bCanDoSpecial = true;
}
function SetMovementPhysics()
{
	if (Physics != PHYS_Flying)
		SetPhysics(PHYS_Flying);
}

defaultproperties
{
     bHasRangedAttack=False
     bMovingRangedAttack=False
     Fear=Sound'UnrealShare.Brute.injur2br'
     Threaten=Sound'UnrealShare.Brute.injur1br'
     GroundSpeed=3200.000000
     AirSpeed=1720.000000
     AccelRate=2000.000000
     Health=200
     HitSound1=Sound'UnrealShare.Brute.death2br'
     HitSound2=Sound'UnrealShare.Brute.injur1br'
     Land=Sound'UnrealShare.Brute.yell1br'
     Style=STY_Translucent
     Texture=WetTexture'XFX.detailtest'
     SoundRadius=15
     SoundVolume=255
     SoundPitch=115
     AmbientSound=Sound'UnrealShare.Brute.yell2br'
     bBlockActors=False
     bBlockPlayers=False
}
