//=============================================================================
// EBubbelProj.
//=============================================================================
class EBubbelProj expands Actor;

var bool bGrow;
var vector StopVect;
var float SmokeV;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		StopVect,bGrow;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();
	
	Velocity = vector(rotation)*300;
}
Auto state doMOVE
{
Begin:
	Sleep(5);
	IsSTOP(None);
	Velocity=vect(0,0,0);
	bGrow=true;
	AmbientSound=sound'drum13';
}
Simulated function IsSTOP( Actor Other )
{
	Velocity=vect(0,0,0);
	bGrow=true;
	if( Other==None )
		Return;
	SetBase(Other);
	AmbientSound=sound'drum13';
}
Simulated function Tick( float DeltaTime )
{
	local GlunkEffect G;
	if( !bGrow ) Return;
	
	SoundPitch = 250-(Drawscale*24);
	DrawScale+=DeltaTime/2;
	SmokeV+=DeltaTime;
	if( SmokeV>=0.03 )
	{
		G = Spawn(class'GlunkEffect',self,,Location+30*Drawscale*VRand());
		if( G!=None )
			G.RemoteRole = ROLE_None;
		SmokeV=0;
	}
	if( StopVect!=vect(0,0,0) && Base!=None )
		SetLocation(Base.Location+StopVect);
	if( Level.NetMode!=NM_Client && DrawScale>10 )
		Explode(Location,Location);
}
function ProcessTouch (Actor Other, vector HitLocation)
{
	if( Other==Instigator ) Return;
	IsSTOP(Other);
	Velocity=vect(0,0,0);
	bGrow=true;
	StopVect=Location-Other.Location;
}
function Explode(vector HitLocation, vector HitNormal)
{
	local int i;
	
	HurtRadius(200,2600,'exploded',600000,Location);
	for (i = 0; i< 15; i++)
		Spawn(class'GlunkBall',,,Location+200*VRand(),RotRand(true));
	for (i = 0; i< 10; i++)
		Spawn(class'BIGGlunkBall',,,Location+200*VRand(),RotRand(true));
	Destroy();
}
function HitWall (vector HitNormal, actor Wall)
{
	IsSTOP(Wall);
	Velocity=vect(0,0,0);
	bGrow=true;
	AmbientSound=sound'drum13';
}
simulated singular function Touch(Actor Other)
{
	local actor HitActor;
	local vector HitLocation, HitNormal, TestLocation;
	
	if ( Other.IsA('BlockAll') )
	{
		HitWall( Normal(Location - Other.Location), Other);
		return;
	}
	if ( Other.bProjTarget || (Other.bBlockActors && Other.bBlockPlayers) )
	{
		//get exact hitlocation
	 	HitActor = Trace(HitLocation, HitNormal, Location, OldLocation, true);
		if (HitActor == Other)
		{
			if ( (Pawn(Other) != None) 
				&& !Pawn(Other).AdjustHitLocation(HitLocation, Velocity) )
					return;
			ProcessTouch(Other, HitLocation); 
		}
		else 
			ProcessTouch(Other, Other.Location + Other.CollisionRadius * Normal(Location - Other.Location));
	}
}

defaultproperties
{
     Physics=PHYS_Projectile
     RemoteRole=ROLE_SimulatedProxy
     Style=STY_Translucent
     Sprite=Texture'UnrealShare.S_bubble1'
     Texture=Texture'UnrealShare.S_bubble1'
     Skin=Texture'UnrealShare.S_bubble1'
     DrawScale=0.200000
     CollisionRadius=1.000000
     CollisionHeight=1.000000
     bCollideActors=True
     bCollideWorld=True
}
