//=============================================================================
// EnergyFire.
//=============================================================================
class EnergyFire expands TazerProj;

var float Count;

function Explode(vector HitLocation,vector HitNormal)
{
	local RingExplosion r;

	PlaySound(ImpactSound, SLOT_Misc, 0.5,,, 0.5+FRand());
	HurtRadius(Damage, 70, 'jolted', MomentumTransfer, Location );
	r = Spawn(class'ElectricRing',,, HitLocation+HitNormal*8,rotator(HitNormal));
	r.PlaySound(r.ExploSound,,6);
	Destroy();
}
function Tick(float DeltaTime)
{
	Count+=DeltaTime;
	if( Count>0.2 )
	{
		Count=0;
		SpawnEffect();
	}
}
function SpawnEffect()
{
	local vector DaRot,HitLocation,HitNormal;
	
	DaRot=Location;
	DaRot.Y+=Rand(30000)-15000;
	DaRot.X+=Rand(30000)-15000;
	DaRot.Z+=Rand(30000)-15000;
	Trace(HitLocation,HitNormal,DaRot,Location,true);
	PlaySound(Sound'UnrealShare.General.Lightning');
	DrawEffect(Location,HitNormal,HitLocation);
}
function DrawEffect(vector HitLocation,vector HitNormal,vector StartLoc)
{
	local RingExplosion4 Smoke;
	local vector SmokeLocation;
	local float Distance;
	local rotator SmokeRotation;
	
	Distance = VSize(HitLocation - StartLoc);
	Distance /= 20;
	if( Distance>15 ) Distance=16;
	SmokeLocation = StartLoc - HitLocation;
	SmokeLocation *= -1;
	SmokeLocation /= Distance;
	SmokeRotation = rotator(HitLocation-StartLoc);
	Smoke = Spawn(Class'Pack6.ElectricBolt',,,StartLoc,SmokeRotation);
	Smoke.MoveAmount = SmokeLocation;
	Smoke.NumPuffs = Distance;
}

defaultproperties
{
     Damage=100000000.000000
     ImpactSound=Sound'UnrealShare.General.Expl04'
}
