//=============================================================================
// FireDragon.
//=============================================================================
class FireDragon expands MasterManta;

var FireTail FT;
var vector MoveVect,OldVect;

function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
					Vector momentum, name damageType)
{
	if( damageType=='Burned' )
		Return;
	else if( damageType=='Frozen' || damageType=='Freeze' )
		Super.TakeDamage(NDamage*2,instigatedBy,hitlocation,momentum,damageType);
	else Super.TakeDamage(NDamage,instigatedBy,hitlocation,momentum,damageType);
}
function PostBeginPlay()
{
	Super.PostBeginPlay();
	FT = Spawn(class'FireTail',Self);
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local pawn OtherPawn;
	local actor A;
	local SpriteBallExplosion SE;

	for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
		OtherPawn.Killed(Killer, self, damageType);
	if ( CarriedDecoration != None )
		DropDecoration();
	level.game.Killed(Killer, self, damageType);
	//log(class$" dying");
	if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, Killer );
	Level.Game.DiscardInventory(self);
	SE = Spawn(class'SpriteBallExplosion');
	SE.DrawScale=3;
	HurtRadius(1200,700,'Burned',10000,Location);
	Destroy();
}
function Destroyed()
{
	if( FT!=None )
		FT.Destroy();
	Super.Destroyed();
}
state Wandering
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Waiting
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
State IdleMoving
{
Begin:
FindASpot:
	MoveVect = Location;
	MoveVect.X += Rand(1000)-500;
	MoveVect.Y += Rand(1000)-500;
	MoveVect.Z += Rand(1000)-500;
DoMove:
	PlayRunning();
	CheckVisibleEnemys();
	bCanJump=False;
	MoveTo(MoveVect,Groundspeed*3);
	if( OldVect==MoveVect )
		Sleep(0.2);
	else OldVect=MoveVect;
	GoTo('FindASpot');
}
function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	bQuiet = false;
	GotoState('IdleMoving');
}
function bool SetEnemy(Pawn NewEnemy)
{
	if( NewEnemy.Health<=0 ) Return false;
	if( NewEnemy.IsA('FireDragon') || NewEnemy.IsA('FlockPawn') ) Return false;
	else if( NewEnemy.IsA('ScriptedPawn') && ScriptedPawn(NewEnemy).AttitudeToCreature(Self)!=Attitude_Friendly )
	{
		if( Enemy!=None && Enemy!=NewEnemy )
			OldEnemy=Enemy;
		Enemy=NewEnemy;
		Target=NewEnemy;
	}
	else
	{
		if( Enemy!=None && Enemy!=NewEnemy )
			OldEnemy=Enemy;
		Enemy=NewEnemy;
		Target=NewEnemy;
	}
	if( IsInState('IdleMoving') ) GoToState('Attacking');
	Return true;
}

defaultproperties
{
     Aggressiveness=10.000000
     RangedProjectile=Class'Pack6.EGasBagBelch'
     ProjectileSpeed=1200.000000
     bCanStrafe=True
     AirSpeed=4000.000000
     AccelRate=1400.000000
     Health=1200
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Effect28.fireeffect28'
     Skin=None
     Fatness=230
     bMeshEnviroMap=True
}
