//=============================================================================
// FireEffect.
//=============================================================================
class FireEffect expands Actor;

simulated function Tick(float DeltaTime)
{
	if( DrawScale<60 )
		DrawScale+=(DeltaTime*5);
	else DrawScale+=(DeltaTime*15);
	if( DrawScale>150 ) Destroy();
	
	HurtRadius2(2,(DrawScale*7),'Burned',10,Location);
	if( DrawScale<120 )
		LightRadius = DrawScale*2;
}
	
	
function HurtRadius2( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local actor Victims;
	local float damageScale, dist;
	local vector dir;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Actor', Victims, DamageRadius, HitLocation )
	{
		if( Victims != self && Victims != Owner )
		{
			if( Victims.bIsPawn && Pawn(Victims).FindInventoryType(class'ElemSuit')!=None )
				GoTo 'GoGo1';
			dir = Victims.Location - HitLocation;
			dist = FMax(1,VSize(dir));
			dir = dir/dist; 
			damageScale = 1 - FMax(0,(dist - Victims.CollisionRadius)/DamageRadius);
			Victims.TakeDamage
			( damageScale * DamageAmount,Pawn(Owner),Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,
			(damageScale * Momentum * dir), DamageName );
			AddFireFor(Victims);
			GoGo1:
		} 
	}
	bHurtEntry = false;
}
function AddFireFor( Actor Other )
{
	local BurningThing bt;
	
	if ((Other.Region.Zone.bWaterZone && !Other.Region.Zone.bDestructive) || Other.IsA('Projectile')) Return;
	ForEach AllActors(class'BurningThing',bt)
	{
		if( bt.Owner==Other )
		{
			bt.Heat+=0.1;
			Return;
		}
	}
	
	bt = Spawn(class'BurningThing',Other);
	bt.Heat = 20;
	bt.Burner = Pawn(Owner);
}

defaultproperties
{
     AnimSequence=Explosion
     AnimFrame=6.000000
     DrawType=DT_Mesh
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Effect6.fireeffect6'
     Mesh=LodMesh'UnrealShare.b1exp'
     bMeshEnviroMap=True
     SoundRadius=48
     SoundVolume=255
     AmbientSound=Sound'Ambancient.Looping.lava31'
     LightType=LT_Steady
     LightBrightness=255
     LightSaturation=41
}
