//=============================================================================
// FlashGrenade.
//=============================================================================
class FlashGrenade expands HeGrenade;

function HurtPPL()
{
	Spawn(Class 'BiggerMercFlare',,,Location);
	PlaySound(Sound'UnrealShare.General.Explo1',,7.0,,,0.8);
	BurnRadius( DamageAmount, DamageRadius, 'exploded', 0, Location);
}

function BurnRadius( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local Pawn Victims;
	local float damageScale, dist;
	local vector dir;
	local Inventory I;
	local HoldFlash HF;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Pawn', Victims, DamageRadius, HitLocation )
	{
		if( Victims.Inventory!=None )
			For( I=Victims.Inventory; I!=None; I=I.Inventory )
				if( ShadowSuit(I)!=None )
					GoTo 'SkipHim';
		if( PlayerPawn(Victims)!=None )
		{
			HF = Spawn(class'HoldFlash',Victims,,Victims.Location);
			HF.TimeLeft = 7;
		}
		else
			AddFireFor(Victims);
		SkipHim:
	}
	bHurtEntry = false;
}
function AddFireFor( Actor Other )
{
	local ParalyseThing bt;
	
	if ( !Other.bIsPawn ) Return;
	ForEach AllActors(class'ParalyseThing',bt)
	{
		if( bt.Burner==Pawn(Other) )
		{
			bt.Heat+=3;
			bt.SetOwner(Instigator);
			Return;
		}
	}
	
	bt = Spawn(class'ParalyseThing',Instigator);
	bt.Heat = 10;
	bt.Burner = Pawn(Other);
}

defaultproperties
{
     DamageRadius=3000.000000
     DamageAmount=200
     PickupMessage="You got a Flash bang"
     ItemName="Flash bang"
     Texture=Texture'UnrealI.Skins.AAsbSuit1'
     Skin=Texture'UnrealI.Skins.AAsbSuit1'
     MultiSkins(0)=Texture'UnrealI.Skins.AAsbSuit1'
}
