//=============================================================================
// GRENADES.
// Ideas thanks to Kajgue!
//=============================================================================
class GRENADES expands Pickup;

var vector X,Y,Z;
var GRENADES f;
var bool bFirstTick;
var bool bDamaged;
var() float DamageRadius;
var() int DamageAmount;

state Activated  // Delete from inventory and toss in front of player.
{
	function Timer()
	{
		if( bFirstTick )
		{
			bFirstTick=False;
			PlaySound(ActivateSound);
			SetTimer(1.0,True);
			Enable('Touch');
		}
		Charge--;
		if (Charge<=0) TakeDamage(10,None, Vect(0,0,0), Vect(0,0,0), 'Detonated');
	}
	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
					Vector momentum, name damageType)
	{
		if( damageType!='Detonated' )
		{
			Velocity+=momentum/10;
			Velocity.Z+=VSize(momentum)/100;
			bBounce = True;
			SetPhysics(PHYS_Falling);
			Return;
		}
		if (bDamaged) Return;
		bDamaged = True;
		HurtPPL();
		Destroy();
	}
	function HitWall( vector HitNormal, actor Wall )
	{
		Velocity = 0.8*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
		PlaySound(Sound'UnrealShare.Eightball.GrenadeFloor', SLOT_Misc);
		bRotatetoDesired=True;
		bFixedRotationDir=False;
		DesiredRotation.Pitch=0;	
		DesiredRotation.Yaw=FRand()*65536;
		DesiredRotation.Roll=0;		
		RotationRate.Yaw = RotationRate.Yaw*0.75;
		RotationRate.Roll = RotationRate.Roll*0.75;
		RotationRate.Pitch = RotationRate.Pitch*0.75;	
		If (VSize(Velocity) < 5)
		{
			bBounce = False;
			SetPhysics(PHYS_None);
		}
	}
	function Bump( Actor Other )
	{
		local actor HitActor;
		local vector HitLocation, HitNormal, TestLocation;
		
		Other.TakeDamage(VSize(Velocity)/100,Instigator,Location,Velocity,'Bumped');
		HitActor = Trace(HitLocation,HitNormal,Other.Location,Location,True);
		if( HitActor==Other )
			HitWall( HitNormal, Other);
		else
			HitWall( Normal(Location - Other.Location), Other);
	}
	function Touch( Actor Other )
	{
		Bump(Other);
	}
Begin:
	if (NumCopies>0)
	{
		NumCopies--;
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		f=Spawn(class, Owner, '', Pawn(Owner).Location +10*Y - 20*Z );
		f.NumCopies=-10;
		f.GoToState('Activated');
		f.RemoteRole = Role_DumbProxy;
		GoToState('');
	}
	else
	{
		Disable('Touch');
		SetCollision(true,true,true);
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		SetPhysics(PHYS_Falling);
		Velocity = Owner.Velocity + Vector(Pawn(Owner).ViewRotation) * 800;
		Velocity.z += 70;
		SetTimer(0.25,True);
		DesiredRotation = RotRand();
		RotationRate.Yaw = 200000*FRand() - 100000;
		RotationRate.Pitch = 200000*FRand() - 100000;
		RotationRate.Roll = 200000*FRand() - 100000;
		bFixedRotationDir=True;
		SetLocation(Owner.Location+Y*10-Z*20);
		if (NumCopies>-5) {
			Pawn(Owner).NextItem();
			if (Pawn(Owner).SelectedItem == Self) Pawn(Owner).SelectedItem=None;	
			Pawn(Owner).DeleteInventory(Self);
		}
		bFirstTick=True;
		RemoteRole = Role_DumbProxy;
		BecomePickup();		
		bStasis = false;
		bBounce=True;
		bCollideWorld=True;		
	}
}

function HurtPPL()
{
	Spawn(Class 'SpriteBallExplosion',,,Location);
	HurtRadius( DamageAmount, DamageRadius, 'exploded', 0, Location);
}

auto state Pickup
{
	function bool ValidTouch( actor Other )
	{
		local Actor A;
		local Inventory I;

		if( Other.bIsPawn && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger( Other, Other.Instigator );
			return true;
		}
		return false;
	}
	function EndState()
	{
		LifeSpan = 0;
		Super.EndState();
	}
}
function PickupFunction(Pawn Other)
{
	if( PlayerPawn(Owner)==None )
		SetTimer(3+5*FRand(),false);
}

function Timer()
{
	if( PlayerPawn(Owner)==None )
	{
		if( NumCopies<=0 )
			SetTimer(0,false);
		else SetTimer(3+5*FRand(),false);
		Activate();
	}
}

defaultproperties
{
     PickupMessage=""
     M_Activated=" set"
}
