//=============================================================================
// GravEffect.
//=============================================================================
class GravEffect expands FireEffect;

simulated function Tick(float DeltaTime)
{
	if( DrawScale<100 )
		DrawScale+=(DeltaTime*10);
	else DrawScale+=(DeltaTime*20);
	if( DrawScale>400 ) Destroy();
	
	HurtRadius2(15,(DrawScale*7),'Burned',10,Location);
	if( DrawScale<120 )
		LightRadius = DrawScale*2;
}

function HurtRadius2( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local actor Victims;
	local float dist;
	local vector dir;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach RadiusActors( class 'Actor', Victims, DamageRadius, HitLocation )
	{
		if( Victims.bIsPawn && Pawn(Victims).FindInventoryType(class'ParalSuit')!=None )
			GoTo 'GoGo1';
		if( !Victims.IsA('Inventory') && Victims.bCollideActors && Victims != self &&
		 Victims != Owner && !Victims.bStatic && !Victims.bNoDelete )
		{
			dir = Victims.Location - HitLocation;
			dist = FMax(1,VSize(dir));
			dir = dir/dist; 
			if( Victims.Physics!=PHYS_Rotating && Victims.Physics!=PHYS_None && Victims.Physics!=PHYS_Trailer && Victims.Physics!=PHYS_Projectile )
				Victims.SetPhysics(PHYS_Falling);
			Victims.Velocity += dir*-120;
		}
		GoGo1:
	}
	bHurtEntry = false;
}

defaultproperties
{
     Texture=FireTexture'UnrealShare.Effect3.fireeffect3a'
     SoundRadius=32
     SoundVolume=128
     AmbientSound=Sound'AmbModern.Looping.bigelec7'
}
