//=============================================================================
// GravityKiller.
//=============================================================================
class GravityKiller expands Pack6Weps;

function PlayIdleAnim()
{
	LoopAnim('Swim1',0.5,0.2);
}
function PlaySelect()
{
	PlayAnim('Swim1',1.0,0.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);	
}
function TweenSelect()
{
	TweenAnim('Swim1',0.001);
}
function TweenDown()
{
	PlayAnim('Swim1', 1.0, 0.05);
}
state NormalFire
{
Ignores Fire,AltFire;

Begin:
	PlayAnim('Bite',0.8,0.1);
	Owner.PlaySound(FireSound, SLOT_None,Pawn(Owner).SoundDampening*4.0);
	ProjectileFire(ProjectileClass,1000,True);
	FinishAnim();
	Finish();
}

////////////////////////////////////////////////////////
state AltFiring
{
Ignores Fire,AltFire;

Begin:
	PlayAnim('Bite',0.3,0.1);
	Owner.PlaySound(AltFireSound, SLOT_None,Pawn(Owner).SoundDampening*4.0);
	ProjectileFire(AltProjectileClass,1000,True);
	FinishAnim();
	Sleep(0.4);
	Finish();
}
function AltFire( float Value )
{
	if (AmmoType.UseAmmo(5))
		GotoState('AltFiring');
}
function Fire( float Value )
{
	if (AmmoType.UseAmmo(1))
		GotoState('NormalFire');
}

defaultproperties
{
     AmmoName=Class'UnrealI.FlakBox'
     PickupAmmoCount=80
     FireOffset=(X=12.000000,Y=-10.000000,Z=-15.000000)
     ProjectileClass=Class'Pack6.GlunkBall'
     AltProjectileClass=Class'Pack6.BIGGlunkBall'
     FireSound=Sound'UnrealShare.Razorfish.tear1fs'
     AltFireSound=Sound'UnrealShare.Razorfish.chomp1fs'
     AutoSwitchPriority=6
     InventoryGroup=6
     PickupMessage="You got the GravityKiller"
     ItemName="GravityKiller"
     PlayerViewOffset=(X=4.200000,Y=-3.000000,Z=-4.000000)
     PlayerViewMesh=LodMesh'UnrealShare.AmbientFish'
     PlayerViewScale=0.700000
     PickupViewMesh=LodMesh'UnrealShare.AmbientFish'
     PickupViewScale=2.000000
     ThirdPersonMesh=LodMesh'UnrealShare.AmbientFish'
     ThirdPersonScale=3.000000
     Mesh=LodMesh'UnrealShare.AmbientFish'
     DrawScale=2.000000
     CollisionRadius=10.000000
     CollisionHeight=10.000000
}
