//=============================================================================
// GreatDisp.
//=============================================================================
class GreatDisp expands Pack6Weps;

// player view version
#exec MESH IMPORT MESH=DPistol ANIVFILE=MODELS\dgun_a.3D DATAFILE=MODELS\dgun_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DPistol X=0 Y=0 Z=0 YAW=-64 PITCH=0
#exec MESHMAP SCALE MESHMAP=DPistol X=0.005 Y=0.005 Z=0.01
#exec MESH SEQUENCE MESH=DPistol SEQ=All     STARTFRAME=0  NUMFRAMES=141
#exec MESH SEQUENCE MESH=DPistol SEQ=Select1 STARTFRAME=0  NUMFRAMES=11 GROUP=Select
#exec MESH SEQUENCE MESH=DPistol SEQ=Shoot1  STARTFRAME=11 NUMFRAMES=3
#exec MESH SEQUENCE MESH=DPistol SEQ=Idle1   STARTFRAME=14  NUMFRAMES=2
#exec MESH SEQUENCE MESH=DPistol SEQ=Down1   STARTFRAME=16  NUMFRAMES=5
#exec MESH SEQUENCE MESH=DPistol SEQ=PowerUp1 STARTFRAME=21  NUMFRAMES=4
#exec MESH SEQUENCE MESH=DPistol SEQ=Still    STARTFRAME=25  NUMFRAMES=5
#exec MESH SEQUENCE MESH=DPistol SEQ=Select2 STARTFRAME=30  NUMFRAMES=11 GROUP=Select
#exec MESH SEQUENCE MESH=DPistol SEQ=Shoot2  STARTFRAME=41 NUMFRAMES=3
#exec MESH SEQUENCE MESH=DPistol SEQ=Idle2   STARTFRAME=44  NUMFRAMES=2
#exec MESH SEQUENCE MESH=DPistol SEQ=Down2   STARTFRAME=46  NUMFRAMES=5
#exec MESH SEQUENCE MESH=DPistol SEQ=PowerUp2 STARTFRAME=51  NUMFRAMES=9
#exec MESH SEQUENCE MESH=DPistol SEQ=Select3 STARTFRAME=60  NUMFRAMES=11 GROUP=Select
#exec MESH SEQUENCE MESH=DPistol SEQ=Shoot3  STARTFRAME=71 NUMFRAMES=3
#exec MESH SEQUENCE MESH=DPistol SEQ=Idle3   STARTFRAME=74  NUMFRAMES=2
#exec MESH SEQUENCE MESH=DPistol SEQ=Down3   STARTFRAME=76  NUMFRAMES=5
#exec MESH SEQUENCE MESH=DPistol SEQ=PowerUp3 STARTFRAME=81  NUMFRAMES=9
#exec MESH SEQUENCE MESH=DPistol SEQ=Select4 STARTFRAME=90  NUMFRAMES=11 GROUP=Select
#exec MESH SEQUENCE MESH=DPistol SEQ=Shoot4  STARTFRAME=101 NUMFRAMES=3
#exec MESH SEQUENCE MESH=DPistol SEQ=Idle4   STARTFRAME=104  NUMFRAMES=2
#exec MESH SEQUENCE MESH=DPistol SEQ=Down4   STARTFRAME=106  NUMFRAMES=5
#exec MESH SEQUENCE MESH=DPistol SEQ=PowerUp4 STARTFRAME=111  NUMFRAMES=9
#exec MESH SEQUENCE MESH=DPistol SEQ=Select5 STARTFRAME=120 NUMFRAMES=11 GROUP=Select
#exec MESH SEQUENCE MESH=DPistol SEQ=Shoot5  STARTFRAME=131 NUMFRAMES=3
#exec MESH SEQUENCE MESH=DPistol SEQ=Idle5   STARTFRAME=134 NUMFRAMES=2
#exec MESH SEQUENCE MESH=DPistol SEQ=Down5   STARTFRAME=136  NUMFRAMES=5

#exec TEXTURE IMPORT NAME=DPistol1 FILE=MODELS\dgun.PCX GROUP="Skins"
#exec OBJ LOAD FILE=Textures\SmokeEffect2.utx PACKAGE=UnrealShare.SEffect2
#exec MESHMAP SETTEXTURE MESHMAP=DPistol NUM=1  TEXTURE=DPistol1
#exec MESHMAP SETTEXTURE MESHMAP=DPistol NUM=0  TEXTURE=UnrealShare.SEffect2.SmokeEffect2


// pickup version
#exec MESH IMPORT MESH=DPistolPick ANIVFILE=MODELS\dgunlo_a.3D DATAFILE=MODELS\dgunlo_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DPistolPick X=0 Y=0 Z=0 YAW=64
#exec MESH SEQUENCE MESH=DPistolPick SEQ=All  STARTFRAME=0  NUMFRAMES=1
#exec TEXTURE IMPORT NAME=DPistol1 FILE=MODELS\dgun.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=DPistolPick X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=DPistolPick NUM=1 TEXTURE=DPistol1

// 3rd person perspective version
#exec MESH IMPORT MESH=DPistol3rd ANIVFILE=MODELS\dgunlo_a.3D DATAFILE=MODELS\dgunlo_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DPistol3rd X=0 Y=-200 Z=-110 YAW=-64 ROLL=9
#exec MESH SEQUENCE MESH=DPistol3rd SEQ=All  STARTFRAME=0  NUMFRAMES=6
#exec MESH SEQUENCE MESH=DPistol3rd SEQ=Still  STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=DPistol3rd SEQ=Shoot1 STARTFRAME=0  NUMFRAMES=6
#exec TEXTURE IMPORT NAME=DPistol1 FILE=MODELS\dgun.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=DPistol3rd X=0.025 Y=0.025 Z=0.05
#exec MESHMAP SETTEXTURE MESHMAP=DPistol3rd NUM=1 TEXTURE=DPistol1

#exec AUDIO IMPORT FILE="Sounds\dispersion\Powerup3.WAV" NAME="PowerUp3" GROUP="Dispersion"
#exec AUDIO IMPORT FILE="Sounds\dispersion\DShot1.WAV" NAME="DispShot" GROUP="Dispersion"
#exec AUDIO IMPORT FILE="Sounds\dispersion\Dpickup2.WAV" NAME="DispPickup" GROUP="Dispersion"

var travel int PowerLevel;
var vector WeaponPos;
var float Count,ChargeSize;
var ChargeLight cl1,cl2;
var Sound PowerUpSound;

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return 0.05;
	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 0;
		return AIRating * (PowerLevel + 1);
	}
	
	bUseAltMode = int( FRand() < 0.3 );
	return AIRating * (PowerLevel + 1);
}

// return delta to combat style
function float SuggestAttackStyle()
{
	local float EnemyDist;
	local Inventory Inv;

	if ( !Pawn(Owner).bIsPlayer || (PowerLevel > 0) )
		return 0;

	return -0.3;
}

function bool HandlePickupQuery( inventory Item )
{
	if ( Item.IsA('WeaponPowerup') && PowerLevel<4 )
	{ 
		AmmoType.AddAmmo(AmmoType.MaxAmmo);
		Pawn(Owner).ClientMessage(Item.PickupMessage, 'Pickup');				
		Item.PlaySound (PickupSound);
		ShakeVert = Default.ShakeVert + PowerLevel;
		PowerUpSound = Item.ActivateSound;
		if ( Pawn(Owner).Weapon == self )
		{
			PowerLevel++;
			GotoState('PowerUp');
		}
		else if ( (Pawn(Owner).Weapon != Self) && !Pawn(Owner).bNeverSwitchOnPickup )
		{
			Pawn(Owner).Weapon.PutDown();
			Pawn(Owner).PendingWeapon = self;
			GotoState('PowerUp', 'Waiting');	
		}
		else PowerLevel++;
		Item.SetRespawn();
		return true;
	}
	else
		return Super.HandlePickupQuery(Item);
}

function PlayFiring()
{
	AmmoType.GoToState('Idle2');
	Owner.PlaySound(AltFireSound, SLOT_None, 1.8*Pawn(Owner).SoundDampening,,,1.2);
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);	
	if (PowerLevel==0) 
		PlayAnim('Shoot1',0.4,0.2);
	else if (PowerLevel==1) 
		PlayAnim('Shoot2',0.3,0.2);
	else if (PowerLevel==2) 
		PlayAnim('Shoot3',0.2, 0.2);
	else if (PowerLevel==3) 
		PlayAnim('Shoot4',0.1,0.2);
	else if (PowerLevel==4) 
		PlayAnim('Shoot5',0.1,0.2);
}

function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X,Y,Z;
	local MagicBullet M;
	local float Decis;
	local Projectile P;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	Decis = FRand();
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, Start, AimError, True, (3.5*FRand()-1<PowerLevel));	
	if ( PowerLevel == 0 ) 
	{
		P = Spawn(class'FatDammo',,, Start,AdjustedAim);
		if ( (AmmoType.AmmoAmount < 1) && Level.Game.bDeathMatch )
			AmmoType.AmmoAmount = 1;
	}
	else
	{
		if ( (PowerLevel==1) && AmmoType.UseAmmo(2) ) 
			P = Spawn(class'BounchyDAmmo',,, Start,AdjustedAim);
		if ( (PowerLevel==2) && AmmoType.UseAmmo(4) ) 
			P = Spawn(class'BounchyDAmmoE',,, Start,AdjustedAim);
		if ( (PowerLevel==3) && AmmoType.UseAmmo(5) ) 
			P = Spawn(class'ExpDAmmo4',,, Start ,AdjustedAim);
		if ( (PowerLevel>=4) && AmmoType.UseAmmo(6) )
		{
			M = Spawn(class'MagicBullet',,, Start,AdjustedAim);
			P = M;
			if( Decis<0.2 )
				M.Tag = 'BurnBaby';
			else if( Decis<0.4 )
				M.Tag = 'FreezySnowMen';
			else if( Decis<0.6 )
				M.Tag = 'ShakeItBaby';
			else if( Decis<0.8 )
				M.Tag = 'GoodNight';
		}
	}
	Return P;
}

function AltFire( float Value )
{
	bPointing=True;
	CheckVisibility();
	GoToState('AltFiring');
}

////////////////////////////////////////////////////////
state AltFiring
{
ignores AltFire;

	function DOFIRE()
	{
		local Projectile P;
		
		Owner.MakeNoise(Pawn(Owner).SoundDampening);
		Owner.PlaySound(AltFireSound, SLOT_None, 1.8*Pawn(Owner).SoundDampening,,,1.2);
		P = ProjectileFire(None,1000,true);
		if( P.IsA('DispersionAmmo') ) DispersionAmmo(P).bAltFire=True;
		ChargeSize+=1;
		P.DrawScale*=ChargeSize;
		P.Damage*=ChargeSize;
		Disable('Tick');
		ChargeSize=0;
	}
	function Tick( float DeltaTime )
	{
		PlayerViewOffset.X = WeaponPos.X + FRand()*ChargeSize*7;
		PlayerViewOffset.Y = WeaponPos.Y + FRand()*ChargeSize*7;
		PlayerViewOffset.Z = WeaponPos.Z + FRand()*ChargeSize*7;
		ChargeSize += DeltaTime;
		if( (pawn(Owner).bAltFire==0))
		{
			DOFIRE();
			GoToState('ShootCharge');
		}
		Count += DeltaTime;
		if (Count > 0.3) 
		{
			Count = 0.0;
			If (!AmmoType.UseAmmo(1))
			{
				DOFIRE();
				GoToState('ShootCharge');
			}
			AmmoType.GoToState('Idle2');
		}
	}
	
	Function EndState()
	{
		PlayerviewOffset = WeaponPos;
		if (cl1!=None) cl1.Destroy();
		if (cl2!=None) cl2.Destroy();
		Enable('Tick');	
	}

	function BeginState()
	{
		WeaponPos = PlayerviewOffset;	
		ChargeSize=0.0;
		Enable('Tick');	
	}

Begin:
	if (AmmoType.UseAmmo(1))
	{
		Owner.Playsound(Misc1Sound,SLOT_Misc, Pawn(Owner).SoundDampening*4.0);
		Count = 0.0;		
		Sleep(2.0 + 0.6 * PowerLevel);
		DOFIRE();
		GoToState('ShootCharge');
	}
	else GotoState('Idle');
}
state ShootCharge
{
Ignores Fire,AltFire;
Begin:
	PlayFiring();
	FinishAnim();
	Sleep(0.3);
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	Finish();
}
///////////////////////////////////////////////////////////
function PlayIdleAnim()
{
	if (PowerLevel==0) LoopAnim('Idle1',0.04,0.2);
	else if (PowerLevel==1) LoopAnim('Idle2',0.04,0.2);
	else if (PowerLevel==2) LoopAnim('Idle3',0.04,0.2);
	else if (PowerLevel==3) LoopAnim('Idle4',0.04,0.2);			
	else if (PowerLevel==4) LoopAnim('Idle5',0.04,0.2);	
}

///////////////////////////////////////////////////////
state PowerUp
{
ignores fire, altfire;

	function BringUp()
	{
		bWeaponUp = false;
		PlaySelect();
		GotoState('Powerup', 'Raising');
	}

	function bool PutDown()
	{
		bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Raising:
	FinishAnim();
	PowerLevel++;
Begin:
	if (PowerLevel<5) 
	{
		AmmoType.MaxAmmo += 10;	
		AmmoType.AddAmmo(10);
		if ( PowerLevel < 5 )
			Owner.PlaySound(PowerUpSound, SLOT_None, Pawn(Owner).SoundDampening);				
		if (PowerLevel==1)
			PlayAnim('PowerUp1',0.1, 0.05);	
		else if (PowerLevel==2) 
			PlayAnim('PowerUp2',0.1, 0.05);			
		else if (PowerLevel==3) 
			PlayAnim('PowerUp3',0.1, 0.05);					
		else if (PowerLevel==4) 
			PlayAnim('PowerUp4',0.1, 0.05);		
		FinishAnim();
		if ( bChangeWeapon )
			GotoState('DownWeapon');
		Finish();
	}
Waiting:
}


function TweenDown()
{
	if ( GetAnimGroup(AnimSequence) == 'Select' )
		TweenAnim( AnimSequence, AnimFrame * 0.4 );
	else
	{
		if (PowerLevel==0) PlayAnim('Down1', 1.0, 0.05);
		else if (PowerLevel==1) PlayAnim('Down2', 1.0, 0.05);
		else if (PowerLevel==2) PlayAnim('Down3', 1.0, 0.05);
		else if (PowerLevel==3) PlayAnim('Down4', 1.0, 0.05);	
		else if (PowerLevel==4) PlayAnim('Down5', 1.0, 0.05);	
	}
}

function TweenSelect()
{
	TweenAnim('Select1',0.001);
}

function PlaySelect()
{
	Owner.PlaySound(SelectSound, SLOT_None, Pawn(Owner).SoundDampening);
	if (PowerLevel==0) PlayAnim('Select1',0.5,0.0);
	else if (PowerLevel==1) PlayAnim('Select2',0.5,0.0);
	else if (PowerLevel==2) PlayAnim('Select3',0.5,0.0);
	else if (PowerLevel==3) PlayAnim('Select4',0.5,0.0);	
	else if (PowerLevel==4) PlayAnim('Select5',0.5,0.0);
}	

defaultproperties
{
     AmmoName=Class'UnrealShare.DefaultAmmo'
     PickupAmmoCount=50
     bCanThrow=False
     FireOffset=(X=12.000000,Y=-8.000000,Z=-15.000000)
     FireSound=Sound'UnrealShare.Dispersion.DispShot'
     AltFireSound=Sound'UnrealShare.Dispersion.DispShot'
     SelectSound=Sound'UnrealShare.Dispersion.DispPickup'
     Misc1Sound=Sound'UnrealShare.Dispersion.PowerUp3'
     PickupMessage="You got the Great DispersionPistol"
     ItemName="Great DispersionPisto"
     PlayerViewOffset=(X=3.800000,Y=-2.000000,Z=-2.000000)
     PlayerViewMesh=LodMesh'UnrealShare.DPistol'
     PlayerViewScale=1.200000
     PickupViewMesh=LodMesh'UnrealShare.DPistolPick'
     PickupViewScale=1.200000
     ThirdPersonMesh=LodMesh'UnrealShare.DPistol3rd'
     ThirdPersonScale=1.500000
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Texture=Texture'UnrealI.Skins.Silver'
     Mesh=LodMesh'UnrealShare.DPistolPick'
     DrawScale=1.200000
     bNoSmooth=False
     bMeshEnviroMap=True
     CollisionRadius=28.000000
     CollisionHeight=8.000000
}
