//=============================================================================
// HeadSquid.
//=============================================================================
class HeadSquid expands Pack6Weps;

var Actor GotActor;
var() int BiteDamage;
simulated event RenderOverlays( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) )
		return;

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		bPlayerOwner = true;
		Hand = PlayerOwner.Handedness;
	}

	if (  (Level.NetMode == NM_Client) && bPlayerOwner && (Hand == 2) )
	{
		bHideWeapon = true;
		return;
	}

	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
		Pawn(Owner).WalkBob = vect(0,0,0);

	if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash && Level.bHighDetailMode && (MFTexture != None) )
	{
		MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
		if ( !bSetFlashTime )
		{
			bSetFlashTime = true;
			FlashTime = Level.TimeSeconds + FlashLength;
		}
		else if ( FlashTime < Level.TimeSeconds )
			bMuzzleFlash = 0;
		if ( bMuzzleFlash > 0 )
		{
			if ( Hand == 0 )
				Canvas.SetPos(Canvas.ClipX/2 - MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
			else
				Canvas.SetPos(Canvas.ClipX/2 - MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - MuzzleScale * FlashS + Canvas.ClipY * FlashY);

			Canvas.Style = 3;
			Canvas.DrawIcon(MFTexture, MuzzleScale);
			Canvas.Style = 1;
		}
	}
	else
		bSetFlashTime = false;

	SetLocation( Owner.Location + CalcDrawOffset() );
	NewRot = Pawn(Owner).ViewRotation;

	if ( Hand == 0 )
		newRot.Roll = -2 * Default.Rotation.Roll;
	else
		newRot.Roll = Default.Rotation.Roll * Hand;

	newRot.Pitch+=32736;
	setRotation(newRot);
	Canvas.DrawActor(self, false);
}
function PlayIdleAnim()
{
	local float DaRand;
	
	DaRand = FRand();
	if( DaRand<0.333 )
		PlayAnim('Fighter');
	else if( DaRand<0.666 )
		PlayAnim('Swim');
	else
		PlayAnim('Turn');
}
function PlaySelect()
{
	PlayAnim('Spin',1.0,0.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);	
}
function TweenSelect()
{
	TweenAnim('Spin',0.001);
}
function TweenDown()
{
	if ( (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Spin') )
		TweenAnim( AnimSequence, AnimFrame * 0.4 );
	else
		PlayAnim('Spin', 1.0, 0.05);
}
state Idle
{
Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) AltFire(0.0);	
	Disable('AnimEnd');
	PlayIdleAnim();
	FinishAnim();
	GoTo('Begin');
}
function Fire( float Value )
{
	GotoState('NormalFire');
}
state NormalFire
{
	function Actor GetActor()
	{
		local Actor a;
		
		ForEach VisibleCollidingActors(class'Actor',A,100,Pawn(Owner).Location + 72 * Vector(Pawn(Owner).ViewRotation) + vect(0,0,1) * 15)
			if( !a.bStatic && !a.bNoDelete && a!=Owner && !a.IsA('Brush') && !a.IsA('Inventory') )
				Return a;
		Return None;
	}
	simulated function Tick(float DeltaTime)
	{
		if( GotActor!=None )
			GotActor.SetLocation(Pawn(Owner).Location + ((Pawn(Owner).CollisionRadius*2)+(GotActor.CollisionRadius*2)) * Vector(Pawn(Owner).ViewRotation) + vect(0,0,1) * 15);
	}
Begin:
	PlayAnim('Grab');
	FinishAnim();
	GotActor = GetActor();
	if( GotActor!=None )
		GotActor.SetBase(Owner);
	else Finish();
Bite:
	Owner.PlaySound(FireSound, SLOT_None,Pawn(Owner).SoundDampening*3.0,,,0.9 + 0.2 * FRand());
	GotActor.TakeDamage(BiteDamage,Pawn(Owner),Owner.Location,vect(0,0,0),'hacked');
	if( GotActor.IsA('Pawn') && Pawn(GotActor).Health<=0 )
		GoTo('Realese');
	else if( GotActor==None || GotActor.Class==None || GotActor.bDeleteMe ) GoTo('Realese');
	PlayAnim('Hold');
	FinishAnim();
	if( Pawn(Owner).bFire!=0 )
		GoTo('Bite');
Realese:
	if( GotActor!=None && GotActor.Class!=None && !GotActor.bDeleteMe )
		GotActor.SetBase(None);
	GotActor=None;
	PlayAnim('Release');
	FinishAnim();
	Finish();
}
function Finish()
{
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( Pawn(Owner).Weapon != self )
		GotoState('Idle');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}
function PlayAltFiring()
{
	PlayAnim('Release');
}
function AltFire( float Value )
{
	GotoState('AltFiring');
}
state AltFiring
{
Begin:
	FinishAnim();
	ProjectileFire(class'SquidProj',1000,true);
	PlayAltFiring();
	FinishAnim();
	Sleep(1);
	Finish();
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;

	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 2;
		return 0;
	}

	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
	if( EnemyDist<100 )
	{
		bUseAltMode = 0;
		return 2;
	}
	bUseAltMode = 2;
	return 0;
}

defaultproperties
{
     BiteDamage=35
     bOwnsCrosshair=True
     FireSound=Sound'UnrealI.Squid.hit1sq'
     AutoSwitchPriority=6
     InventoryGroup=6
     PickupMessage="You got some Squids"
     ItemName="Squids"
     PlayerViewOffset=(X=2.000000,Y=-0.700000,Z=-1.150000)
     PlayerViewMesh=LodMesh'UnrealI.Squid1'
     PlayerViewScale=0.020000
     PickupViewMesh=LodMesh'UnrealI.Squid1'
     PickupViewScale=0.300000
     ThirdPersonMesh=LodMesh'UnrealI.Squid1'
     ThirdPersonScale=0.200000
     PickupSound=Sound'UnrealI.Squid.death1sq'
     Mesh=LodMesh'UnrealI.Squid1'
     DrawScale=0.300000
}
