//=============================================================================
// HumanPawn.					ALL human pawns scripts written by .:..: !!
//=============================================================================
class HumanPawn expands ScriptedPawn
	Abstract;

var(Sounds) sound Footstep,Footstep2,Die2,Die3,Die4,ArmorImpact;
var() class<weapon> WeaponType;
var() byte HitDamage;
var() texture FireEffectTexture;
var() bool bHasFireEffect;
var() int EffectCharge;
var NonEffect Ef;
var	  Weapon myWeapon;

function TossWeapon()
{
	if ( Weapon == None )
		return;
	Weapon.FireOffset = Weapon.Default.FireOffset;
	Weapon.PlayerViewOffset = Weapon.Default.PlayerViewOffset; 
	Super.TossWeapon();
	myWeapon.Destroy();
}
function ChangedWeapon()
{
	Super.ChangedWeapon();
	bIsPlayer = false;
	bMovingRangedAttack = true;
	bHasRangedAttack = true;
}
function int GetError()
{
	Return 200;
}
function PostBeginPlay()
{
	local Sound DefP;
	Super.PostBeginPlay();
	if ( WeaponType != None )
	{
		myWeapon = Spawn(WeaponType);
		if ( myWeapon != None )
		{
			myWeapon.Instigator = Self;
			myWeapon.BecomeItem();
			AddInventory(myWeapon);
			myWeapon.BringUp();
			myWeapon.GiveAmmo(Self);
			myWeapon.SetSwitchPriority(Self);
			myWeapon.WeaponSet(Self);
			myWeapon.AimError += GetError();
			myWeapon.FireOffset = myWeapon.FireOffset * 1.5 * DrawScale;
			myWeapon.PlayerViewOffset = myWeapon.PlayerViewOffset * 1.5 * DrawScale; 
			myWeapon.SetHand(0);
		}
	}
	if(bHasFireEffect)
	{
		Ef = Spawn(class'NonEffect',Self,,Location, Rotation);
		Ef.Mesh = Mesh;
		Ef.DrawScale = Drawscale;
		Ef.SetOwner(Self);
		Ef.Texture = FireEffectTexture;
	}
}
function Destroyed()
{
	if( Ef!=None )
		Ef.Destroy();
	Super.Destroyed();
}
function PreSetMovement()
{
	MaxDesiredSpeed = 0.7 + 0.1 * skill;
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = false;
	bCanFly = false;
	MinHitWall = -0.6;
	bCanOpenDoors = true;
	if ( Intelligence > BRAINS_Mammal )
		bCanDoSpecial = true;
	bCanDuck = true;
}
function SetMovementPhysics()
{
	if ( Region.Zone.bWaterZone )
		SetPhysics(PHYS_Swimming);
	else if (Physics != PHYS_Walking)
		SetPhysics(PHYS_Walking); 
}
simulated function PlayFootStep()
{
	local sound step;
	local float decision;

	if ( FootRegion.Zone.bWaterZone )
	{
		PlaySound(sound 'LSplash', SLOT_Interact, 1, false, 1500.0, 1.0);
		return;
	}

	decision = FRand();
	if ( decision < 0.5 )
		step = Footstep;
	else
		step = Footstep2;

	if ( DesiredSpeed <= 0.5 )
		PlaySound(step, SLOT_Interact, 0.5, false, 400.0, 1.0);
	else 
		PlaySound(step, SLOT_Interact, 1, false, 1200.0, 1.0);
}

function PlayRunning()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if( Weapon != None )
	{
		if ( Weapon.Mass>20 )
			LoopAnim('RunLg');
		else
			LoopAnim('RunSm');
	}
	else LoopAnim('RunSm');
}

function PlayWalking()
{
	if( Weapon != None )
	{
		if ( Weapon.Mass>20 )
			LoopAnim('WalkLg');
		else
			LoopAnim('WalkSm');
	}
	else LoopAnim('Walk');
}

function PlayWaiting()
{
	local float Random;
	
	Random=FRand();
	if( Random<0.2 ) PlayAnim('LookL');
	else if( Random<0.4 ) PlayAnim('Taunt1');
	else if( Random<0.6 ) PlayAnim('Breath1');
	else if( Random<0.2 && Weapon != None )
	{
		PlayAnim('CockGun');
		if ( Weapon.CockingSound != None )
			PlaySound(Weapon.CockingSound, SLOT_Interact,,,700);
		else if ( Weapon.SelectSound != None )
			PlaySound(Weapon.CockingSound, SLOT_Interact,,,700);
	}
	else PlayAnim('Breath2');
}
function PlayWaitingAmbush()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if (FRand() < 0.8)
		LoopAnim('Breath2', 0.3 + 0.6 * FRand());
	else
		LoopAnim('Breath1', 0.3 + 0.6 * FRand());
}
function TweenToFighter(float tweentime)
{
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	if( Weapon!=None && Weapon.Mass>20 )
		TweenAnim('Breath1L', tweentime);
	else TweenAnim('Breath1', tweentime);
}
function PlaySwimming()
{
	if( Weapon!=None && Weapon.Mass>20 )
		LoopAnim('SwimLg', -1.0/WaterSpeed,, 0.5); 
	else
		LoopAnim('SwimSm', -1.0/WaterSpeed,, 0.5); 
}
function bool CanFireAtEnemy()
{
	local vector HitLocation, HitNormal,X,Y,Z, projStart, EnemyDir, EnemyUp;
	local actor HitActor;
	local float EnemyDist;
		
	EnemyDir = Enemy.Location - Location;
	EnemyDist = VSize(EnemyDir);
	EnemyUp = Enemy.CollisionHeight * vect(0,0,0.8);
	if ( EnemyDist > 300 )
	{
		EnemyDir = 300 * EnemyDir/EnemyDist;
		EnemyUp = 300 * EnemyUp/EnemyDist;
	}
	
	if ( Weapon == None )
		return false;
	
	GetAxes(Rotation,X,Y,Z);
	projStart = Location + Weapon.CalcDrawOffset() + Weapon.FireOffset.X * X + 1.2 * Weapon.FireOffset.Y * Y + Weapon.FireOffset.Z * Z;
	if ( Weapon.IsA('ASMD') || Weapon.IsA('Minigun') || Weapon.IsA('Rifle') ) //instant hit
		HitActor = Trace(HitLocation, HitNormal, Enemy.Location + EnemyUp, projStart, true);
	else
		HitActor = Trace(HitLocation, HitNormal, projStart + EnemyDir + EnemyUp, projStart, true);

	if ( HitActor == Enemy )
		return true;
	if ( (HitActor != None) && (VSize(HitLocation - Location) < 200) )
		return false;
	if ( (Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) > ATTITUDE_Ignore) )
		return false;

	return true;
}
function PlayPatrolStop()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	SetAlertness(0.2);
	if( Health>20 )
		LoopAnim('Breath1', 0.3 + 0.6 * FRand());
	else LoopAnim('Breath2', 0.3 + 0.6 * FRand());
}
function PlayChallenge()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if ( TryToCrouch() )
	{
		if( Weapon!=None && Weapon.Mass>20 )
			TweenAnim('DuckWlkL', 0.12);
		else TweenAnim('DuckWlkS', 0.12);
		return;
	}
	PlayWaiting();
}
function PlayMovingAttack()
{
	local float strafeMag;
	local vector Focus2D, Loc2D, Dest2D;
	local vector lookDir, moveDir, Y;
	local int bUseAltMode;

	if (Weapon != None)
	{
		if ( Weapon.AmmoType != None )
			Weapon.AmmoType.AmmoAmount = Weapon.AmmoType.Default.AmmoAmount;
		Weapon.RateSelf(bUseAltMode);
		ViewRotation = Rotation;
		if ( bUseAltMode == 0 ) 
		{
			bFire = 1;
			bAltFire = 0;
			Weapon.Fire(1.0);
		}
		else
		{
			bFire = 0;
			bAltFire = 1;
			Weapon.AltFire(1.0);
		}
	}
	else
	{
		PlayRunning();
		return;
	}

	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if( Weapon!=None && Weapon.Mass>20 )
		LoopAnim('RunLgFr', -0.9/GroundSpeed,, 0.4);
	else LoopAnim('RunSmFr', -0.9/GroundSpeed,, 0.4);
}
function PlayRangedAttack()
{
	local vector projStart;
	local vector adjust;

	if( Weapon!=None )
		PlayFiring();
	else
	{
		PlayAnim('Victory1');
		adjust = vect(0,0,0);
		adjust.Z = Target.CollisionHeight + 20;
		Acceleration = AccelRate * Normal(Target.Location - Location + adjust);
		projStart = Location - 0.5 * CollisionHeight * vect(0,0,1);
		spawn(RangedProjectile ,self,'',projStart,AdjustAim(ProjectileSpeed, projStart, 400, false, false));
	}
}

function PlayFiring()
{
	if( Weapon!=None && Weapon.Mass>20 )
		TweenAnim('StillLgFr', 0.2);
	else TweenAnim('StillSmFr', 0.2);
	if ( (Weapon != None) && (Weapon.AmmoType != None) )
		Weapon.AmmoType.AmmoAmount = Weapon.AmmoType.Default.AmmoAmount;
}
function PlayVictoryDance()
{
	PlayAnim('Victory1', 0.6, 0.1);
}
function PlayDying(name DamageType, vector HitLocation)
{
	local float Random;
	
	Random = FRand();
	PlaySound(Die, SLOT_Talk, 4 * TransientSoundVolume);
	if( Random<0.3 ) PlayAnim('Dead2', 0.7, 0.1);
	else if( Random<0.6 ) PlayAnim('Dead3', 0.7, 0.1);
	else if( Random<0.8 ) PlayAnim('Dead6', 0.7, 0.1);
	else PlayAnim('Dead7', 0.7, 0.1);
}
function PlayMeleeAttack()
{
	PlayAnim('Victory1');
	if ( MeleeDamageTarget(HitDamage, (HitDamage * 1000.0 * Normal(Target.Location - Location))) )
		PlaySound(Threaten, SLOT_Talk); //FIXME - stingdamage instead of projectile
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local Pawn aPawn;

	aPawn = Level.PawnList;
	while ( aPawn != None )
	{
		if ( aPawn.IsA('HumanPawn') && aPawn.Class == Class )
			if ( HumanPawn(aPawn).SetEnemy(Killer) )
				aPawn.GotoState('Attacking');
		aPawn = aPawn.nextPawn;
	}
	bIsPlayer = false;
	Super.Died(Killer,damageType,HitLocation);
}
function bool SetEnemy( Pawn NewEnemy )
{
	Return SetRealEnemy(NewEnemy,Self,'Waiting','Attacking');
}
function bool SetRealEnemy( Pawn NewEnemy, Pawn Hater, name ReadyStates, name AttackState )
{
	local EAttitude Temp;
	
	if( NewEnemy==None || NewEnemy.bDeleteMe || NewEnemy.Health<=0 || NewEnemy==Self ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( !NewEnemy.bIsPlayer )
	{
		if( ScriptedPawn(Hater)!=None )
			Temp = ScriptedPawn(Hater).AttitudeToCreature(NewEnemy);
		else if( NewEnemy.Class==Hater.Class )
			Temp = ATTITUDE_Friendly;
		else Temp = ATTITUDE_Hate;
	}
	else Temp = Hater.AttitudeToPlayer;
	
	if( Temp~=ATTITUDE_Friendly || Temp~=ATTITUDE_Follow || (Temp~=ATTITUDE_Ignore && FRand()<0.6) )
		Return False;
	if( ScriptedPawn(Hater)!=None && ScriptedPawn(Hater).OldEnemy!=NewEnemy )
		ScriptedPawn(Hater).OldEnemy=NewEnemy;
	Hater.Enemy = NewEnemy;
	if( !IsInState('Attacking') && !IsInState('RangedAttack') && !IsInState('MeleeAttack') 
	 && !IsInState('TakeHit') && !IsInState('FallingState') && !IsInState('Hunting')
	 && !IsInState('TacticalMove') )
		Hater.GoToState(AttackState);
	if( NewEnemy.bIsPlayer && ScriptedPawn(Hater)!=None && !ScriptedPawn(Hater).bFirstHatePlayer
	 && (ScriptedPawn(Hater).FirstHatePlayerEvent != '') )
		ScriptedPawn(Hater).TriggerFirstHate();
	Return True;
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int TheDamage;
	
	TheDamage = Damage;
	if( Ef!=None && Default.EffectCharge>0 )
	{
		TheDamage-=EffectCharge;
		if( TheDamage<0 ) TheDamage=0;
		EffectCharge-=Damage;
		Ef.Fatness = 255;
		PlaySound(ArmorImpact, SLOT_None, 2.7);
		if ( EffectCharge<=0 ) Ef.Destroy();
	}
	if ( !bIsPlayer && Inventory!=None )
		Super.TakeDamage(Inventory.ReduceDamage(TheDamage, DamageType, HitLocation),
		instigatedBy,hitlocation,momentum,damageType);
	else Super.TakeDamage(TheDamage,instigatedBy,hitlocation,momentum,damageType);
}
function bool CheckVisibleEnemys()
{
	local Pawn P;
	local vector HitL,HitN;
	local Actor TraceActor;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( VSize(P.Location-Location)<3000 && FlockPawn(P)==None &&
		 FlockMasterPawn(P)==None && P.Health>0 && !P.bHidden )
		{
			TraceActor = Trace(HitL,HitN,P.Location,Location);
			if( (TraceActor==P || TraceActor==None) && SetEnemy(P) )
				Return True;
		}
	}
	Return false;
}

defaultproperties
{
     footstep=Sound'UnrealShare.Female.stwalk1'
     Footstep2=Sound'UnrealShare.Female.stwalk2'
     Die2=Sound'UnrealShare.Male.MDeath3'
     Die3=Sound'UnrealShare.Male.MDeath3'
     Die4=Sound'UnrealShare.Male.MDeath4'
     ArmorImpact=Sound'UnrealShare.Pickups.Sbelthe2'
     CarcassType=Class'UnrealI.MaleTwoCarcass'
     Aggressiveness=0.500000
     RefireRate=0.500000
     bHasRangedAttack=True
     bMovingRangedAttack=True
     Fear=Sound'UnrealShare.Male.MDrown1'
     Roam=Sound'UnrealShare.Generic.Land1'
     Threaten=Sound'UnrealShare.Male.MUWHit1'
     bCanStrafe=True
     MeleeRange=40.000000
     GroundSpeed=400.000000
     AirSpeed=400.000000
     AccelRate=2048.000000
     UnderWaterTime=20.000000
     Intelligence=BRAINS_HUMAN
     HitSound1=Sound'UnrealShare.Male.MInjur1'
     HitSound2=Sound'UnrealShare.Male.MInjur2'
     Die=Sound'UnrealShare.Male.MDeath1'
     CombatStyle=0.300000
     DrawType=DT_Mesh
     Skin=Texture'UnrealShare.Skins.Ash'
     Mesh=LodMesh'UnrealI.Male2'
     CollisionRadius=17.000000
     CollisionHeight=39.000000
     Buoyancy=99.000000
}
