//=============================================================================
// IceEffect.
//=============================================================================
class IceEffect expands FireEffect;

function HurtRadius2( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local actor Victims,A;
	local BurningThing bt;
	local pawn OtherPawn;
	local IceThing IT;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Actor', Victims, DamageRadius, HitLocation )
	{
		if( (Victims.IsA('Decoration') || Victims.IsA('Pawn')) && Victims != self && Victims != Owner &&
		 !Victims.IsA('IceThing') && !Victims.bStatic && !Victims.bNoDelete )
		{
			if( Victims.bIsPawn && Pawn(Victims).FindInventoryType(class'ElemSuit')!=None )
				GoTo 'GoGo1';
			if( Victims.IsA('Pawn') && Level.game.ReduceDamage(10,'None',Pawn(Victims),Pawn(Owner))>0 )
			{
				if( Pawn(Victims).bIsPlayer )
				{
					if( Victims.Event != '' )
						foreach AllActors( class 'Actor', A, Event )
							A.Trigger(Pawn(Victims),Pawn(Owner));
					level.game.Killed(Pawn(Owner),Pawn(Victims),'Frozen');
					IT = Pawn(Victims).Spawn(class'IceThing');
					IT.SetCollisionSize(Victims.CollisionRadius,Victims.CollisionHeight);
					IT.DrawScale = Victims.DrawScale;
					IT.Mesh = Victims.Mesh;
					IT.DrawScale = Victims.DrawScale;
					IT.AnimSequence = Victims.AnimSequence;
					IT.AnimFrame = Victims.AnimFrame;
					Pawn(Victims).HidePlayer();
					Pawn(Victims).ClientDying('Frozen',Location);
					Pawn(Victims).Health=0;
					Pawn(Victims).GotoState('Dying');
					Level.Game.DiscardInventory(Pawn(Victims));
					if( Victims.IsA('PlayerPawn') )
						PlayerPawn(Victims).ClientFlash(20000,vect(10000,10000,10000));
				}
				else
				{
					if( Victims.Event != '' )
						foreach AllActors( class 'Actor', A, Event )
							A.Trigger(Pawn(Victims),Pawn(Owner));
					level.game.Killed(Pawn(Owner),Pawn(Victims),'Frozen');
					IT = Pawn(Victims).Spawn(class'IceThing');
					IT.SetCollisionSize(Victims.CollisionRadius,Victims.CollisionHeight);
					IT.DrawScale = Victims.DrawScale;
					IT.Mesh = Victims.Mesh;
					IT.DrawScale = Victims.DrawScale;
					IT.AnimSequence = Victims.AnimSequence;
					IT.AnimFrame = Victims.AnimFrame;
					Level.Game.DiscardInventory(Pawn(Victims));
					Pawn(Victims).Destroy();
				}
			}
			else if( !Victims.IsA('Pawn') )
			{
				IT = Victims.Spawn(class'IceThing');
				IT.SetCollisionSize(Victims.CollisionRadius,Victims.CollisionHeight);
				IT.DrawScale = Victims.DrawScale;
				IT.Mesh = Victims.Mesh;
				IT.DrawScale = Victims.DrawScale;
				IT.AnimSequence = Victims.AnimSequence;
				IT.AnimFrame = Victims.AnimFrame;
				Victims.Destroy();
			}
			GoGo1:
		}
	}
	foreach VisibleActors( class 'BurningThing', bt, DamageRadius, HitLocation )
		bt.Destroy();
	bHurtEntry = false;
}

defaultproperties
{
     Texture=FireTexture'Pack6.IceEffect'
     SoundRadius=83
     AmbientSound=Sound'AmbOutside.Looping.wind31'
     LightHue=170
     LightSaturation=69
}
