//=============================================================================
// InstantGib.
//=============================================================================
class InstantGib expands AirRifle;

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector SmokeLocation,DVector;
	local rotator SmokeRotation;
	local float NumPoints;
	local int i;

	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}

	SmokeLocation = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * 3.3 * Y + FireOffset.Z * Z * 3.0;
	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/70.0;
	SmokeLocation += DVector/NumPoints;
	SmokeRotation = rotator(HitLocation-Owner.Location);
	if (NumPoints>15) NumPoints=15;
	if ( NumPoints>1.0 ) SpawnEffect(DVector, NumPoints, SmokeRotation, SmokeLocation);
	 
	Spawn(class'ReallyFatRing',,, HitLocation+HitNormal*8,rotator(HitNormal));

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
		Other.TakeDamage(999999999, Pawn(Owner), HitLocation, 50000.0*X, 'jolted');
}
function SpawnEffect(Vector DVector, int NumPoints, rotator SmokeRotation, vector SmokeLocation)
{
	local SmokeExp Smoke;
	
	Smoke = Spawn(class'SmokeExp',,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints;
}
function PlayFiring()
{
	Owner.PlaySound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 0.2,0.05);
}

defaultproperties
{
     AmmoName=Class'Pack6.InstantAmmo'
     PickupMessage="You got the Instant Gib"
     ItemName="Instant Gib"
     Style=STY_Normal
     Texture=None
     bMeshEnviroMap=False
     MultiSkins(1)=Texture'UnrealShare.Skins.ASC1'
}
