//=============================================================================
// LaserMine.
//=============================================================================
class LaserMine expands MotionMine;

var TheLaser LaserSight;
var vector EndLaser,TheCounted,Counted2;

state Activated  // Delete from inventory and toss in front of player.
{
	function HitWall( vector HitNormal, actor Wall )
	{
		local Actor HitA;
		local vector HitN,HitL;
		
		SetRotation(rotator(HitNormal));
		PlaySound(Sound'UnrealShare.Eightball.GrenadeFloor', SLOT_Misc);
		bReady = True;
		bBounce = False;
		SetPhysics(PHYS_None);
		TheCounted = Location+HitNormal*5000;
		Counted2 = Location+HitNormal*10;
		HitA = Trace(HitL,HitN,TheCounted,Counted2);
		if( HitA!=None )
			EndLaser = HitL;
		else EndLaser = TheCounted;
		GoToState('OnGuard');
	}
	function Bump( Actor Other );
	function Touch( Actor Other );
}
State OnGuard
{
	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
					Vector momentum, name damageType)
	{
		if (bDamaged) Return;
		bDamaged = True;
		HurtPPL();
		Destroy();
	}
	function Tick( float Delt )
	{
		local Actor HitA;
		local vector HitN,HitL;
		
		HitA = Trace(HitL,HitN,TheCounted,Counted2,True);

		if( HitA!=Level && Brush(HitA)==None )
			TakeDamage(10,None, Vect(0,0,0), Vect(0,0,0), 'Detonated');
	}
	function HitWall( vector HitNormal, actor Wall );
	function Bump( Actor Other );
	function Touch( Actor Other );
Begin:
	Enable('Touch');
	SetCollision(true,false,false);
	LaserSight = Spawn(class'TheLaser',,,(EndLaser-Location)/2+Location,rotator(EndLaser-Location));
	if( LaserSight!=None )
		LaserSight.DrawScale = VSize(EndLaser-Location)/60;
	Enable('Tick');
}
function Destroyed()
{
	if( LaserSight!=None )
		LaserSight.Destroy();
	Super.Destroyed();
}
auto state Pickup
{
	function BeginState()
	{
		local Actor HitA;
		local vector HitN,HitL;
		
		Super.BeginState();
		if( bIsActivatedAtStart )
		{
			bFirstTick=True;
			SetTimer(1,true);
			bReady = True;
			SetPhysics(PHYS_None);
			TheCounted = Location+vector(Rotation)*5000;
			Counted2 = Location+vector(Rotation)*10;
			HitA = Trace(HitL,HitN,TheCounted,Counted2);
			if( HitA!=None )
				EndLaser = HitL;
			else EndLaser = TheCounted;
			GoToState('OnGuard');
		}
	}
}

defaultproperties
{
     bCanHaveMultipleCopies=False
     PickupMessage="You found a Laser Mine"
     ItemName="Laser Mine"
     PickupViewMesh=Mesh'Pack6.LaserMineMesh'
     PickupViewScale=0.200000
     Icon=Texture'Pack6.ProxGrenIcon'
     Texture=Texture'UnrealI.Skins.JBlob1'
     Skin=Texture'UnrealI.Skins.JBlob1'
     Mesh=Mesh'Pack6.LaserMineMesh'
     DrawScale=0.200000
     bMeshEnviroMap=False
     MultiSkins(0)=Texture'UnrealI.Skins.JIntroShip1'
     MultiSkins(1)=Texture'UnrealI.Skins.JBlob1'
     CollisionRadius=4.000000
     CollisionHeight=4.000000
}
