//=============================================================================
// LifeEffect.
//=============================================================================
class LifeEffect expands FireEffect;

var float Count;

simulated function Tick(float DeltaTime)
{
	HurtRadius2(0,200,'Turned',1000,Location);
	Count+=DeltaTime;
	if( Count>=20 ) Destroy();
}
function HurtRadius2( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local actor Victims;
	local float damageScale, dist;
	local vector dir;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Actor', Victims, DamageRadius, HitLocation )
	{
		if( Victims.bIsPawn && Pawn(Victims).FindInventoryType(class'ParalSuit')!=None )
			GoTo 'GoGo1';
		if( Victims != self && Victims != Owner && !Victims.IsA('Projectile') )
		{
			dir = Victims.Location - HitLocation;
			dist = FMax(1,VSize(dir));
			dir = dir/dist; 
			damageScale = 1 - FMax(0,(dist - Victims.CollisionRadius)/DamageRadius);
			Victims.TakeDamage
			( damageScale * DamageAmount,Pawn(Owner),Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,
			(damageScale * Momentum * dir), DamageName );
		}
		else if( Victims != self && Victims != Owner && Victims.IsA('Projectile') && Victims.Instigator!=Owner )
		{
			Victims.Instigator=Pawn(Owner);
			Victims.SetRotation(Victims.Rotation*-1);
			Victims.Velocity *= -1;
		}
		GoGo1:
	}
	bHurtEntry = false;
}

defaultproperties
{
     Physics=PHYS_Trailer
     RemoteRole=ROLE_SimulatedProxy
     Texture=FireTexture'UnrealShare.Belt_fx.Damage.Damage'
     DrawScale=10.000000
     bOwnerNoSee=True
     SoundRadius=32
     SoundVolume=128
     AmbientSound=Sound'Ambancient.Looping.achant5'
     LightHue=139
     LightSaturation=69
     LightRadius=51
}
