//=============================================================================
// MagicBullet.							// Gives a random status
//=============================================================================
class MagicBullet expands DispersionAmmo;

simulated function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);
	
	if ( Physics == PHYS_None )
	{
		if( LightHue>0 )
			LightHue-=1;
		else
			LightHue=255;
		if( LightSaturation<255 )
			LightSaturation+=3;
		else
			LightSaturation=0;
	}
}
simulated function ProcessTouch (Actor Other, vector HitLocation)
{
	local BurningThing B;
	local ParalyseThing P;
	local bool bNoShit;
	local actor a;
	local IceThing IT;
	If (Other!=Instigator  && DispersionAmmo(Other)==None)
	{
		bExploded = ( Other.IsA('Pawn') && !Level.bHighDetailMode );
		if ( Role == ROLE_Authority )
			Other.TakeDamage( Damage, instigator, HitLocation, MomentumTransfer*Vector(Rotation), 'exploded');	
		Explode(HitLocation, vect(0,0,1));
		if( Tag=='BurnBaby' )
		{
			if( Other.bIsPawn && Pawn(Other).FindInventoryType(class'ElemSuit')!=None )
				GoTo 'GoGo1';
			ForEach AllActors(class'BurningThing',B)
				if( Other==B.Owner )
					bNoShit=True;
			if( !bNoShit )
			{
				B = Spawn(class'BurningThing');
				B.SetOwner(Other);
				B.Burner = Instigator;
				B.Heat=30;
				B.PreBeginPlay();
			}
			GoGo1:
		}
		else if( Tag=='FreezySnowMen' )
		{
			if( Other.bIsPawn && Pawn(Other).FindInventoryType(class'ElemSuit')!=None )
				GoTo 'GoGo2';
			if( Other.IsA('Pawn') )
			{
				Pawn(Other).Health=0;
				if( Pawn(Other).bIsPlayer )
				{
					if( Other.Event != '' )
						foreach AllActors( class 'Actor', A, Event )
							A.Trigger(Pawn(Other),Instigator);
					level.game.Killed(Instigator,Pawn(Other),'Frozen');
					IT = Pawn(Other).Spawn(class'IceThing');
					IT.SetCollisionSize(Other.CollisionRadius,Other.CollisionHeight);
					IT.DrawScale = Other.DrawScale;
					IT.Mesh = Other.Mesh;
					IT.DrawScale = Other.DrawScale;
					IT.AnimSequence = Other.AnimSequence;
					IT.AnimFrame = Other.AnimFrame;
					Pawn(Other).HidePlayer();
					Pawn(Other).ClientDying('Frozen',Location);
					Pawn(Other).GotoState('Dying');
					Level.Game.DiscardInventory(Pawn(Other));
					if( Other.IsA('Other') )
						PlayerPawn(Other).ClientFlash(20000,vect(10000,10000,10000));
				}
				else
				{
					if( Other.Event != '' )
						foreach AllActors( class 'Actor', A, Event )
							A.Trigger(Pawn(Other),Instigator);
					level.game.Killed(Instigator,Pawn(Other),'Frozen');
					IT = Pawn(Other).Spawn(class'IceThing');
					IT.SetCollisionSize(Other.CollisionRadius,Other.CollisionHeight);
					IT.DrawScale = Other.DrawScale;
					IT.Mesh = Other.Mesh;
					IT.DrawScale = Other.DrawScale;
					IT.AnimSequence = Other.AnimSequence;
					IT.AnimFrame = Other.AnimFrame;
					Level.Game.DiscardInventory(Pawn(Other));
					Other.Destroy();
				}
			}
			else
			{
				IT = Other.Spawn(class'IceThing');
				IT.SetCollisionSize(Other.CollisionRadius,Other.CollisionHeight);
				IT.DrawScale = Other.DrawScale;
				IT.Mesh = Other.Mesh;
				IT.DrawScale = Other.DrawScale;
				IT.AnimSequence = Other.AnimSequence;
				IT.AnimFrame = Other.AnimFrame;
				Other.Destroy();
			}
			GoGo2:
		}
		else if( Other.IsA('Pawn') )
		{
			if( Other.bIsPawn && Pawn(Other).FindInventoryType(class'ParalSuit')!=None )
				GoTo 'GoGo3';
			if( Tag=='ShakeItBaby' )
			{
				ForEach AllActors(class'ParalyseThing',P)
					if( Pawn(Other)==P.Burner && !P.IsA('SleepyTime') )
						bNoShit=True;
				if( !bNoShit )
				{
					P = Spawn(class'ParalyseThing');
					P.SetOwner(Instigator);
					P.Burner = Pawn(Other);
					P.Heat=30;
				}
			}
			else if( Tag=='GoodNight' )
			{
				ForEach AllActors(class'ParalyseThing',P)
					if( Pawn(Other)==P.Burner && P.IsA('SleepyTime') )
						bNoShit=True;
				if( !bNoShit )
				{
					P = Spawn(class'SleepyTime');
					P.SetOwner(Instigator);
					P.Burner = Pawn(Other);
					P.Heat=30;
				}
			}
			GoGo3:
		}
	}
}

defaultproperties
{
     ExpSkin=Texture'UnrealShare.DBEffect.de_A00'
     speed=1500.000000
     Damage=20.000000
     Texture=FireTexture'UnrealShare.Belt_fx.Damage.Damage'
     LightHue=255
     LightSaturation=255
     LightRadius=9
}
