//=============================================================================
// MaxHealer.
//=============================================================================
class MaxHealer expands SuperHealth;

var pawn Touchers[4];
var sound DaS;

function PreBeginPlay()
{
	DaS = AmbientSound;
	AmbientSound = None;
	Super.PreBeginPlay();
}
auto state Pickup
{	
	function Touch( actor Other )
	{
		local int HealMax;
		local Pawn P;
		local int i;
			
		if ( Other.IsA('Pawn') && Pawn(Other).Health>0 ) 
		{	
			P = Pawn(Other);
			While( (Touchers[i]!=None || Touchers[i]!=P) && i<3 )
				i++;
			if( Touchers[i]==None || Touchers[i]==P )
			{
				Touchers[i]=P;
				P.bMeshEnviroMap = True;
				P.Texture = FireTexture'UnrealShare.Effect50.fireeffect50';
				P.Style = STY_Translucent;
				AmbientSound = DaS;
				if( P.Health<P.Default.Health*3 )
					P.Health+=5;
				if( P.IsA('PlayerPawn') )
					PlayerPawn(P).ClientAdjustGlow(-0.15, vect(156.25,156.25,351.625));
				SetTimer(0.5,true);
			}
		}
	}
	function Timer()
	{
		local int i;
		
		While( i<4 )
		{
			if( Touchers[i]!=None )
			{
				if( Touchers[i].Health<=0 )
					UnTouch(Touchers[i]);
				if( Touchers[i].Health<Touchers[i].Default.Health*3 )
					Touchers[i].Health+=3;
				Touchers[i].bMeshEnviroMap = True;
				Touchers[i].Texture = FireTexture'UnrealShare.Effect50.fireeffect50';
				Touchers[i].Style = STY_Translucent;
			}
			i++;
		}
	}
	function UnTouch( actor Other )
	{
		local int i;
		local Pawn P;
		
		if( Other.IsA('Pawn') )
		{
			P = Pawn(Other);
			While( i<4 )
			{
				if( Touchers[i]==P )
				{
					Touchers[i]=None;
					if( P.IsA('PlayerPawn') )
						PlayerPawn(P).ClientAdjustGlow(0.15, vect(-156.25,-156.25,-351.625));
					P.bMeshEnviroMap = P.Default.bMeshEnviroMap;
					P.Texture = P.Default.Texture;
					P.Style = P.Default.Style;
				}
				else if( Touchers[i]!=None && Touchers[i].Class==None )
					Touchers[i]=None;
				i++;
			}
			i = 0;
			While( i<4 )
			{
				if( Touchers[i]!=None )
					Return;
				i++;
			}
			AmbientSound = None;
			SetTimer(0.1,false);
		}
	}
}

defaultproperties
{
     Texture=FireTexture'UnrealShare.Effect50.fireeffect50'
     Skin=FireTexture'UnrealShare.Effect50.fireeffect50'
     SoundRadius=22
     SoundVolume=255
     AmbientSound=Sound'Ambancient.Looping.achant3'
}
