//=============================================================================
// MightyRevenge.
//=============================================================================
class MightyRevenge expands LuckyCharm;

function PostBeginPlay()
{
	local Pawn P;
	local bool bGot;
	
	Super.PostBeginPlay();
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( SayLogger(P)!=None )
		{
			bGot = True;
			Break;
		}
	}
	if( !bGot )
		Spawn(class'SayLogger');
}
function PickupFunction(Pawn Other);
function int ArmorAbsorbDamage(int Damage, name DamageType, vector HitLocation)
{
	Return Super.ArmorAbsorbDamage(Damage,DamageType,HitLocation);
}
function int ReduceDamage( int Damage, name DamageType, vector HitLocation )
{
	Return Super.ReduceDamage(Damage,DamageType,HitLocation);
}
function inventory PrioritizeArmor( int Damage, name DamageType, vector HitLocation )
{
	Return Super.PrioritizeArmor(Damage,DamageType,HitLocation );
}
function ArghEnemy( Pawn Enemy )
{
	local myRevenge DaRvg;
	local float TheScale;
	
	if( Owner!=None && Pawn(Owner)!=None )
	{
		DaRvg = Spawn(class'myRevenge',,,Owner.Location);
		if( DaRvg!=None )
		{
			TheScale = Owner.CollisionHeight/DaRvg.Default.CollisionHeight;
			DaRvg.SetCollisionSize(DaRvg.CollisionRadius*TheScale,DaRvg.CollisionHeight*TheScale);
			DaRvg.DrawScale *= TheScale;
			DaRvg.Health *= TheScale;
			DaRvg.Enemy = Enemy;
			if( Pawn(Owner).PlayerReplicationInfo!=None )
			{
				DaRvg.MenuName = Pawn(Owner).PlayerReplicationInfo.PlayerName$"'s Revenge!";
				DaRvg.ClientMessage("Don't worry, you'll get your revenge!");
			}
			else DaRvg.MenuName = GetItemName(Pawn(Owner).MenuName)$"'s Revenge!";
		}
		Destroy();
	}
}

defaultproperties
{
     PickupMessage="You found the Might Revenge of Death!"
     bIsAnArmor=False
     PickupSound=Sound'Ambancient.OneShot.scaryN2'
     Texture=Texture'UnrealShare.Skins.aPower1'
}
