//=============================================================================
// MirrorProj.
//=============================================================================
class MirrorProj expands TentacleProjectile;

auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local vector momentum;
	
		if ((MirrorTent(Other) == None) && (TentacleProjectile(Other) == None))
		{
			if ( Role == ROLE_Authority )
			{
				momentum = 10000.0 * Normal(Velocity);
				Other.TakeDamage(Damage, instigator, HitLocation, momentum, 'stung');
				Explode(HitLocation,Normal(Location - Other.Location));
			}
			Destroy();
		}
	}
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local SmallSpark2 s;
		local ParticleBurst PB;
		PlaySound(ImpactSound);
		MakeNoise(1.0);
		s = spawn(class'SmallSpark2',,,HitLocation+HitNormal*5,rotator(HitNormal*2+VRand()));
		s.RemoteRole = ROLE_None;
		PB = spawn(class'ParticleBurst',,,HitLocation+HitNormal*5,rotator(HitNormal*2+VRand()));
		PB.RemoteRole = ROLE_None;
		destroy();
	}

	function BeginState()
	{
		Velocity = Vector(Rotation) * speed;
		PlaySound(SpawnSound);
	}

Begin:
	Sleep(7.0); //self destruct after 7.0 seconds
	Explode(Location, vect(0,0,0));
	
}

defaultproperties
{
     Damage=52.000000
     ImpactSound=Sound'UnrealShare.General.SpecialExpl'
     Style=STY_Translucent
     Texture=None
     bMeshEnviroMap=True
}
