//=============================================================================
// MotionMine.
//=============================================================================
class MotionMine expands GRENADES;

var bool bReady;
var(Mines) bool bIsActivatedAtStart;

state Activated  // Delete from inventory and toss in front of player.
{
	function Timer()
	{
		if( bFirstTick )
		{
			bFirstTick=False;
			PlaySound(ActivateSound);
			SetTimer(1.0,True);
			SetCollision(true,false,false);
		}
		Charge--;
		if (Charge<=0) TakeDamage(10,None, Vect(0,0,0), Vect(0,0,0), 'Detonated');
	}
	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
					Vector momentum, name damageType)
	{
		if (bDamaged) Return;
		bDamaged = True;
		HurtPPL();
		Destroy();
	}
	function HitWall( vector HitNormal, actor Wall )
	{
		SetRotation(rotator(HitNormal)-rot(16384,0,0));
		PlaySound(Sound'UnrealShare.Eightball.GrenadeFloor', SLOT_Misc);
		bReady = True;
		SetCollisionSize(200,200);
		bBounce = False;
		SetPhysics(PHYS_None);
		SetCollision(false,false,true);
		GoToState('OnGuard');
	}
	function Bump( Actor Other );
	function Touch( Actor Other );
}
State OnGuard
{
	function Timer()
	{
		if( bFirstTick )
		{
			bFirstTick=False;
			PlaySound(ActivateSound);
			SetTimer(1.0,True);
			SetCollision(true,false,false);
		}
		if( !bIsActivatedAtStart )
		{
			Charge--;
			if (Charge<=0) TakeDamage(10,None, Vect(0,0,0), Vect(0,0,0), 'Detonated');
		}
	}
	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
					Vector momentum, name damageType)
	{
		if (bDamaged) Return;
		bDamaged = True;
		HurtPPL();
		Destroy();
	}
	function HitWall( vector HitNormal, actor Wall );
	function Bump( Actor Other )
	{
		Touch(Other);
	}
	function Touch( Actor Other )
	{
		if( !bReady || !Other.bIsPawn ) Return;
		TakeDamage(10,None, Vect(0,0,0), Vect(0,0,0), 'Detonated');
	}
Begin:
	Enable('Touch');
	SetCollision(true,false,false);
}
auto state Pickup
{
	function BeginState()
	{
		Super.BeginState();
		if( bIsActivatedAtStart && Class==Class'MotionMine' )
		{
			bFirstTick=True;
			SetTimer(1,true);
			bReady = True;
			SetCollisionSize(200,200);
			SetPhysics(PHYS_None);
			GoToState('OnGuard');
		}
	}
}

defaultproperties
{
     DamageRadius=400.000000
     DamageAmount=400
     bCanHaveMultipleCopies=True
     bActivatable=True
     bDisplayableInv=True
     bRotatingPickup=True
     PickupMessage="You found a Motion Mine"
     ItemName="Motion Mine"
     RespawnTime=20.000000
     PickupViewMesh=LodMesh'UnrealShare.UrnM'
     Charge=300
     PickupSound=Sound'UnrealShare.Pickups.GenPickSnd'
     Icon=Texture'UnrealI.Icons.I_RazorAmmo'
     bDirectional=True
     Texture=Texture'UnrealI.Skins.AAsbSuit1'
     Mesh=LodMesh'UnrealShare.UrnM'
     bMeshEnviroMap=True
     CollisionRadius=10.000000
     CollisionHeight=10.000000
}
