//=============================================================================
// NaliGod.
//=============================================================================
class NaliGod expands SeekerNali;

State GettingReady
{
Ignores SetEnemy,SeePlayer;
	
	function Killed(pawn Killer, pawn Other, name damageType)
	{
		if( Other==Enemy )
			WhatToDoNext('','');
	}
	event HearNoise( float Loudness, Actor NoiseMaker);
	function EnemyNotVisible()
	{
		GoToState('Attacking');
	}
	function EndState()
	{
		Mesh = Default.Mesh;
		SetPhysics(PHYS_Falling);
	}
	function TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		GoToState('Attacking');
	}
	function Died(pawn Killer, name damageType, vector HitLocation)
	{
		Mesh = Default.Mesh;
		SetPhysics(PHYS_Falling);
		
		Global.Died(Killer,damageType,HitLocation);
	}
Begin:
	Mesh = LodMesh'UnrealShare.NaliStatueM';
	SetPhysics(PHYS_Flying);
DoChecking:
	if( !CheckIfEnemyCanSee(Enemy) )
		GoToState('Attacking');
	Sleep(2);
	GoTo 'DoChecking';
}
function bool SetRealEnemy( Pawn NewEnemy, Pawn Hater, name ReadyStates, name AttackState )
{
	local EAttitude Temp;
	
	if( NewEnemy==None || NewEnemy.bDeleteMe || NewEnemy.Health<=0 || NewEnemy==Self ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( !NewEnemy.bIsPlayer )
	{
		if( ScriptedPawn(Hater)!=None )
			Temp = ScriptedPawn(Hater).AttitudeToCreature(NewEnemy);
		else if( NewEnemy.Class==Hater.Class )
			Temp = ATTITUDE_Friendly;
		else Temp = ATTITUDE_Hate;
	}
	else Temp = Hater.AttitudeToPlayer;
	
	if( Temp~=ATTITUDE_Friendly || Temp~=ATTITUDE_Follow || (Temp~=ATTITUDE_Ignore && FRand()<0.6) )
		Return False;
	if( ScriptedPawn(Hater)!=None && ScriptedPawn(Hater).OldEnemy!=NewEnemy )
		ScriptedPawn(Hater).OldEnemy=NewEnemy;
	Hater.Enemy = NewEnemy;
	if( !IsInState('Attacking') && !IsInState('RangedAttack') && !IsInState('MeleeAttack') 
	 && !IsInState('TakeHit') && !IsInState('FallingState') && !IsInState('Hunting')
	 && !IsInState('TacticalMove') && !IsInState('GettingReady') )
		Hater.GoToState('GettingReady');
	if( NewEnemy.bIsPlayer && ScriptedPawn(Hater)!=None && !ScriptedPawn(Hater).bFirstHatePlayer
	 && (ScriptedPawn(Hater).FirstHatePlayerEvent != '') )
		ScriptedPawn(Hater).TriggerFirstHate();
	Return True;
}
function bool CheckIfEnemyCanSee( Pawn Other )
{
	local vector Dah;
	
	if( Other.bIsPlayer )
		Dah = vector(Other.ViewRotation)*VSize(Other.Location-Location);
	else Dah = vector(Other.Rotation)*VSize(Other.Location-Location);
	Dah += Other.Location;
	Return ( VSize(Other.Location-Location)>=VSize(Dah-Location) );
}

defaultproperties
{
     hitdamage=255
     RangedProjectile=Class'Pack6.EGasBagBelch'
     Skin=Texture'UnrealShare.Skins.JNaliStatue1'
     DrawScale=0.500000
     CollisionRadius=13.000000
     CollisionHeight=24.000000
}
