//=============================================================================
// Nest.
//=============================================================================
class Nest expands Decoration;

var() int MaxAliens,MaxGuards,Health;
var(TheyNest) float TimeBetweenMakeing;
var() Sound CryoOpen,CryoClose;
var() mesh bodyparts[8];
var int NrAlins,NrGuards;
var bool bReady;
var(TheyNest) bool bDoMaxOut;

function bool bMakeShit()
{
	local Alien A;
	
	if( NrGuards<MaxGuards )
	{
		A = Spawn(class'BioAlien',,,Location + 72 * Vector(Rotation+rot(16392,0,0)) + vect(0,0,1) * 15 );
		if( A!=None )
		{
			A.Ohw=Self;
			A.bGuard=True;
			NrGuards++;
			Return true;
		}
	}
	else if( NrAlins<MaxAliens )
	{
		A = Spawn(class'Alien',,,Location + 72 * Vector(Rotation+rot(16392,0,0)) + vect(0,0,1) * 15 );
		if( A!=None )
		{
			A.Ohw=Self;
			NrAlins++;
			return true;
		}
	}
	return false;
}
state() TheyNest
{
Begin:
	PlayAnim('Close',0.4);
	PlaySound(CryoClose,SLOT_Misc,1.0);
	FinishAnim();
TryAgain:
	Sleep(TimeBetweenMakeing);
	if( NrAlins>=MaxAliens && NrGuards>=MaxGuards ) GoTo('TryAgain');
	PlayAnim('Open',0.4);
	PlaySound(CryoOpen,SLOT_Misc,1.0);
	FinishAnim();
DoAgain:
	bMakeShit();
	Sleep(0.25);
	if( NrAlins>=MaxAliens ) bDoMaxOut=False;
	if( bDoMaxOut ) GoTo('DoAgain');
	GoTo('Begin');
}
state() TriggerNest
{
	function Trigger( actor Other, pawn EventInstigator )
	{
		if( bReady ) GoToState('TriggerNest','DoIt');
	}
Begin:
	bReady=False;
	PlayAnim('Close',0.4);
	PlaySound(CryoClose,SLOT_Misc,1.0);
	FinishAnim();
	bReady=True;
	GoTo('End');
DoIt:
	if( NrAlins>=MaxAliens && NrGuards>=MaxGuards ) GoTo('End');
	bReady=False;
	PlayAnim('Open',0.4);
	PlaySound(CryoOpen,SLOT_Misc,1.0);
	FinishAnim();
	bMakeShit();
	Sleep(1);
	GoTo('Begin');
End:
}
function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	Spawn(class'BloodSpurt',,,HitLocation,rot(16384,0,0));
	Instigator = InstigatedBy;
	if ( Instigator != None )
		MakeNoise(1.0);
	bBobbing = false;
	Health -= NDamage;
	if (Health <=0) 	
		Broke();
}
function Broke()
{
	local CreatureChunks carc;
		
	if (bHidden)
		return;
	if ( bodyparts[0] != None )
		carc = Spawn(class 'CreatureChunks',,, Location * CollisionHeight * vect(0,0,1)); 
	if (carc != None)
	{
		carc.TrailSize = 0.5;
		carc.Mesh = bodyparts[0];
		carc.bMasterChunk = true;
		carc.Initfor(self);
	}
	GibSound();
	Destroy();
}
Event Destroyed()
{
	local Alien A;
	
	ForEach AllActors(class'Alien',A)
	{
		if( A.Ohw==Self )
		{
			A.Ohw=None;
			A.bGuard=False;
		}
	}
	Super.Destroyed();
}
function GibSound()
{
	local float decision;

	decision = FRand();
	if (decision < 0.2)
		PlaySound(sound'Gib1', SLOT_Interact, 0.06 * Mass);
	else if ( decision < 0.35 )
		PlaySound(sound'Gib2', SLOT_Interact, 0.06 * Mass);
	else if ( decision < 0.5 )
		PlaySound(sound'Gib3', SLOT_Interact, 0.06 * Mass);
	else if ( decision < 0.8 )
		PlaySound(sound'Gib4', SLOT_Interact, 0.06 * Mass);
	else 
		PlaySound(sound'Gib5', SLOT_Interact, 0.06 * Mass);
}

defaultproperties
{
     MaxAliens=30
     MaxGuards=6
     Health=400
     TimeBetweenMakeing=20.000000
     CryoOpen=Sound'UnrealI.Pupae.hiss3pp'
     CryoClose=Sound'UnrealI.Pupae.bite1pp'
     bodyparts(0)=LodMesh'UnrealShare.BruteFoot'
     bodyparts(1)=LodMesh'UnrealShare.BigChunk1'
     bodyparts(2)=LodMesh'UnrealShare.BigChunk1'
     bodyparts(3)=LodMesh'UnrealShare.BrutePiece'
     bodyparts(4)=LodMesh'UnrealShare.BrutePiece'
     bodyparts(5)=LodMesh'UnrealI.GasPart'
     bodyparts(6)=LodMesh'UnrealI.GasPart'
     bodyparts(7)=LodMesh'UnrealShare.LiverM'
     bDoMaxOut=True
     bStatic=False
     bMovable=False
     Physics=PHYS_Spider
     InitialState=TheyNest
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealI.CryopodM'
     MultiSkins(0)=Texture'UnrealShare.Skins.Jgtent'
     MultiSkins(1)=Texture'UnrealShare.Skins.Jgtent'
     bCollideActors=True
     bCollideWorld=True
     bBlockPlayers=True
     bProjTarget=True
}
