//=============================================================================
//   ____    ___      ____   __    _     __
//  |\    \ |__ \    / ___\ |\ \  / /   / /|
//  \ \   / |__\ \   | \__| \ \ \/ /   / /_/
//   \ \ \   /    \  \\ \___ \ \  /\   | . \
//    \ \_\  |\___/|  \\___/||/||\ \   \\__/|
//     \|_|   \____/   \___/ |/_|\\_\   \__/				by .:..:
// Pack6.
// Press the [X] in right upper corner of this black window to close this!
//=============================================================================
class Pack6 expands Mutator
	config(Pack6);

var() config bool bChangeDropWhenKilled,bChangeContens,bReplaceFlockPawns,bReplaceNormalPawns,bReplaceBosses,bReplaceFriends,
bChangeDefaultWeapon;
var() config int AutoAddCoopBots;
var int NumBots;
var bool bFirst;
var() string Classes[17];
event PreBeginPlay()
{
	SetTimer(0.5,false);
}
function Class<Weapon> MyDefaultWeapon()
{
	if( bChangeDefaultWeapon )
		Return class'GreatDisp';
	else
		return Super.MyDefaultWeapon();
}
function Timer() //ReplaceActors
{
	local Actor A;
	local NavigationPoint PStart;
	local int Number,Number2;
	local float Decs;
	local class<Actor> AC;
	
	if( !bFirst )
	{
		Level.Game.bNoMonsters = False;
		ForEach AllActors(class'Actor',A)
		{
			if( A.LightCone==A.Default.LightCone )
			{
				DoReplace(A,FRand());
				A.LightCone=A.Default.LightCone+1;
			}
		}
		bFirst = True;
		if( AutoAddCoopBots>0 )
			SetTimer(1,true);
	}
	else
	{
		if( NumBots < AutoAddCoopBots )
		{
			PStart = Level.Game.FindPlayerStart(255,"");
			if( PStart!=None && Spawn(class'CoopBot',,,PStart.Location,PStart.Rotation)!=None )
				NumBots++;
		}
		else
		{
			SetTimer(10+FRand()*60,false);
			For( PStart=Level.NavigationPointList; PStart!=None; PStart=PStart.NextNavigationPoint )
				Number++;
			if( Number<=0 ) Return;
			Number = Rand(Number);
			For( PStart=Level.NavigationPointList; PStart!=None; PStart=PStart.NextNavigationPoint )
			{
				if( Number==Number2 )
				{
					AC = class<Actor>(DynamicLoadObject(Classes[Rand(17)], class'Class'));
					if( AC!=None )
					{
						A = Spawn(AC,,,PStart.Location,PStart.Rotation);
						Spawn(Class'ParticleBurst',,,PStart.Location);
						
						if( A!=None )
						{
							Inventory(A).RespawnTime = 0;
							A.LifeSpan = 30;
						}
						Return;
					}
				}
				Number2++;
			}
		}
	}
}
function DoReplace( Actor Other, float Decesion )
{
	local SupriceDec SD;
	if( Other.bIsPawn )
	{
		if( (Bird1(Other)!=None && bReplaceFlockPawns) || (bReplaceNormalPawns && (Fly(Other)!=None || Manta(Other)!=None)) )
		{
			if( Manta(Other)!=None && Other.Class!=Class'Manta' )
				ReplaceOther(Other,"Pack6.BigTrillionManta");
			else if( Decesion<0.1 )
				ReplaceOther(Other,"Pack6.Sphree");
			else if( Decesion<0.3 )
				ReplaceOther(Other,"Pack6.Momma");
			else if( Decesion<0.4 )
				ReplaceOther(Other,"Pack6.MagicFly");
			else if( Decesion<0.6 )
				ReplaceOther(Other,"Pack6.TrillionManta");
			else if( Decesion<0.7 )
				ReplaceOther(Other,"Pack6.TinyLord");
			else if( Decesion<0.9 )
				ReplaceOther(Other,"Pack6.WeaponFly");
			else Return;
		}
		else if( (BiterFishSchool(Other)!=None && bReplaceFlockPawns) || (bReplaceNormalPawns && (Devilfish(Other)!=None || Squid(Other)!=None)) )
		{
			if( Decesion<0.2 )
				ReplaceOther(Other,"Pack6.AttackerSquid");
			else if( Decesion<0.5 )
				ReplaceOther(Other,"Pack6.SquidFly");
			else if( Decesion<0.8 )
				ReplaceOther(Other,"UnrealI.Squid");
			else Return;
		}
		else if( Bloblet(Other)!=None && bReplaceFlockPawns )
			ReplaceOther(Other,"Pack6.Alien");
		else if( ParentBlob(Other)!=None && bReplaceFlockPawns )
			ReplaceOther(Other,"Pack6.BioAlien");
		else if( (NaliRabbit(Other)!=None && bReplaceFlockPawns) || (Brute(Other)!=None && bReplaceNormalPawns) )
		{
			if( Decesion<0.2 )
				ReplaceOther(Other,"Pack6.DeadlyMan");
			else if( Decesion<0.4 )
				ReplaceOther(Other,"Pack6.Girl");
			else if( Decesion<0.6 )
				ReplaceOther(Other,"Pack6.EvilBoy");
			else if( Decesion<0.7 )
				ReplaceOther(Other,"Pack6.RPG_Master");
			else Return;
		}
		else if( Cow(Other)!=None && bReplaceFriends )
			ReplaceOther(Other,"Pack6.FragMaster");
		else if( GiantGasbag(Other)!=None && bReplaceBosses )
			ReplaceOther(Other,"Pack6.BigMomma");
		else if( Gasbag(Other)!=None && GiantGasbag(Other)==None && bReplaceNormalPawns )
		{
			if( Decesion<0.8 )
				ReplaceOther(Other,"Pack6.Momma");
			else ReplaceOther(Other,"Pack6.DeathEye");
		}
		else if( KrallElite(Other)!=None && bReplaceNormalPawns )
			ReplaceOther(Other,"Pack6.EliteSlavery");
		else if( Krall(Other)!=None && bReplaceNormalPawns )
			ReplaceOther(Other,"Pack6.Slavery");
		else if( Mercenary(Other)!=None && bReplaceNormalPawns )
		{
			if( Decesion<0.3 )
				ReplaceOther(Other,"Pack6.Cloaker");
			else if( Decesion<0.5 )
				ReplaceOther(Other,"Pack6.ShadowTrooper");
			else if( Decesion<0.7 )
				ReplaceOther(Other,"Pack6.RPG_Master");
			else
				ReplaceOther(Other,"Pack6.BlackForce");
		}
		else if( NaliPriest(Other)!=None && bReplaceFriends )
			ReplaceOther(Other,"Pack6._Sucker");
		else if( Nali(Other)!=None && bReplaceFriends )
		{
			if( Decesion<0.5 )
				ReplaceOther(Other,"Pack6.SeekerNali");
			else ReplaceOther(Other,"Pack6.Boy");
		}
		else if( Pupae(Other)!=None && bReplaceNormalPawns )
		{
			if( Decesion<0.8 )
				ReplaceOther(Other,"Pack6.Alien");
			else
				ReplaceOther(Other,"Pack6.BioAlien");
		}
		else if( SkaarjBerserker(Other)!=None && bReplaceNormalPawns )
			ReplaceOther(Other,"Pack6.LungeHunter");
		else if( Skaarj(Other)!=None && bReplaceNormalPawns )
		{
			if( SkaarjTrooper(Other)!=None )
				if( Decesion<0.2 )
					ReplaceOther(Other,"Pack6.SkaarjHunter");
			else if( SkaarjBerserker(Other)!=None )
				ReplaceOther(Other,"Pack6.LungeHunter");
			else if( SkaarjAssassin(Other)!=None )
				if( Decesion<0.5 )
					ReplaceOther(Other,"Pack6.TraceMaster");
			else if( SkaarjScout(Other)!=None )
				if( Decesion<0.7 )
					ReplaceOther(Other,"Pack6.MadSleeper");
			else if( SkaarjLord(Other)!=None )
				if( Decesion<0.7 )
					ReplaceOther(Other,"Pack6.DizzySkaarj");
			else
			{
				if( Decesion<0.5 )
					ReplaceOther(Other,"Pack6.ASMDSkaarj");
				else if( Decesion<=0.7 )
					ReplaceOther(Other,"Pack6.BlackForce");
			}
			Return;
		}
		else if( Tentacle(Other)!=None && bReplaceNormalPawns )
		{
			if( Decesion<0.2 )
				ReplaceOther(Other,"Pack6.DeathTent");
			else if( Decesion<0.4 )
				ReplaceOther(Other,"Pack6.MirrorTent");
			else if( Decesion<0.5 )
				ReplaceOther(Other,"Pack6.CannonXXX");
			else if( Decesion<0.6 )
				ReplaceOther(Other,"Pack6.MinigunCannon");
			else if( Decesion<0.8 )
				ReplaceOther(Other,"Pack6.Boneacle");
			else
				ReplaceOther(Other,"Pack6.Barnacle");
		}
		else if( Titan(Other)!=None && bReplaceBosses )
		{
			if( Decesion<0.25 )
				ReplaceOther(Other,"Pack6.HypnoTitan");
			else if( Decesion<0.5 )
				ReplaceOther(Other,"Pack6.SlayerLord");
			else if( Decesion<0.75 )
				ReplaceOther(Other,"Pack6.TraceMaster");
			else
				ReplaceOther(Other,"Pack6.CazzinTitan");
		}
		else if( WarLord(Other)!=None && bReplaceBosses )
		{
			if( Decesion<0.5 )
				ReplaceOther(Other,"Pack6.FireDragon");
			else ReplaceOther(Other,"Pack6.GhostStalker");
		}
		else if( Queen(Other)!=None && bReplaceBosses )
			ReplaceOther(Other,"Pack6.Phantom");
	}
	else if( Inventory(Other)!=None )
	{
		if( Weapon(Other)!=None )
		{
			if( Other.IsA('ASMD') )
				ReplaceOther(Other,"Pack6.PrismGun");
			else if( Other.IsA('Automag') )
			{
				if( Decesion<0.3 )
					ReplaceOther(Other,"Pack6.ScreemMag");
				else if( Decesion<0.6 )
					ReplaceOther(Other,"Pack6.PowerPistol");
				else ReplaceOther(Other,"Pack6.AMM");
			}
			else if( Other.IsA('DispersionPistol') )
				ReplaceOther(Other,"Pack6.GreatDisp");
			else if( Other.IsA('Eightball') )
			{
				if( Decesion<0.1 )
					ReplaceOther(Other,"Pack6.MissileL");
				else ReplaceOther(Other,"Pack6.GrenTent");
			}
			else if( Other.IsA('FlakCannon') )
			{
				if( FRand()<0.5 )
					ReplaceOther(Other,"Pack6.HeadSquid");
				else ReplaceOther(Other,"Pack6.GravityKiller");
			}
			else if( Other.IsA('GESBioRifle') )
				ReplaceOther(Other,"Pack6.SlimeSlith");
			else if( Other.IsA('Minigun') )
			{
				if( Decesion<0.4 )
					ReplaceOther(Other,"Pack6.MissileL");
				else ReplaceOther(Other,"Pack6.Blaster");
			}
			else if( Other.IsA('Razorjack') )
			{
				if( Decesion<0.3 )
					ReplaceOther(Other,"Pack6.IonGun");
				else ReplaceOther(Other,"Pack6.Cracker");
			}
			else if( Other.IsA('Stinger') )
				ReplaceOther(Other,"Pack6.Uzis");
			else if( Other.IsA('Rifle') )
				ReplaceOther(Other,"Pack6.AirRifle");
		}
		else if( Pickup(Other)!=None )
		{
			if( Other.IsA('ShieldBelt') )
			{
				if( Decesion<0.15 )
					ReplaceOther(Other,"Pack6.RedBelt");
				else if( Decesion<0.3 )
					ReplaceOther(Other,"Pack6.GreenBelt");
				else if( Decesion<0.5 )
					ReplaceOther(Other,"Pack6.YellowBelt");
				else if( Decesion<0.7 )
					ReplaceOther(Other,"Pack6.BlueBelt");
				else if( Decesion<0.9 )
					ReplaceOther(Other,"Pack6.SpecialBelt");
				else
					ReplaceOther(Other,"Pack6.CoffeCup");
			}
			else if( (Other.IsA('Suits') && !Other.IsA('SuitOfDoom')) || Other.IsA('Armor') )
			{
				if( Decesion<0.4 )
					ReplaceOther(Other,"Pack6.SuitOfDoom");
				else if( Decesion<0.6 )
					ReplaceOther(Other,"Pack6.ElemSuit");
				else if( Decesion<0.8 )
					ReplaceOther(Other,"Pack6.ParalSuit");
				else
					ReplaceOther(Other,"Pack6.ShadowSuit");
			}
			else if( Other.IsA('JumpBoots') )
				ReplaceOther(Other,"Pack6.WarpBoots");
			else if( Other.IsA('SuperHealth') && !Other.IsA('MaxHealer') )
				ReplaceOther(Other,"Pack6.MaxHealer");
			else if( Other.IsA('Invisibility') && !Other.IsA('Bomb') )
				ReplaceOther(Other,"Pack6.Bomb");
			else if( Other.IsA('NaliFruit') )
			ReplaceOther(Other,"Pack6.FaworPlant");
			else if( Other.IsA('RocketCan') )
			{
				if( Decesion<0.2 )
					ReplaceOther(Other,"Pack6.HeGrenade");
				else if( Decesion<0.4 )
					ReplaceOther(Other,"Pack6.FlashGrenade");
				else if( Decesion<0.5 )
					ReplaceOther(Other,"Pack6.EFlashGren");
				else if( Decesion<0.7 )
					ReplaceOther(Other,"Pack6.SmokeGrenade");
				else if( Decesion<0.8 )
					ReplaceOther(Other,"Pack6.ToxinGrenade");
				else if( Decesion<0.9 )
					ReplaceOther(Other,"Pack6.MotionMine");
				else
					ReplaceOther(Other,"Pack6.LaserMine");
			}
		}
	}
	else if( bChangeContens && Decoration(Other)!=None && !Other.bStatic && !Other.bNoDelete && SupriceDec(Other)==None )
	{
		if( thrownbody(Other)!=None )
			Other.RemoteRole = ROLE_DumbProxy;
		else
		{
			SD = Spawn(class'SupriceDec',,Other.Tag,Other.Location,Other.Rotation);
			if( SD!=None )
			{
				SD.Mesh = Other.Mesh;
				SD.Skin = Other.Skin;
				SD.Event = Other.Event;
				SD.DrawScale = Other.DrawScale;
				SD.AnimFrame = Other.AnimFrame;
				SD.AnimSequence = Other.AnimSequence;
				SD.AnimRate = Other.AnimRate;
				SD.SetCollisionSize(Other.CollisionRadius,Other.CollisionHeight);
				Other.Destroy();
			}
		}
	}
}
function ReplaceOther(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;
	local bool bN1,bN2,bN3;

	if( Other.IsA('Inventory') && !Other.IsInState('Pickup') && !Other.IsInState('Sleeping') )
		Return;
	bN1 = Other.bCollideActors;
	bN2 = Other.bBlockActors;
	bN3 = Other.bBlockPlayers;
	Other.SetCollision(false,false,false);
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
		A = Spawn(aClass,,Other.tag,Other.Location, Other.Rotation);
	if ( A != None )
	{
		if ( Other.IsA('Inventory') && Inventory(Other).MyMarker != None )
		{
			if( A.IsA('Inventory') )
			{
				Inventory(Other).MyMarker.markedItem = Inventory(A);
				if ( Inventory(A) != None )
					Inventory(A).MyMarker = Inventory(Other).MyMarker;
				Inventory(Other).MyMarker = None;
			}
		}
		A.event = Other.event;
		A.tag = Other.tag;
		A.LightCone=A.Default.LightCone+1;
		if( A.IsA('Pawn') && Other.IsA('Pawn') )
		{
			Pawn(A).AlarmTag = Pawn(Other).AlarmTag;
			Pawn(A).SharedAlarmTag = Pawn(Other).SharedAlarmTag;
			if( A.IsA('ScriptedPawn') && Other.IsA('ScriptedPawn') )
			{
				ScriptedPawn(A).TeamTag = ScriptedPawn(Other).TeamTag;
				if( ScriptedPawn(Other).Orders=='Patroling' ||
				 ScriptedPawn(Other).Orders=='Guarding' )
					ScriptedPawn(A).Orders = ScriptedPawn(Other).Orders;
				ScriptedPawn(A).OrderTag = ScriptedPawn(Other).OrderTag;
				ScriptedPawn(A).FirstHatePlayerEvent = ScriptedPawn(Other).FirstHatePlayerEvent;
			}
		}
		else if( A.IsA('Decoration') && Other.IsA('Decoration') )
		{
			Decoration(A).contents = Decoration(Other).contents;
			Decoration(A).content2 = Decoration(Other).content2;
			Decoration(A).content3 = Decoration(Other).content3;
		}
		Other.Destroy();
	}
	else
		Other.SetCollision(bN1,BN2,BN3);
}
function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local float Decs;
	
	if( Other.IsA('Pawn') && !Pawn(Other).bIsPlayer && bChangeDropWhenKilled && FRand()<0.2 )
	{
		Decs = FRand();
		if( Decs<=0.002 )
			Pawn(Other).DropWhenKilled = class'EsHole';
		else if( Decs<=0.004 )
			Pawn(Other).DropWhenKilled = class'EsIce';
		else if( Decs<=0.006 )
			Pawn(Other).DropWhenKilled = class'EsFire';
		else if( Decs<=0.008 )
			Pawn(Other).DropWhenKilled = class'EsGrav';
		else if( Decs<=0.01 )
			Pawn(Other).DropWhenKilled = class'EsLife';
		else if( Decs<=0.05 )
			Pawn(Other).DropWhenKilled = class'EsBubbel';
		else if( Decs<=0.075 )
			Pawn(Other).DropWhenKilled = class'GoodMen';
		else if( Decs<=0.1 )
			Pawn(Other).DropWhenKilled = class'LuckyCharm';
		else if( Decs<=0.2 )
			Pawn(Other).DropWhenKilled = class'BlueBelt';
		else if( Decs<=0.3 )
			Pawn(Other).DropWhenKilled = class'YellowBelt';
		else if( Decs<=0.4 )
			Pawn(Other).DropWhenKilled = class'RedBelt';
		else if( Decs<=0.5 )
			Pawn(Other).DropWhenKilled = class'GreenBelt';
		else if( Decs<=0.6 )
			Pawn(Other).DropWhenKilled = class'ZapTouch';
		else if( Decs<=0.7 )
			Pawn(Other).DropWhenKilled = class'CoffeCup';
		else if( Decs<=0.75 )
			Pawn(Other).DropWhenKilled = class'EsFireball';
		else if( Decs<=0.78 )
			Pawn(Other).DropWhenKilled = class'LastBreath';
		else if( Decs<=0.8 )
			Pawn(Other).DropWhenKilled = class'MightyRevenge';
	}
	else if( Other.IsA('Decoration') && !Other.IsA('Carcass') && bChangeContens && !Other.IsA('IceThing') && !Other.IsA('SupriceDec')
	 && FRand()<0.6 )
	{
		Decs = FRand();
		if( Decs<=0.3 )
			Decoration(Other).contents = class'DropCrap';
		else if( Decs<=0.31 )
			Decoration(Other).contents = class'EsHole';
		else if( Decs<=0.32 )
			Decoration(Other).contents = class'EsIce';
		else if( Decs<=0.33 )
			Decoration(Other).contents = class'EsFire';
		else if( Decs<=0.34 )
			Decoration(Other).contents = class'EsGrav';
		else if( Decs<=0.35 )
			Decoration(Other).contents = class'EsLife';
		else if( Decs<=0.36 )
			Decoration(Other).contents = class'EsBubbel';
		else if( Decs<=0.4 )
			Decoration(Other).contents = class'GoodMen';
		else if( Decs<=0.45 )
			Decoration(Other).contents = class'LuckyCharm';
		else if( Decs<=0.47 )
			Decoration(Other).contents = class'BlueBelt';
		else if( Decs<=0.49 )
			Decoration(Other).contents = class'YellowBelt';
		else if( Decs<=0.51 )
			Decoration(Other).contents = class'RedBelt';
		else if( Decs<=0.53 )
			Decoration(Other).contents = class'GreenBelt';
		else if( Decs<=0.58 )
			Decoration(Other).contents = class'ZapTouch';
		else if( Decs<=0.62 )
			Decoration(Other).contents = class'CoffeCup';
		else if( Decs<=0.65 )
			Decoration(Other).contents = class'LastBreath';
		else if( Decs<=0.7 )
			Decoration(Other).contents = class'MightyRevenge';
	}
	if( SupriceDec(Other)!=None )
	{
		Decs = FRand();
		if( Decs<=0.1 )
			SupriceDec(Other).ToDrop = "Pack6.DropCrap";
		else if( Decs<=0.13 )
			SupriceDec(Other).ToDrop = "Pack6.EsHole";
		else if( Decs<=0.16 )
			SupriceDec(Other).ToDrop = "Pack6.EsIce";
		else if( Decs<=0.19 )
			SupriceDec(Other).ToDrop = "Pack6.EsFire";
		else if( Decs<=0.22 )
			SupriceDec(Other).ToDrop = "Pack6.EsGrav";
		else if( Decs<=0.25 )
			SupriceDec(Other).ToDrop = "Pack6.EsLife";
		else if( Decs<=0.3 )
			SupriceDec(Other).ToDrop = "Pack6.GoodMen";
		else if( Decs<=0.35 )
			SupriceDec(Other).ToDrop = "Pack6.GoodBoy";
		else if( Decs<=0.38 )
			SupriceDec(Other).ToDrop = "Pack6.BlueBelt";
		else if( Decs<=0.41 )
			SupriceDec(Other).ToDrop = "Pack6.YellowBelt";
		else if( Decs<=0.44 )
			SupriceDec(Other).ToDrop = "Pack6.RedBelt";
		else if( Decs<=0.47 )
			SupriceDec(Other).ToDrop = "Pack6.GreenBelt";
		else if( Decs<=0.50 )
			SupriceDec(Other).ToDrop = "Pack6.BounchBelt";
		else if( Decs<=0.55 )
			SupriceDec(Other).ToDrop = "Pack6.Slavery";
		else if( Decs<=0.6 )
			SupriceDec(Other).ToDrop = "Pack6.EliteSlavery";
		else if( Decs<=0.65 )
			SupriceDec(Other).ToDrop = "Pack6._Sucker";
		else if( Decs<=0.7 )
			SupriceDec(Other).ToDrop = "Pack6.Momma";
		else if( Decs<=0.75 )
			SupriceDec(Other).ToDrop = "Pack6.DeadlyFly";
		else if( Decs<=0.8 )
			SupriceDec(Other).ToDrop = "Pack6.FaworPlant";
		else if( Decs<=0.85 )
			SupriceDec(Other).ToDrop = "Pack6.FragMaster";
		else if( Decs<=0.9 )
			SupriceDec(Other).ToDrop = "Pack6.Girl";
		else
			SupriceDec(Other).ToDrop = "Pack6.EvilBoy";
	}
	else if( GameInfo(Other)!=None ) // allways allow monsters!
		GameInfo(Other).bNoMonsters = False;
	else if( ThingFactory(Other)!=None )
	{
		Decs = FRand();
		if( ClassIsChildOf(ThingFactory(Other).Prototype,class'Brute') )
		{
			if( Decs<0.2 )
				ThingFactory(Other).Prototype = class'DeadlyMan';
			else if( Decs<0.4 )
				ThingFactory(Other).Prototype = class'Girl';
			else if( Decs<0.6 )
				ThingFactory(Other).Prototype = class'EvilBoy';
			else if( Decs<0.7 )
				ThingFactory(Other).Prototype = class'RPG_Master';
		}
		else if( ClassIsChildOf(ThingFactory(Other).Prototype,class'Fly') ||
		 ClassIsChildOf(ThingFactory(Other).Prototype,class'Manta') )
		{
			if( Decs<0.2 )
				ThingFactory(Other).Prototype = class'Momma';
			else if( Decs<0.4 )
				ThingFactory(Other).Prototype = class'MagicFly';
			else if( Decs<0.6 )
				ThingFactory(Other).Prototype = class'DeadlyFly';
			else if( Decs<0.8 )
				ThingFactory(Other).Prototype = class'TrillionManta';
			else
				ThingFactory(Other).Prototype = class'TinyLord';
		}
		else if( ClassIsChildOf(ThingFactory(Other).Prototype,class'Skaarj') )
		{
			if( Decs<0.05 )
				ThingFactory(Other).Prototype = class'SkaarjHunter';
			else if( Decs<0.2 )
				ThingFactory(Other).Prototype = class'ASMDSkaarj';
			else if( Decs<0.25 )
				ThingFactory(Other).Prototype = class'TraceMaster';
			else if( Decs<0.4 )
				ThingFactory(Other).Prototype = class'MadSleeper';
			else if( Decs<0.5 )
				ThingFactory(Other).Prototype = class'DizzySkaarj';
			else if( Decs<0.55 )
				ThingFactory(Other).Prototype = class'Cloaker';
			else if( Decs<0.7 )
				ThingFactory(Other).Prototype = class'DeadlyMan';
			else if( Decs<0.9 )
				ThingFactory(Other).Prototype = class'EvilBoy';
			else
				ThingFactory(Other).Prototype = class'ShadowTrooper';
		}
		else if( ClassIsChildOf(ThingFactory(Other).Prototype,class'Titan') )
		{
			if( Decs<0.3 )
				ThingFactory(Other).Prototype = class'HypnoTitan';
			else
				ThingFactory(Other).Prototype = class'CazzingTitan';
		}
	}
	return true;
}

defaultproperties
{
     bChangeDropWhenKilled=True
     bChangeContens=True
     bReplaceFlockPawns=True
     bReplaceNormalPawns=True
     bReplaceBosses=True
     bReplaceFriends=True
     bChangeDefaultWeapon=True
     AutoAddCoopBots=2
     Classes(0)="Pack6.EsBubbel"
     Classes(1)="Pack6.EsFire"
     Classes(2)="Pack6.EsFireball"
     Classes(3)="Pack6.EsGrav"
     Classes(4)="Pack6.EsHole"
     Classes(5)="Pack6.EsIce"
     Classes(6)="Pack6.EsLife"
     Classes(7)="Pack6.CoffeCup"
     Classes(8)="Pack6.CloakDrink"
     Classes(9)="Pack6.LuckyCharm"
     Classes(10)="Pack6.LastBreath"
     Classes(11)="Pack6.MightyRevenge"
     Classes(12)="Pack6.BounchBelt"
     Classes(13)="Pack6.ScrewBelt"
     Classes(14)="Pack6.SpecialBelt"
     Classes(15)="Pack6.SkaarjRain"
     Classes(16)="Pack6.UltimateBox"
}
