//=============================================================================
// Pack6Belts.
//=============================================================================
class Pack6Belts expands Pickup
	abstract;

#exec AUDIO IMPORT FILE="Sounds\Pickups\SBELTA1.WAV"  NAME="BeltSnd"       GROUP="Pickups"
#exec AUDIO IMPORT FILE="Sounds\Pickups\pSBELTA2.WAV"  NAME="PSbelta2"       GROUP="Pickups"
#exec AUDIO IMPORT FILE="Sounds\Pickups\SBELThe2.WAV"  NAME="Sbelthe2"       GROUP="Pickups"

#exec TEXTURE IMPORT NAME=I_ShieldBelt FILE=TEXTURES\HUD\i_belt.PCX GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=GoldSkin FILE=models\gold.PCX GROUP="None"
#exec TEXTURE IMPORT NAME=RedSkin FILE=MODELS\ChromR.PCX GROUP=Skins FLAGS=2 // skin
#exec TEXTURE IMPORT NAME=BlueSkin FILE=MODELS\ChromB.PCX GROUP=Skins FLAGS=2 // skin

#exec MESH IMPORT MESH=ShieldBeltMesh ANIVFILE=MODELS\belt_a.3D DATAFILE=MODELS\belt_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ShieldBeltMesh X=0 Y=120 Z=110 YAW=64
#exec MESH SEQUENCE MESH=ShieldBeltMesh SEQ=All    STARTFRAME=0  NUMFRAMES=1
#exec TEXTURE IMPORT NAME=Abelt1 FILE=MODELS\belt.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=ShieldBeltMesh X=0.025 Y=0.025 Z=0.05
#exec MESHMAP SETTEXTURE MESHMAP=ShieldBeltMesh NUM=1 TEXTURE=Abelt1

#exec OBJ LOAD FILE=..\Textures\Belt_fx.utx PACKAGE=Unrealshare.Belt_fx

var ShieldBeltEffect MyEffect;
var() texture TeamFireTexture;
var() texture TeamTexture;

function ArmorImpactEffect(vector HitLocation)
{ 
	if ( Owner.IsA('PlayerPawn') )
	{
		PlayerPawn(Owner).ClientFlash(-0.05,vect(400,400,400));
	}
	if ( MyEffect != None )
	{
		//MyEffect.Texture = MyEffect.LowDetailTexture;
		MyEffect.ScaleGlow = 4.0;
		MyEffect.Fatness = 255;
		MyEffect.PlaySound(DeActivateSound, SLOT_None);
		SetTimer(0.8, true);
	}
}

function Timer()
{
	if ( MyEffect != None )
		MyEffect.Fatness = MyEffect.Default.Fatness;
	SetEffectTexture();
}

function Destroyed()
{
	SetBackToNormal();
	Super.Destroyed();
}

function PickupFunction(Pawn Other)
{
	local inventory inv2;

	for( Inv2=Other.Inventory; Inv2!=None; Inv2=Inv2.Inventory ) 
		if (Pack6Belts(Inv2)!=None && Inv2.class!=class) Inv2.Destroy();
	MyEffect = Spawn(class'SBEffect', Owner,,Owner.Location, Owner.Rotation); 
	MyEffect.Mesh = Owner.Mesh;
	MyEffect.DrawScale = Owner.Drawscale;

	SetEffectTexture();
	SetTimer(0.8, true);
}

function SetEffectTexture()
{
	if( Owner!=None && MyEffect!=None )
	{
		MyEffect.ScaleGlow = 1.0;
		MyEffect.Texture = TeamFireTexture;
		MyEffect.DrawScale = Owner.DrawScale;
		MyEffect.LightRadius = LightRadius;
		MyEffect.LightBrightness = LightBrightness;
		MyEffect.LightHue = LightHue;
		MyEffect.LightSaturation = LightSaturation;
		MyEffect.LightType = Default.LightType;
		LightType = LT_None;
		Owner.Texture = TeamTexture;
		Owner.bMeshEnviroMap = True;
		Owner.Style = STY_Normal;
		if( Owner.IsA('Pawn') && Pawn(Owner).Weapon!=None )
		{
			Pawn(Owner).Weapon.Texture = TeamTexture;
			Pawn(Owner).Weapon.bMeshEnviroMap = True;
			Pawn(Owner).Weapon.Style = STY_Normal;
		}
	}
}
function SetBackToNormal()
{
	
	if( MyEffect!=None )
		MyEffect.Destroy();
	if( Owner!=None && Owner.IsA('Pawn') )
	{
		Owner.Texture = Owner.Default.Texture;
		Owner.bMeshEnviroMap = Owner.Default.bMeshEnviroMap;
		Owner.Style = Owner.Default.Style;
		if( Owner.IsA('Pawn') && Pawn(Owner).Weapon!=None )
		{
			Pawn(Owner).Weapon.Texture = Pawn(Owner).Weapon.Default.Texture;
			Pawn(Owner).Weapon.bMeshEnviroMap = Pawn(Owner).Weapon.Default.bMeshEnviroMap;
			Pawn(Owner).Weapon.Style = Pawn(Owner).Weapon.Default.Style;
		}
	}
}
auto state Pickup
{
	function bool ValidTouch( actor Other )
	{
		local Actor A;

		if( Other.bIsPawn && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger( Other, Other.Instigator );
			return true;
		}
		return false;
	}
	function EndState()
	{
		LifeSpan = 0;
		Super.EndState();
	}
}

defaultproperties
{
     TeamFireTexture=FireTexture'UnrealShare.Belt_fx.ShieldBelt.N_Shield'
     TeamTexture=Texture'UnrealShare.Belt_fx.ShieldBelt.newgold'
     bDisplayableInv=True
     PickupMessage="You got the Shield Belt."
     ItemName="Shield Belt"
     RespawnTime=10.000000
     PickupViewMesh=LodMesh'UnrealShare.ShieldBeltMesh'
     Charge=500
     ArmorAbsorption=100
     bIsAnArmor=True
     AbsorptionPriority=10
     MaxDesireability=2.000000
     PickupSound=Sound'UnrealShare.Pickups.BeltSnd'
     DeActivateSound=Sound'UnrealShare.Pickups.Sbelthe2'
     Icon=Texture'UnrealShare.Icons.I_ShieldBelt'
     Mesh=LodMesh'UnrealShare.ShieldBeltMesh'
     CollisionRadius=20.000000
     CollisionHeight=5.000000
}
