//=============================================================================
// RocketTable.
//=============================================================================
class RocketTable expands Decoration;

var() int Health;
var() int FragChunks;
var() Float Fragsize;
var sound DaSound;
var Pawn Controller;
var vector RealPos,OldSentPos;
var PlayerPawn NetOwnerClass;
replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		Controller,RealPos;
}

Function PreBeginPlay()
{
	DaSound = AmbientSound;
	AmbientSound = None;
	SetTimer(0.2,true);
	Super.PreBeginPlay();
}
Auto State Animate
{

	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Instigator = InstigatedBy;
		if (Health<0) Return;
		if ( Instigator != None )
			MakeNoise(1.0);
		bBobbing = false;
		Health -= NDamage;
		if (Health <0) 	
			skinnedFrag(class'Fragment1',texture'JCannon1', Momentum,1.0,17); // Cannon skin
		else 
		{
			SetPhysics(PHYS_Falling);
			Momentum.Z = 1000;
			Velocity=Momentum*0.016;
		}
	}
} // Normal table functions/\
// New tables functions \/
function Timer()
{
	local Pawn p;
	local bool bFound;

	if( Level.NetMode==NM_Client ) Return;
	ForEach RadiusActors(class'Pawn',p,40,Location+vect(0,0,60))
	{
		if( P.Health>0 && P.Class!=None )
		{
			if( !bFound )
			{
				Controller = P;
				bFound=true;
			}
			P.SetBase(Self);
		}
	}
	if( bFound )
	{
		RemoteRole = ROLE_SimulatedProxy;
		Return;
	}
	RemoteRole = ROLE_DumbProxy;
	Controller = None;
}
simulated function PlayerPawn GetMyActor()
{
	local PlayerPawn P;
	
	Foreach AllActors(class'PlayerPawn',P)
		if( P.Player!=None && P.Player.Console!=None )
			Return P;
}
simulated function Tick( float DeltaTime )
{
	if( Controller!=None )
	{
		if( Level.NetMode!=NM_Client )
			RealPos=Location;
		if( AmbientSound==None && DaSound!=None )
			AmbientSound = DaSound;
		MoveNow(Controller,DeltaTime);
		if( Level.NetMode==NM_Client && NetOwnerClass==None )
			NetOwnerClass=GetMyActor();
		if( Level.NetMode==NM_Client && OldSentPos!=RealPos && NetOwnerClass!=None )
		{
			OldSentPos=RealPos;
			SetLocation(RealPos+(Velocity*0.001*NetOwnerClass.PlayerReplicationInfo.Ping));
		}
		if( Level.NetMode==NM_Client )
			Controller.SetLocation(Location+vect(0,0,60));
	}
	else if( Controller==None )
	{
		if( AmbientSound!=None )
			AmbientSound = None;
		if( Physics!=PHYS_Falling )
			SetPhysics(PHYS_Falling);
	}
}
simulated function MoveNow( Pawn Other , float DT )
{
	SetPhysics(PHYS_Falling);
	Velocity.Z += 1500*DT;
}

defaultproperties
{
     Health=300
     FragChunks=12
     Fragsize=1.000000
     bStatic=False
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealI.Table1'
     MultiSkins(0)=Texture'UnrealI.Skins.JCannon1'
     MultiSkins(1)=Texture'UnrealI.Skins.JCannon1'
     AmbientSound=Sound'UnrealShare.General.Brufly1'
     CollisionRadius=45.000000
     CollisionHeight=19.000000
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
}
