//=============================================================================
// SBEffect.
//=============================================================================
class SBEffect expands ShieldBeltEffect;

simulated function Destroyed()
{
	Super(Actor).Destroyed();
}

simulated function PostBeginPlay()
{
	if ( !Level.bHighDetailMode && ((Level.NetMode == NM_Standalone) || (Level.NetMode == NM_Client)) )
	{
		Timer();
		bHidden = true;
		SetTimer(1.0, true);
	}
}

simulated function Timer()
{
	bHidden = true;
}

simulated function Tick(float DeltaTime)
{
	if ( Fatness > Default.Fatness )
		Fatness = Max(Default.Fatness, Fatness - 130 * DeltaTime );
	if ( Owner != None )
		if ( bHidden != Owner.bHidden )
			bHidden = Owner.bHidden;
}

defaultproperties
{
}
