//=============================================================================
// SeekerGrenade.
//=============================================================================
class SeekerGrenade expands Grenade;

var int TimeForBreak;
simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	Super.PostBeginPlay();
	if ( Level.NetMode != NM_DedicatedServer )
		PlayAnim('WingIn');
	SetTimer(1+FRand()*0.5,true);                  //Grenade begins unarmed

	if ( Role == ROLE_Authority )
	{
		GetAxes(Instigator.ViewRotation,X,Y,Z);	
		Velocity = X * (Instigator.Velocity Dot X)*0.4 + Vector(Rotation) * (Speed +
			FRand() * 100);
		Velocity.z += 210;
		RandRot.Pitch = FRand() * 1400 - 700;
		RandRot.Yaw = FRand() * 1400 - 700;
		RandRot.Roll = FRand() * 1400 - 700;
		MaxSpeed = 1000;
		Velocity = Velocity >> RandRot;
		RandSpin(50000);	
		bCanHitOwner = False;
		if (Instigator.HeadRegion.Zone.bWaterZone)
		{
			bHitWater = True;
			Velocity=0.6*Velocity;			
		}
	}	
}

simulated function BeginPlay()
{
	if (Level.bHighDetailMode) SmokeRate = 0.03;
	else SmokeRate = 0.15;
}

simulated function ZoneChange( Zoneinfo NewZone )
{
	local waterring w;
	
	if (!NewZone.bWaterZone || bHitWater) Return;

	bHitWater = True;
	w = Spawn(class'WaterRing',,,,rot(16384,0,0));
	w.DrawScale = 0.2;
	w.RemoteRole = ROLE_None;
	Velocity=0.6*Velocity;
}

simulated function Timer()
{
	local pawn Victims,ClosestPawn;
	local float thisDist,ClosestDistance;

	ClosestDistance = 100000;
	ClosestPawn = None;	

	//FIXME - use the pawnlist for this
	TimeForBreak++;
	if( TimeForBreak>15 )
		Explosion(Location);
	if( Velocity==vect(0,0,0) )
		Explosion(Location);
	foreach VisibleCollidingActors( class'Pawn', Victims, 2000.0 )
	{
		if( Victims.Class!=Instigator.Class )
		{
			thisDist = VSize(Victims.Location - Location); 
			if ( thisDist < ClosestDistance) 
			{
				ClosestPawn = Victims;
				ClosestDistance = thisDist;
			}
		}	
	}
	if( ClosestPawn!=None )
	{
		Velocity = ClosestPawn.Location-Location;
		if( Location.Z<ClosestPawn.Location.Z )
			Velocity.Z = ClosestDistance;
	}
}

simulated function Tick(float DeltaTime)
{
	local BlackSmoke b;

	if (bHitWater) 
	{
		Disable('Tick');
		Return;
	}
	Count += DeltaTime;
	if ( (Count>Frand()*SmokeRate+SmokeRate+NumExtraGrenades*0.03) && (Level.NetMode!=NM_DedicatedServer) ) 
	{
		b = Spawn(class'BlackSmoke');
		b.RemoteRole = ROLE_None;		
		Count=0;
	}
}

simulated function Landed( vector HitNormal )
{
	HitWall( HitNormal, None );
}

simulated function ProcessTouch( actor Other, vector HitLocation )
{
	if ( (Other!=instigator) || bCanHitOwner )
		Explosion(HitLocation);
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	bCanHitOwner = True;
	Velocity = 0.8*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	RandSpin(100000);
	speed = VSize(Velocity);
	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(ImpactSound, SLOT_Misc, FMax(0.5, speed/800) );
	if ( Velocity.Z > 400 )
		Velocity.Z = 0.5 * (400 + Velocity.Z);	
	else if ( speed < 20 ) 
	{
		bBounce = False;
		SetPhysics(PHYS_None);
	}
}

///////////////////////////////////////////////////////
function BlowUp(vector HitLocation)
{
	HurtRadius(damage, 400, 'exploded', MomentumTransfer, HitLocation);
	MakeNoise(1.0);
}

simulated function Explosion(vector HitLocation)
{
	local SpriteBallExplosion s;

	BlowUp(HitLocation);
  	s = spawn(class'SpriteBallExplosion',,,HitLocation);
	s.RemoteRole = ROLE_None;
 	Destroy();
}

defaultproperties
{
     Damage=130.000000
     Style=STY_Translucent
     Texture=Texture'UnrealShare.Effects.Arc1'
     Fatness=179
     bMeshEnviroMap=True
}
