//=============================================================================
// SeekerNali.
//=============================================================================
class SeekerNali expands Pack6Pawns;

#exec MESH IMPORT MESH=Nali1 ANIVFILE=MODELS\nali_a.3D DATAFILE=MODELS\nali_d.3D X=0 Y=0 Z=0 ZEROTEX=1
#exec MESH ORIGIN MESH=Nali1 X=00 Y=-130 Z=30 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=nali1 SEQ=All      STARTFRAME=0   NUMFRAMES=397
#exec MESH SEQUENCE MESH=nali1 SEQ=Backup   STARTFRAME=0   NUMFRAMES=10  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Bowing   STARTFRAME=10  NUMFRAMES=20  RATE=15 Group=Ducking
#exec MESH SEQUENCE MESH=nali1 SEQ=Breath   STARTFRAME=30  NUMFRAMES=8   RATE=6
#exec MESH SEQUENCE MESH=nali1 SEQ=Cough    STARTFRAME=38  NUMFRAMES=25  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Landed   STARTFRAME=68  NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=Cringe   STARTFRAME=63  NUMFRAMES=15  RATE=15 Group=Ducking
#exec MESH SEQUENCE MESH=nali1 SEQ=Dead     STARTFRAME=78  NUMFRAMES=38  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Dead2    STARTFRAME=116 NUMFRAMES=16  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Dead3    STARTFRAME=132 NUMFRAMES=13  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Dead4    STARTFRAME=145 NUMFRAMES=21  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Follow   STARTFRAME=166 NUMFRAMES=23  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=GetDown  STARTFRAME=189 NUMFRAMES=5   RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=GetUp    STARTFRAME=194 NUMFRAMES=8   RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=levitate STARTFRAME=202 NUMFRAMES=6  RATE=6
#exec MESH SEQUENCE MESH=nali1 SEQ=pray     STARTFRAME=208 NUMFRAMES=8   RATE=6
#exec MESH SEQUENCE MESH=nali1 SEQ=spell    STARTFRAME=216 NUMFRAMES=28  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Sweat    STARTFRAME=244 NUMFRAMES=18  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=walk     STARTFRAME=262 NUMFRAMES=20  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=GutHit   STARTFRAME=282 NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=AimDown  STARTFRAME=283 NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=AimUp    STARTFRAME=284 NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=Bow2     STARTFRAME=285 NUMFRAMES=28  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=HeadHit  STARTFRAME=313 NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=LeftHit  STARTFRAME=314 NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=RightHit STARTFRAME=315 NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=Run      STARTFRAME=316 NUMFRAMES=10  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=RunFire  STARTFRAME=326 NUMFRAMES=10  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=StilFire STARTFRAME=336 NUMFRAMES=1
#exec MESH SEQUENCE MESH=nali1 SEQ=WalkFire STARTFRAME=337 NUMFRAMES=20  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=WalkTool STARTFRAME=357 NUMFRAMES=20  RATE=15
#exec MESH SEQUENCE MESH=nali1 SEQ=Drowning STARTFRAME=377 NUMFRAMES=20  RATE=15

#exec MESH SEQUENCE MESH=nali1 SEQ=fighter STARTFRAME=0   NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JNali1 FILE=MODELS\nali.PCX GROUP=Skins 
#exec MESHMAP SCALE MESHMAP=nali1 X=0.069 Y=0.069 Z=0.138
#exec MESHMAP SETTEXTURE MESHMAP=nali1 NUM=0 TEXTURE=Jnali1

#exec MESH NOTIFY MESH=Nali1 SEQ=Dead TIME=0.46 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Nali1 SEQ=Dead2 TIME=0.64 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Nali1 SEQ=Dead3 TIME=0.84 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Nali1 SEQ=Dead4 TIME=0.51 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Nali1 SEQ=Backup TIME=0.25 FUNCTION=Step
#exec MESH NOTIFY MESH=Nali1 SEQ=Backup TIME=0.75 FUNCTION=Step
#exec MESH NOTIFY MESH=Nali1 SEQ=Walk   TIME=0.25 FUNCTION=Step
#exec MESH NOTIFY MESH=Nali1 SEQ=Walk   TIME=0.75 FUNCTION=Step

#exec AUDIO IMPORT FILE="Sounds\Nali\syl1.WAV" NAME="syl1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\syl2.WAV" NAME="syl2n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\syl3.WAV" NAME="syl3n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\syl4.WAV" NAME="syl4n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\syl5.WAV" NAME="syl5n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\syl6.WAV" NAME="syl6n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\follow1c.WAV" NAME="follow1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\injur1a.WAV" NAME="injur1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\injur2a.WAV" NAME="injur2n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\contct1a.WAV" NAME="contct1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\contct3a.WAV" NAME="contct3n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\fear1a.WAV" NAME="fear1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\breath2na.WAV" NAME="breath1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\death1na.WAV" NAME="death1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\death2a.WAV" NAME="death2n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\bowing1a.WAV" NAME="bowing1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\cringe2a.WAV" NAME="cringe2n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\backup2a.WAV" NAME="backup2n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\cough1na.WAV" NAME="cough1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\sweat1na.WAV" NAME="sweat1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Nali\levitF1.WAV" NAME="pray1n" GROUP="Nali"
#exec AUDIO IMPORT FILE="Sounds\Cow\walknc.WAV" NAME="walkC" GROUP="Cow"
#exec AUDIO IMPORT FILE="Sounds\Generic\teleprt27.WAV" NAME="Teleport1" GROUP="Generic"


var float ReCheck;
var() byte HitDamage;
var bool AttackSuccess;
var() bool bSpearToss;
var() bool bDicePlayer;
var() bool bSleeping;
var   bool bHasDice;
var	  bool bHeldDice;
var(Sounds) sound strike1;
var(Sounds) sound strike2;
var(Sounds) sound Spell;
var(Sounds) sound syllable1;
var(Sounds) sound syllable2;
var(Sounds) sound syllable3;
var(Sounds) sound syllable4;
var(Sounds) sound syllable5;
var(Sounds) sound syllable6;
var(Sounds) sound die2;
var(Sounds) sound HitSound;
var 	name phrase;
var		byte phrasesyllable;
var		float	voicePitch;
var()	float MinDuckTime;
var		float LastDuckTime;

function PreBeginPlay()
{
	bCanSpeak = true;
	voicePitch = 0.25 + 0.5 * FRand();
	if ( CombatStyle == Default.CombatStyle)
		CombatStyle = CombatStyle + 0.4 * FRand() - 0.2;
	bCanDuck = (FRand() < 0.5);
	Super.PreBeginPlay();
	if ( bDicePlayer )
		PeripheralVision = 1.0; 
	if ( Skill == 0 )
		ProjectileSpeed *= 0.85;
	else if ( Skill > 2 )
	{
		bCanStrafe = true;
		ProjectileSpeed *= 1.1;
	}
}

function ZoneChange(ZoneInfo newZone)
{
	bCanSwim = newZone.bWaterZone; //only when it must
		
	if ( newZone.bWaterZone )
		CombatStyle = 1.0; //always charges when in the water
	else if (Physics == PHYS_Swimming)
		CombatStyle = Default.CombatStyle;

	Super.ZoneChange(newZone);
}

function SetMovementPhysics()
{
	if ( Region.Zone.bWaterZone )
		SetPhysics(PHYS_Swimming);
	else if (Physics != PHYS_Walking)
		SetPhysics(PHYS_Walking); 
}

function TryToDuck(vector duckDir, bool bReversed)
{
	local vector HitLocation, HitNormal, Extent;
	local actor HitActor;

	//log("duck");
	
	if ( Level.TimeSeconds - LastDuckTime < (0.25 + 0.5 * FRand()) * MinDuckTime )
		return;	
	duckDir.Z = 0;
	if ( (Skill == 0) && (FRand() < 0.5) )
		DuckDir *= -1;	

	Extent.X = CollisionRadius;
	Extent.Y = CollisionRadius;
	Extent.Z = CollisionHeight;
	HitActor = Trace(HitLocation, HitNormal, Location + 128 * duckDir, Location, false, Extent);
	if (HitActor != None)
	{
		duckDir *= -1;
		HitActor = Trace(HitLocation, HitNormal, Location + 128 * duckDir, Location, false, Extent);
	}
	if (HitActor != None)
		return;
	
	HitActor = Trace(HitLocation, HitNormal, Location + 128 * duckDir - MaxStepHeight * vect(0,0,1), Location + 128 * duckDir, false, Extent);
	if (HitActor == None)
		return;
		
	//log("good duck");

	LastDuckTime = Level.TimeSeconds;
	SetFall();
	TweenAnim('Jump', 0.3);
	Velocity = duckDir * 1.5 * GroundSpeed;
	Velocity.Z = 200;
	SetPhysics(PHYS_Falling);
	GotoState('FallingState','Ducking');
}	

//=========================================================================================
// Speech


function SpeechTimer()
{
	//last syllable expired.  Decide whether to keep the floor or quit
	if (FRand() < 0.3)
	{
		bIsSpeaking = false;
		if (TeamLeader != None)
			TeamLeader.bTeamSpeaking = false;
	}
	else
		Speak();
}

function SpeakOrderTo(ScriptedPawn TeamMember)
{
	phrase = '';
	if ( !TeamMember.bCanSpeak || (FRand() < 0.5) )
		Speak();
	else  
	{
		if (SkaarjWarrior(TeamMember) != None)
			SkaarjWarrior(TeamMember).phrase = '';
		TeamMember.Speak();
	}
}

function SpeakTo(ScriptedPawn Other)
{
	if (Other.bIsSpeaking || ((TeamLeader != None) && TeamLeader.bTeamSpeaking) )
		return;
	
	phrase = '';
	Speak();
}

function Speak()
{
	local float decision;
	
	//if (phrase != '')
	//	SpeakPhrase();
	bIsSpeaking = true;
	decision = FRand();
	if (TeamLeader != None)	
		TeamLeader.bTeamSpeaking = true;
	if (decision < 0.167)
		PlaySound(Syllable1,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.333)
		PlaySound(Syllable2,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.5)
		PlaySound(Syllable3,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.667)
		PlaySound(Syllable4,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.833)
		PlaySound(Syllable5,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else 
		PlaySound(Syllable6,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);

	SpeechTime = 0.1 + 0.3 * FRand();
}
	
function PlayAcquisitionSound()
{
	if ( bCanSpeak && (TeamLeader != None) && !TeamLeader.bTeamSpeaking )
	{
		phrase = 'Acquisition';
		phrasesyllable = 0;
		Speak();
		return;
	}
	Super.PlayAcquisitionSound(); 
}

function PlayFearSound()
{
	if ( bCanSpeak && (TeamLeader != None) && !TeamLeader.bTeamSpeaking )
	{
		phrase = 'Fear';
		phrasesyllable = 0;
		Speak();
		return;
	}
	Super.PlayFearSound(); 
}

function PlayRoamingSound()
{
	if ( bCanSpeak && (TeamLeader != None) && !TeamLeader.bTeamSpeaking  && (FRand() < 0.5) )
	{
		phrase = '';
		Speak();
		return;
	} 
	Super.PlayRoamingSound();
}

function PlayThreateningSound()
{
	if ( bCanSpeak && (FRand() < 0.6) && ((TeamLeader == None) || !TeamLeader.bTeamSpeaking) )
	{
		phrase = 'Threaten';
		phrasesyllable = 0;
		Speak();
		return;
	} 
	Super.PlayThreateningSound();
}

//=========================================================================================
function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.IsA('SeekerNali') || Other.IsA('Nali') )
		return ATTITUDE_Friendly;
	else
		return ATTITUDE_Hate;
}

function PlayWaiting()
{
	local float decision;
	local float animspeed;
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}

	if ( bSleeping )
	{
		animspeed = 0.5 + 0.5 * FRand(); 
		SetAlertness(-1.0);
		PlayAnim('Dead', AnimSpeed );
		PlaySound(sound'Snore1K',SLOT_Talk);
		return;
	}

	decision = FRand();

	if ( bDicePlayer ) 
	{
		animspeed = 0.4 + 0.6 * FRand(); 
		SetAlertness(-1.0);
		
		if ( TeamLeader == None )
		{
			if ( decision < 0.9 )
				LoopAnim('Bowing', animspeed, 0.5);
			else
				LoopAnim('Breath', animspeed);
			return;
		}

		if ( !TeamLeader.bTeamSpeaking )
		{
			phrase = '';
			Speak();
		}
		PlayAnim('Follow', animspeed);
		return;
	}

	if (AnimSequence == 'Follow')
	{
		SetAlertness(0.0);
		if (!bQuiet && decision < 0.3) 
		{
			LoopAnim('Pray', 0.3 + 0.6 * FRand());
		    PlaySound(Spell,SLOT_Interact,0.5,,500);
		}	
		else 
			LoopAnim('Breath', 0.2 + 0.7 * FRand());
		return;
	}
 	else if (AnimSequence == 'Pray')
	{
 		SetAlertness(0.0);
 		if (decision < 0.5) 
		{
		    PlaySound(Spell,SLOT_Interact,0.5,,500);	
			LoopAnim('Spell', 0.3 + 0.6 * FRand());
		}
		else 
			LoopAnim( 'Breath', 0.2 + 0.7 * FRand());
		return;
	}
	
	if (decision < 0.2)
	{
		SetAlertness(0.5);
		LoopAnim('Pray', 0.2 + 0.7 * FRand());
	}
	else
	{
		SetAlertness(0.0);
		LoopAnim('Breath', 0.2 + 0.7 * FRand());
	}
}

function PlayPatrolStop()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
		
	if ( (AnimSequence == 'Breath') && (FRand() < 0.4) )
	{
		SetAlertness(0.5);
		LoopAnim('Pray', 0.2 + 0.7 * FRand());
		return;
	}
	else if ( !bQuiet && (AnimSequence == 'Pray') && (FRand() < 0.3) )
	{
		SetAlertness(0.0);
	    PlaySound(Spell,SLOT_Interact,0.5,,500);	
		LoopAnim('Spell', 0.3 + 0.6 * FRand());
		return;
	}
 	else if ( (AnimSequence == 'Spell') && (FRand() < 0.5) )
	{
 		SetAlertness(0.0);
	    PlaySound(Spell,SLOT_Interact,0.5,,500);	
		LoopAnim('Spell', 0.3 + 0.6 * FRand());
		return;
	}
	SetAlertness(0.0);
	LoopAnim('Breath', 0.2 + 0.7 * FRand());
}
	
function PlayWaitingAmbush()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if (FRand() < 0.4)
		LoopAnim('Pray', 0.3);
	else 
		LoopAnim('Breath', 0.3 + 0.5 * FRand());
}

function PlayChallenge()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if ( TryToCrouch() )
	{
		TweenAnim('GetUp', 0.12);
		return;
	}	
	PlayThreateningSound();
}

function PlayDive()
{
	TweenToSwimming(0.2);
}

function TweenToFighter(float tweentime)
{
	if ( bDicePlayer )
	{
		PeripheralVision = Default.PeripheralVision;
		bDicePlayer = false;
	}
	bSleeping = false;
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	TweenAnim('Fighter', tweentime);
}

function TweenToRunning(float tweentime)
{
	if ( bDicePlayer )
	{
		PeripheralVision = Default.PeripheralVision;
		bDicePlayer = false;
	}
	bSleeping = false;
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	if ( (AnimSequence == 'Spell') && IsAnimating() )
		return;
	if ( (AnimSequence != 'Run') || !bAnimLoop )
		TweenAnim('Run', tweentime);
}

function TweenToWalking(float tweentime)
{
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	TweenAnim('WalkTool', tweentime);
}

function TweenToWaiting(float tweentime)
{
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	if ( bDicePlayer ) 
	{
		TweenAnim('Breath', tweentime);
		return;
	}
	TweenAnim('Breath', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	TweenAnim('Breath', tweentime);
}

function TweenToFalling()
{
	TweenAnim('GetUp', 0.35);
}

function PlayInAir()
{
	TweenAnim('GetUp', 0.2);
}

function PlayOutOfWater()
{
	TweenAnim('GetDown',0.8);
}

function PlayLanded(float impactVel)
{
	TweenAnim('GetDown', 0.1);
}

function PlayMovingAttack()
{
	DesiredSpeed = 0.4;
	MoveTimer += 0.2;
	PlayAnim('Spell');
	SpawnShot();
}

function PlayRunning()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}

	DesiredSpeed = 1.0;
	if (Focus == Destination)
	{
		LoopAnim('Run', -1.0/GroundSpeed,, 0.4);
		return;
	}	
	LoopAnim('Run', StrafeAdjust(),,0.3);
}

function PlayWalking()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	LoopAnim('WalkTool', 0.88);
}

function TweenToSwimming(float tweentime)
{
	if ( (AnimSequence != 'Drowning') || !bAnimLoop )
		TweenAnim('Drowning', tweentime);
}

function PlaySwimming()
{
	LoopAnim('Drowning', -1.0/WaterSpeed,,0.3);
}

function PlayThreatening()
{
	local float decision, animspeed;

	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	decision = FRand();
	animspeed = 0.4 + 0.6 * FRand(); 

	if ( decision < 0.6 )
		PlayAnim('Breath', animspeed, 0.3);
	else if ( decision < 0.7 )
	{
	    PlaySound(Spell,SLOT_Interact,0.5,,500);	
		PlayAnim('Pray', animspeed, 0.3);
	}
	else 
	{
		PlayThreateningSound();
		if ( decision < 0.8 )
			PlayAnim('Bow2', animspeed, 0.3);
		else if ( decision < 0.9 )
			PlayAnim('Bow', 0.3, 0.3);
		else 
			TweenAnim('Fighter', 0.3);
	}
}

function PlayTurning()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	TweenAnim('Walk', 0.3);
}

function PlayBigDeath(name DamageType)
{
	PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
	PlayAnim('Dead2',0.7,0.1);
}

function PlayLeftDeath(name DamageType)
{
	PlayAnim('Dead4',0.7, 0.1);
	PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
	PlayAnim('Dead2',0.7,0.1);
	PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayGutDeath(name DamageType)
{
	PlayAnim('Dead',0.7,0.1);
	PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayVictoryDance()
{
    PlaySound(Spell,SLOT_Interact,0.5,,500);	
	PlayAnim('Bow', 0.5, 0.1);
}

function bool CanFireAtEnemy()
{
	local vector HitLocation, HitNormal,X,Y,Z, projStart, EnemyDir, EnemyUp;
	local actor HitActor;
	local float EnemyDist;
		
	EnemyDir = Enemy.Location - Location;
	EnemyDist = VSize(EnemyDir);
	EnemyUp = Enemy.CollisionHeight * vect(0,0,0.9);
	if ( EnemyDist > 300 )
	{
		EnemyDir = 300 * EnemyDir/EnemyDist;
		EnemyUp = 300 * EnemyUp/EnemyDist;
	}
	
	GetAxes(Rotation,X,Y,Z);
	projStart = Location + 0.9 * CollisionRadius * X - 0.7 * CollisionRadius * Y;
	HitActor = Trace(HitLocation, HitNormal, projStart + EnemyDir + EnemyUp, projStart, true);

	if ( (HitActor == None) || (HitActor == Enemy) 
		|| ((Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) <= ATTITUDE_Ignore)) )
		return true;

	HitActor = Trace(HitLocation, HitNormal, projStart + EnemyDir, projStart , true);

	return ( (HitActor == None) || (HitActor == Enemy) 
			|| ((Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) <= ATTITUDE_Ignore)) );
}
	
function SpawnShot()
{
	DesiredSpeed = 0.0; //For nali shoot2 (walking shoot, w/ pause)
	Spawn(class'EffectLight');
	Spawn(class'ParticleBurst2');
	FireProjectile( vect(0.9, -0.5, 0), 500);
}

function ShotMove()
{
	DesiredSpeed = 1.0;
}
	
function PlayMeleeAttack()
{
	local float decision;

	decision = FRand();
	if (!bSpearToss)
		decision *= 0.7;

	PlayAnim('Follow'); 
	if (MeleeDamageTarget(HitDamage, HitDamage * 500 * Normal(Target.Location - Location)))
		PlaySound(HitSound,SLOT_Interact);
}

function PlayRangedAttack()
{
	local float tweenin;
	
	if (Region.Zone.bWaterZone)
	{
		PlayAnim('Spell');
		SpawnShot();
		return;
	}
	if (AnimSequence == 'Spell')
		tweenin = 0.3 * FRand();
	else
		tweenin = 0.35;
	PlayAnim('Spell', 1.0, tweenin);
	SpawnShot();
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function TweenToRunning(float tweentime)
	{
		if ( bDicePlayer )
		{
			PeripheralVision = Default.PeripheralVision;
			bDicePlayer = false;
		}
		if (Region.Zone.bWaterZone)
		{
			TweenToSwimming(tweentime);
			return;
		}
		if ( bCanStrafe && (AnimSequence == 'Spell') && IsAnimating() )
			return;
		if ( (AnimSequence != 'Run') || !bAnimLoop )
			TweenAnim('Run', tweentime);
	}
}
simulated function Tick(float DeltaTime)
{
	local pawn p;
	
	ReCheck+=DeltaTime;
	if( ReCheck>2 )
	{
		ReCheck=0;
		CheckVisibleEnemys();
	}
}
function PlayDying(name DamageType, vector HitLoc)
{
	//first check for head hit
	if ( ((DamageType == 'Decapitated') || (HitLoc.Z - Location.Z > 0.5 * CollisionHeight))
		 && !Level.Game.bVeryLowGore )
	{
		PlayHeadDeath(DamageType);
		return;
	}
	Super.PlayDying(DamageType, HitLoc);
}

function PlayHeadDeath(name DamageType)
{
	local carcass carc;

	carc = Spawn(class 'CreatureChunks',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
	if (carc != None)
	{
		carc.Mesh = mesh'NaliHead';
		carc.Initfor(self);
		carc.Velocity = Velocity + VSize(Velocity) * VRand();
		carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
	}
	PlaySound(sound'Death2n', SLOT_Talk, 4 * TransientSoundVolume);
	PlayAnim('Dead3',0.5, 0.1);
}

defaultproperties
{
     hitdamage=153
     spell=Sound'UnrealShare.Nali.syl4n'
     syllable1=Sound'UnrealShare.Nali.syl1n'
     syllable2=Sound'UnrealShare.Nali.syl2n'
     syllable3=Sound'UnrealShare.Nali.syl3n'
     syllable4=Sound'UnrealShare.Nali.syl4n'
     syllable5=Sound'UnrealShare.Nali.syl5n'
     syllable6=Sound'UnrealShare.Nali.syl6n'
     Die2=Sound'UnrealShare.Nali.death1n'
     HitSound=Sound'UnrealShare.Nali.injur1n'
     MinDuckTime=1.000000
     TimeBetweenAttacks=0.500000
     Aggressiveness=1.000000
     RefireRate=0.500000
     bHasRangedAttack=True
     bMovingRangedAttack=True
     RangedProjectile=Class'Pack6.ExtraProj'
     Acquire=Sound'UnrealShare.Nali.contct1n'
     Fear=Sound'UnrealShare.Nali.fear1n'
     Roam=Sound'UnrealShare.Nali.breath1n'
     Threaten=Sound'UnrealShare.Nali.contct3n'
     MeleeRange=40.000000
     HitSound1=Sound'UnrealShare.Nali.injur1n'
     HitSound2=Sound'UnrealShare.Nali.injur2n'
     Die=Sound'UnrealShare.Nali.death1n'
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealShare.Nali1'
     DrawScale=0.250000
     CollisionRadius=6.500000
     CollisionHeight=12.000000
     Buoyancy=95.000000
}
